/*********************************************************************
	Frame Based Management Module

	Frame Buffer Management Routines
	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmbufif.c
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/28/91

	Copyright 1990,1991 XLNT Designs Inc.

	The FSP generates only one transmit frame at a time. To reduce
	memory management overhead, FSP uses one buffer to build
	out-going SMT frames throughout its execution. This buffer may
	be statically defined or dynamically allocated during FSP
	initialization. The buffer must be at least MAX_FRAME_SIZE
	bytes long and the first byte must start on a 32-bit boundary.

	Management of the received frame buffers is left to the
	frame reception interface. Since FSP does not know how frames
	are received, nor the best method for handling these buffers,
	no management is performed. When an SMT frame needs to be
	processed, the system passes a pointer to this frame to FSP.
	FSP only reads data from this buffer, no modification is done
	on the frame data or the buffer.

	When FSP is done with the received frame buffer, it calls the
	interface routine FreeFrameBuffer() to release the buffer.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"smterror.h"
#include	"fddihdr.h"
#include	"fbmmacro.h"
#include	"fbmhdr.h"
#include        "fbmframe.h"
#include        "fbmglbl.h"
#include        "drv.h"
#include        <pkt.h>
#include        "dbd.h"
#include        "dips.h"


/*********************************************************************
	Global Variables
*********************************************************************/
PKT *SMTFrameDBD_tx, *SMTFrameDBD_rx;

/*********************************************************************
	Frame Buffer Routines
*********************************************************************/

void
FreeFrameBuffer (buf)
	uChar	*buf;
/*********************************************************************
Function:	Releases the memory used by a frame buffer containing
		a RECEIVED SMT frame.
Parameters:	buf	= address of buffer to free.
Input:		None.
Output:		Implementor defined.
Return:		No value returned.
*********************************************************************/
{
   FBMDPT("$Free SMTFrameDBD$");
#if 0
   {
      extern int fault_cnt;
      fault_cnt = 1;
      printf("FBM: Free DBD in FreeFrameBuffer %x (%d).\n",
	     SMTFrameDBD_rx, SMTFrameDBD_rx->db_contrl);
      fault_cnt = 0;
   }
#endif
   FreePktBuf (SMTFrameDBD_rx);
   SMTFrameDBD_rx = 0L;
   return;
}

void
ClearFrameBuffer (buf)
	uChar	*buf;
/*********************************************************************
Function:	Clears the contents of a frame buffer to 0s.
Parameters:	buf	= address of buffer to clear.
Input:		None.
Output:		Clears contents of buffer to all 0s.
Return:		No value returned.
*********************************************************************/
{
        if ((!SMTFrameDBD_tx) && (get_debug() == DEBUG_ON))
	{
	     printf("FBM: Try to clear a null dbd buffer.\n");
	     asm("fmark");
	}
	MEMZERO (buf, SMTFrameDBD_tx->pktBufLen);
	return;
}

uInt32
InitFBMFrameBuffer (bufptr)
	uChar	**bufptr;
/*********************************************************************
Function:	Initialize the frame buffer management interface.
Parameters:	bufptr	= address of pointer to hold address of buffer.
Input:		Local option.
Output:		bufptr	= set to address of frame buffer.
Return:		0 return if successful, otherwise an error code is
		returned.
*********************************************************************/
{
#ifdef __FEBRIDGE
   register word saveMask;
#endif
   PKT *tmp;
   uInt32 count = 0;

   SMTFrameDBD_tx = NULL;

   while (!SMTFrameDBD_tx)
   {
#ifdef __FEBRIDGE
      MaskAllInts(saveMask);
#endif
      if (tmp = (PKT *)MEM_GetPkt())
      {
	 SMTFrameDBD_tx = tmp;
#ifdef __FEBRIDGE
	 RestoreIntMask(saveMask);
#endif
	 break;
      }
#ifdef __FEBRIDGE
	 RestoreIntMask(saveMask);
#endif
      
      if ((++count & 0x0100) && (get_debug() == DEBUG_ON))
      {
	 printf("InitFBMFrameBuffer: No free DBD.\n");
      }
      ReSchedule();
   }

   *bufptr = (uChar*) SMTFrameDBD_tx->pktBufPtr;

   return (0);
}

void CheckSMTDBDBuffer()
{
   PKT *tmp;
   uInt32 count = 0;

   if (SMTFrameDBD_tx)
      return;

   /*
    *   Reallocating Tx Frame Buffer
    */

   while (!SMTFrameDBD_tx)
   {
      if (tmp = (PKT *)MEM_GetPkt())
      {
	 SMTFrameDBD_tx = tmp;
	 break;
      }

      if ((++count & 0x0100) && (get_debug() == DEBUG_ON))
      {
	 printf("CheckSMTDBDBuffer: No free DBD.\n");
      }
      ReSchedule();
   }

   fbmFrameBuffer = (uChar*) SMTFrameDBD_tx->pktBufPtr;

   fbmFrameHeader = (SMTFrameHdrType *) fbmFrameBuffer;

}

/*
*	Note: If FSP can stop executing, an exit routine might be 
*	appropriate. This routine would release the memory for
*	the transmit buffer if necessary.
*/


void
ExitFBMFrameBuffer()
/*********************************************************************
Function:	Exit the frame buffer management interface.
Parameters:	None.
Input:		Global pointer to frame buffer.
Output:		Local option.
Return:		0 return if successful, otherwise an error code is
		returned.
*********************************************************************/
{
   if (SMTFrameDBD_tx)
   {
      FreePktBuf(SMTFrameDBD_tx);
   }

   if (SMTFrameDBD_rx)
   {
      FreePktBuf(SMTFrameDBD_rx);
   }

   return;
}

