/*********************************************************************
	Frame Based Management Module

	Frame Interface Routines

	THIS MODULE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmfrmif.c
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	This module provides the interface routines to handle
	the sending and receiving for frames.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/
#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smterror.h"
#include	"fbmframe.h"
#include	"fbmmacro.h"
#include	"fbmglbl.h"
#include        <pkt.h>
#include        "dbd.h"
#include        "msgutil.h"
#include        "drv.h"


/*********************************************************************
	Frame Interface External Functions
*********************************************************************/


/*********************************************************************
	Frame Interface Defined Values
*********************************************************************/


/*********************************************************************
	Frame Interface Global Values
*********************************************************************/
extern PKT *SMTFrameDBD_tx, *SMTFrameDBD_rx;

/*********************************************************************
	Frame Interface Support Routines
*********************************************************************/


/*********************************************************************
	Frame Interface Routines
*********************************************************************/

void
SendSMTFrame (frameBuffer, frameLength, MACNum)
	uChar	*frameBuffer;
	uInt16	frameLength;
	uInt16	MACNum;
/*********************************************************************
Function:	Receive an SMT frame from the network.
Parameters:	frameBuffer	= address of buffer containing frame.
		frameLength	= frame length.
		MACNum		= output MAC index.
Input:		frameBuffer	= contains frame to send.
Output:		None.
Return:		None.
*********************************************************************/
{
   TLVParamType mibData;
   uInt32 result;

   /*
    * Check if MAC is available.
    */
   GET_FDDI_MIBATTR(fddiMACRMTState, mibData, MACNum);
   if ((mibData.MACPARAM8 != RM_RING_OP)
       && (mibData.MACPARAM8 != RM_RING_OP_DUP))
   {
      return;
   }

   FBMDPT("$FBM:Sending SMTFrame$");
   SMTFrameDBD_tx->pktDataSize = frameLength;
   SMTFrameDBD_tx->pktDataPtr = SMTFrameDBD_tx->pktBufPtr + FC_PAD_SIZE;
#ifdef __FEBRIDGE
   /* bridge configures ACR to swap the addresses field by H/W */

   swap_bits(SMTFrameDBD_tx->pktDataPtr+1,6);
   swap_bits(SMTFrameDBD_tx->pktDataPtr+7,6);

   DRV_SendFrame(SMTFrameDBD_tx, MACNum, DRV_REQ_RQCLS_ASYN);
#endif

#if 0
   {
      extern int fault_cnt;
      fault_cnt = 1;
      printf("FBM: Free the tx DBD %x (%d).\n", SMTFrameDBD_tx, 
	     SMTFrameDBD_tx->db_contrl);
      fault_cnt = 0;
   }
#endif		 
   SMTFrameDBD_tx->pktFree(SMTFrameDBD_tx);

   InitFBMFrameBuffer (&fbmFrameBuffer);

   fbmFrameHeader = (SMTFrameHdrType *) fbmFrameBuffer;

   return;
}

uInt32
InitFBMFrame ()
/*********************************************************************
Function:	Initialize system for processing SMT frames.
Parameters:	None.
Input:		None.
Output:		Sets system for frame processing.
Return:		0 if successful, error number if failed.
*********************************************************************/
{
	return (0);
}

