/*********************************************************************
	Frame Based Management Module

	Local Processing Module

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmlocal.c
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/28/91

	Copyright 1990,1991 XLNT Designs Inc.

	This module contains all implementor initialization and
	enhancment routines.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include        "fbmglbl.h"
#include        "smtmsgim.h"
#include        "mibtypes.h"
#include        "mibglbl.h"

/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/
static Flag frameTracing;
uChar LLCActive[MAX_MAC_COUNT], MACActive[MAX_MAC_COUNT];

/*********************************************************************
	External Functions
*********************************************************************/
extern uInt32    TimeStampEnable;

/*********************************************************************
	FBM Processing Routines
*********************************************************************/

uInt32
LocalFBMMessages (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Process messages not handled through standard FBM
		message processing.
Parameters:	smtmsg	= address of SMT message buffer.
Input:		smtmsg	= contains message to process.
Output:		Implementor defined.
Return:		Return values are reserved. The routine should
		currently return 0.
*********************************************************************/
{
uInt32	result = 0;

   switch (smtmsg->type)
   {
   case FBM_ACTION_FRAME_TRACE:
        frameTracing = smtmsg->data.b8;
        break;

   case FBM_ACTION_PROMISCUOUS:
        break;

   default:
	result = -1;
	break;
   }

   return (result);
}

uInt32
LocalFBMFrames (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:	Local processing of valid received SMT frames. This
		routine is called after the standard SMT processing
		has occurred. The frame is known to be a valid SMT
		frame and all standard protocol processing has already
		been handled by ProcessFBMFrame(). This routine can be
		used to implement a frame trace utility, accumulate SMT
		frame statistics, etc.
Parameters:	memPtr		= pointer to buffer containing frame
		frameLen        = length of frame data
		MACNum		= index of MAC that received frame
		EACbits		= received E, A, and C indicators
Input:		memPtr		= contains frame including pad bytes
Output:		Implementor defined.
Return:		Return values are reserved. Should always return 0.
*********************************************************************/
{
   static uInt32	lastID = 0;
   SMTFrameHdrType	*h;

   if (frameTracing)
   {

      h = (SMTFrameHdrType *) memPtr;
      lastID = h->smtHdr.Transaction_ID;

      PassMAPFrame (FBM_EVENT_FRAME_TRACE,
		    memPtr, frameLen, MACNum, EACbits);
   }

   return (0);
}

void
ProcessLocalTick ()
/*********************************************************************
Function:	Provide local timed processing support. This routine
		is called every FMB_CLOCK_TICK seconds.
Parameters:	None.
Input:		Local option.
Output:		Local option.
Return:		None.
*********************************************************************/
{
	return;
}

uInt32
InitFBMLocal ()
/*********************************************************************
Function:	Provide local initialization support. Such support can
		include hardware initialization, local data
		initialization, and system interfaces.
Parameters:	None.
Input:		None.
Output:		None.
Return:		0 if initialization is successful, otherwise an error
		code is returned.
*********************************************************************/
{
   uInt32 result, i;

   result = InitFBMMIBData();
   TimeStampEnable = TRUE;
   for (i=0; i < MAX_MAC_COUNT; i++)
   {
      ENABLE_LLC_SERVICE(i);
      ENABLE_MAC_SERVICE(i);
   }

   /*   Overwrite the initial value in fbminit.c */
   fbmStationData.useAuthorization = SET;

   return (result);
}

