/*********************************************************************
	Frame Based Management Module
	
	System Environment Interface Routines

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmsysif.c
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This module provides the interface routines to services
	provided by the system environment.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/


/*********************************************************************
	External System Interface Routines
*********************************************************************/


/*********************************************************************
	System Interface Defined Values
*********************************************************************/


/*********************************************************************
	System Interface Routines
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"fbmhdr.h"
#include	"fbmmacro.h"


/*********************************************************************
	External System Interface Routines
*********************************************************************/


/*********************************************************************
	System Interface Defined Values
*********************************************************************/
/*
 * FSP timer interrupts every 10ms
 */
#define TIMER_INTERVAL 10

/*
 * 10ms = 62500 timer clock ticks
 */

#define CLOCK_INTERVAL ((uInt16) (uS_2_TICKS (TIMER_INTERVAL * 1000)))


/*********************************************************************
	System Interface Routines
*********************************************************************/

/*
 * FBMTimerInterrupt()
 *	This routine is called in response to a 10 millisecond
 *	clock tick.  It accumulates these events together and
 *	signals TRUE when FBM's clock tick is reached.
 */
int
FBMTimerInterrupt()
{
/*
 * FBM_CLOCK_TICK is in units of seconds
 * FBMTimeLeft    is in units of milliseconds
 */

   static int  FBMTimeLeft = FBM_CLOCK_TICK * 1000;

   FBMTimeLeft -= TIMER_INTERVAL;
   if (FBMTimeLeft <= 0) {
      FBMTimeLeft = FBM_CLOCK_TICK * 1000;
      return (TRUE);
   }
   return (FALSE);
}


uInt32
InitFBMTimer ()
/*********************************************************************
Function:	Initialize the FSP system timer.
Parameters:	None.
Input:		None.
Output:		None.
Return:		0 if successful, otherwise an error code.
*********************************************************************/
{
	return (0);
}


/*********************************************************************
	Authorization Interface Routines
*********************************************************************/

#define	AUTHORIZE_STR	"HLS FDDI_CON SMT 6.2"
#define	AUTHORIZE_LEN	(strlen (AUTHORIZE_STR))

Flag
VerifyAuthorization (uChar *aBuffer, uInt16 aLen)
/*********************************************************************
Function:	Takes the contents of the Authorization parameter and
		checks to see if it passes the authentication routine.
Parameters:	aBuffer	= pointer to start of Authorization value.
		aLen	= length (in bytes) of aBuffer.
Input:		aBuffer	= contains the octet string of the Authorization
				parameter.
Output:		None.
Return:		SET	= authentication passed.
		CLEAR	= authentication failed.
*********************************************************************/
{
	if (aLen == AUTHORIZE_LEN)
	{
		if (strcmp (aBuffer, AUTHORIZE_STR) == 0)
			return (SET);
	}

	return (CLEAR);
}

uInt16
BuildAuthorization (uChar *aBuffer)
/*********************************************************************
Function:	Creates the contents of the Authorization parameter.
Parameters:	aBuffer	= points to start of Authorization value in
			parameter.
Input:		None.
Output:		aBuffer	= contains octet string of the Authorization value.
Return:		Length (in bytes) of the contents in aBuffer.
Notes:		Length must be a multiple of 4.
*********************************************************************/
{
	MEMCOPY (aBuffer, AUTHORIZE_STR, AUTHORIZE_LEN);
	return (AUTHORIZE_LEN);
}
