/*********************************************************************
	Frame Based Management Header File
	
	FSP Macro File

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmmacro.h
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This is the header file used throughout the FSP modules. This 
	file defines C macros used to make the FSP source code portable.
	The macros listed here are to be provided by implementor.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

/*********************************************************************
	Implementor Provided Macros
*********************************************************************/

/*
*	Processor State
*	Throughout the CSP portion of the SMT system, the system interrupts
*	will need to be disabled and enabled. This variable type defines
*	a variable large enough to hold the processor state information
*	required to change the interrupt settings.
*/
#ifndef __FDDI_FBMMACRO_H
#   define __FDDI_FBMMACRO_H

typedef	int	ProcState;

/*********************************************************************
macro	MDisableInterrupts (pState)

Function:	Set the system or processor state to disable interrupt
		processing for FBM interrupts.
Parameters:	pState	= address of buffer to hold current interrupt
			or processor state.
Input:		None.
Output:		pState	= contains current interrupt or processor state.
Return:		No value returned.
Notes:		Since interrupt processing is completely system dependent,
		the implementor must provide a facility for disabling
		interrupt processing. When FBM uses this macro to disable
		interrupts, it stores the current state and restores the
		current state to enable interrupts (see MRestoreInterrupts()).
Modification History:
*********************************************************************/
#define	MDisableInterrupts(pState)\
		;


/*********************************************************************
macro	MRestoreInterrupts (pState)

Function:	Restore interrupt processing to a previous state.
Parameters:	pState	= address of buffer containing previous interrupt state.
Input:		pState	= containes interrupt state to restore to.
Output:		None.
Return:		No value returned.
Notes:		When interrupts are disabled in FBM, the previous interrupt
		level is remember. When the critical code section completes
		execution, the FBM code restore the interrupt processing
		state.
Modification History:
*********************************************************************/
#define	MRestoreInterrupts(pState)\




/**********************************************************************
 *
 */
		;
#endif /* __FDDI_FBMMACRO_H */
