/**********************************************************************
	Management Information Base Header File

	Basic MIB initialization definitions.

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		mibconf.h
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	Configuration information for the Management Information
	Base.  The MIB is the repository for information about a 
	station.  It contains such information as the number of MACs
	and PHYs, the type of station (station or concentrator), and
	operational parameters such as T-Requested.  This file is modified
	for each implementation to contain values which are constant
	throughout the particular implementation.  For example the 
	number of MACs contained in a particular station should remain
	constant, so that value is defined here. 

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/
#ifndef __FDDI_MIBCONF_H
#   define __FDDI_MIBCONF_H
/*
*	The manufacturers Organizationally Unique Identifier (OUI) is an IEEE
*	assigned value which should come from the block of IEEE 48 bit
*	addresses assigned to this manufacturer.
*/
#define	MYMANUFOUI "\x00\x01\xdd"

/*
*	The manufacturers Data field is left up to the vendor to supply.
*/
#define	MYMANUFDATA "Hughes LAN Systems, Inc"

/*
*	The user data field is left up to each implementor to define
*	as they see fit.
*/
#define	MYUSERDATA "Hughes LAN Systems' User Data"

/*
*	The configuration policy enforced by this station is defined
*	below.  Currently we enforce no policies.
*/
#define MYCONFIGPOLICY 0

/*
*	The connection policy enforced by this station is defined
*	below.  Currently we enforce no policies.
*/
#define MYCONNECTPOLICY 0

#define	RMT_DUP1_POLICY		RMT_DUP_LEAVE
#define	RMT_DUP2_POLICY		RMT_DUP_LEAVE

#define	PHYCONNECTPOLICY	0

#define	LERCUTOFF		7
#define	LERALARM		8

/*
*	Default station values.
*	These values are given as FddiTimerTwosComplements.
*/
#define	DEFAULT_TMAX_LOWERBOUND	0xFF000000
#define	DEFAULT_TVX_LOWERBOUND	0xFF000000
#define	DEFAULT_TREQ		0xFFE00000
#define	DEFAULT_TMAX		0xFFE00000
#define	DEFAULT_TVX		0xFFFF8000
#define	DEFAULT_TMIN		0xFFFFC350
#define	DEFAULT_TPRI0		0
#define	DEFAULT_TPRI1		0
#define	DEFAULT_TPRI2		0
#define	DEFAULT_TPRI3		0
#define	DEFAULT_TPRI4		0
#define	DEFAULT_TPRI5		0
#define	DEFAULT_TPRI6		0
#define NO_OF_TPRI              7
#define DEFAULT_REPORT_LIMIT    5     /*  SMT default value */
#define DEFAULT_LER_CUTOFF      7
#define DEFAULT_LER_ALARM       8

/*
 * Minimum Timer values
 */
#define MIN_TVX                 (uTime) 235000
#define MIN_T_MAX               (uTime) 165000

/*
 * Default Mib Threshold Values
 */
#define DEF_NOT_COPIED_THRESHOLD 10
#define DEF_FRAME_ERROR_THRESHOLD 10

#endif /* __FDDI_MIBCONF_H */
