/*********************************************************************
	Station Management Header File

	SMT Macro File

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.
	
	File:		smtmacro.h
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This is the header file used throughout the SMT modules. This 
	file defines C macros used to make the SMT source code portable.
	The macros should be reviewed by the implementor to insure that
	the target C and operating system environment will perform as
	expected.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/
#ifndef __FDDI_SMTMACRO_H
#   define __FDDI_SMTMACRO_H

#include "fddi.h"

/*********************************************************************
	Standard C Macros
*********************************************************************/

/*********************************************************************
macro	MSetBit (variable, bit, state)

Function:	Set or clear a bit in an integer variable.
Parameters:	variable	= the variable to change.
		bit		= bit number 0-based from right to left.
		state		= SET to set bit to 1, CLEAR to clear bit to 0.
Input:		None.
Output:		variable contains bit changed to new setting.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/

#define	MSetBit(variable, bit, state)\
		(variable =\
			(state) ? variable | (1 << bit) : variable & ~(1 << bit))


/*********************************************************************
macro	MReadBit (variable, bit)

Function:	Read setting of a bit in an integer.
Parameters:	variable	= integer value to read.
		bit		= bit number 0-based from right to left.
Input:		None.
Output:		None.
Return:		TRUE if bit is set to 1, FALSE if bit is set to 0.
Notes:		None.
Modification History:
*********************************************************************/

#define	MReadBit(variable, bit)\
		((variable & (1 << bit)) != 0)


/*********************************************************************
macro	MEMCOPY (destination, source, length)

Function:	Copy chars in memory.
Parameters:	destination	= address of target buffer.
		source		= address of source buffer.
		length		= number of chars to transfer.
Input:		None.
Output:		Sets destination contents to contain same contents as source.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/

#define	MEMCOPY(destination, source, length)\
		memcpy (destination, source, length)


/*********************************************************************
macro	MEMZERO (destination, length)

Function:	Clear length chars in memory.
Parameters:	destination	= address of target buffer.
		length		= number of chars to clear to zero.
Input:		None.
Output:		Sets length chars starting at destination to zero.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/

#define	MEMZERO(destination, length)	memset (destination, '\0', length)


/*********************************************************************
macro	GETMEMORY (size)

Function:	Get a block of memory size bytes in length.
Parameters:	size	= number of chars in memory block.
Input:		None.
Output:		None.
Return:		Pointer to contiguous block of memory containing at least
		size chars.
		NULL returned if memory allocation fails.
Notes:		None.
Modification History:
*********************************************************************/

#define	GETMEMORY(size) (void *) lmalloc (size)


/*********************************************************************
macro	FREEMEMORY (buf)

Function:	Free a block of memory allocated by GETMEMORY().
Parameters:	buf	= address of memory block to free.
Input:		None.
Output:		None.
Return:		None.
Notes:		None.
Modification History:
*********************************************************************/

#define	FREEMEMORY(buf) free (buf)


/*********************************************************************
macro	MCopyAddress (destination, source)

Function:	Copy an FDDI address.
Parameters:	destination	= address of target buffer.
		source		= address of source buffer.
Input:		None.
Output:		Sets destination to contain same address as source.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/

#define	MCopyAddress(destination, source)\
		MEMCOPY (destination, source, sizeof (MACAddr48))


/*********************************************************************
macro	MCompareAddress (a1, a2, result)

Function:	Compare two FDDI addresses.
Parameters:	a1, a2	= address of buffer containing MAC addresses to
				compare.
Input:		None.
Output:		None.
Return:		Same value as strcmp().
Notes:		None.
Modification History:
*********************************************************************/

#define	MCompareAddress(a1, a2, result)\
	{\
	int	i;\
		result = 0;\
		for (i = 0; i < 6; i++)\
		{\
			if ((a1)[i] < (a2)[i])\
			{\
				result = -1;\
				break;\
			}\
			else if ((a1)[i] > (a2)[i])\
			{\
				result = 1;\
				break;\
			}\
		}\
	}


/*********************************************************************
macro	MFddi2Usecs (t)

Function:	Convert an FDDI time value (80ns interval count) to
		microseconds.
Parameters:	t	= FDDI time value to convert.
Input:		None.
Output:		None.
Return:		Value converted to microseconds.
Notes:		None.
Modification History:
*********************************************************************/

#define	MFddi2Usecs(t)	((t * 2) / 25)


/*********************************************************************
macro	MUsecs2Fddi (t)

Function:	Convert microseconds into an FDDI time value (80ns
		interval count).
Parameters:	t	= time value in microseconds to convert.
Input:		None.
Output:		None.
Return:		Value converted to 80ns FDDI time.
Notes:		None.
Modification History:
*********************************************************************/

#define	MUsecs2Fddi(t)	((t * 25) / 2)

/*********************************************************************
macro	GetSMTMibAttr (MibType, buffer)

*********************************************************************/
#define GET_SMT_MIBATTR(MibType, buffer)                       \
                buffer.paramType = MibType;                  \
                GetMIBAttr(sizeof(buffer), (uChar*) &buffer, \
			   (SetCountType*) NULL);

/*********************************************************************
macro	GetFDDIMibAttr (MibType, buffer, entity)

*********************************************************************/
#define GET_FDDI_MIBATTR(MibType, buffer, entity)              \
                buffer.paramValue.otherAttr.paramIndex.data = entity+1; \
                GET_SMT_MIBATTR(MibType, buffer);

#ifdef __SMT_DEBUG 
#   define SMTDPT(print_statement)   printf(print_statement);

#   define SMTDPT1(print_statement,a)   printf(print_statement,a);

#   define SMTDPT2(print_statement,a,b)   printf(print_statement,a,b);

#else
#   define SMTDPT(print_statement) 
#   define SMTDPT1(print_statement,a) 
#   define SMTDPT2(print_statement,a,b) 
#endif 

#ifdef __MIB_DEBUG 
#   define MIBDPT(print_statement)   printf(print_statement);
#else
#   define MIBDPT(print_statement)   
#endif 

#ifdef __CSP_DEBUG 
#   define CSPDPT(print_statement)   printf(print_statement);
#   define CSPDPT1(print_statement,a)   printf(print_statement,a);
#   define CSPDPT2(print_statement,a,b)   printf(print_statement,a,b);
#   define CSPDPT3(print_statement,a,b,c)   printf(print_statement,a,b,c);
#else
#   define CSPDPT(print_statement)   
#   define CSPDPT1(print_statement,a)   
#   define CSPDPT2(print_statement,a,b)   
#   define CSPDPT3(print_statement,a,b,c)   
#endif 

#ifdef __FBM_DEBUG 
#   define FBMDPT(print_statement)   printf(print_statement);
#   define FBMDPT1(print_statement,a)   printf(print_statement,a);
#   define FBMDPT2(print_statement,a,b)   printf(print_statement,a,b);
#   define FBMDPT3(print_statement,a,b,c)   printf(print_statement,a,b,c);
#   define FBMDPT4(print_statement,a,b,c,d)   printf(print_statement,a,b,c,d);
#else
#   define FBMDPT(print_statement) 
#   define FBMDPT1(print_statement,a)   
#   define FBMDPT2(print_statement,a,b)   
#   define FBMDPT3(print_statement,a,b,c)   
#   define FBMDPT4(print_statement,a,b,c,d)   
#endif 

#ifdef __MAP_DEBUG 
#   define MAPDPT(print_statement)   printf(print_statement);
#   define MAPDPT1(print_statement,a)   printf(print_statement,a);
#   define MAPDPT2(print_statement,a,b)   printf(print_statement,a,b);
#   define MAPDPT3(print_statement,a,b,c)   printf(print_statement,a,b,c);
#   define MAPDPT4(print_statement,a,b,c,d)   printf(print_statement,a,b,c,d);
#else
#   define MAPDPT(print_statement) 
#   define MAPDPT1(print_statement,a)   
#   define MAPDPT2(print_statement,a,b)   
#   define MAPDPT3(print_statement,a,b,c)   
#   define MAPDPT4(print_statement,a,b,c,d)   
#endif 

extern uChar LLCActive[], MACActive[];

#define ENABLE_LLC_SERVICE(macID)   LLCActive[macID] = TRUE; \
                                    mib->MACStatusGrp[macID].LLCServiceAvailable = SET;
#define DISABLE_LLC_SERVICE(macID)  LLCActive[macID] = FALSE; \
                                    mib->MACStatusGrp[macID].LLCServiceAvailable = CLEAR;

#define ENABLE_MAC_SERVICE(macID)   MACActive[macID] = TRUE
#define DISABLE_MAC_SERVICE(macID)  MACActive[macID] = FALSE

#endif /* __FDDI_SMTMACRO_H */
