/*********************************************************************
	SMT Header File
	
	SMT Definitions Header File

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.
	
	File:		smtdefs.h
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/29/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	ALL RIGHTS RESERVED. THE SOURCE FILES DISTRIBUTED WITH THE
	XLNT Manager(tm) SYSTEM ARE THE SOLE PROPERTY OF XLNT Designs,
	Inc. AND CONTAIN CONFIDENTIAL AND PROPRIETARY INFORMATION.
	REPRODUCTION OR DUPLICATION BY ANY MEANS OF ANY PORTION OF
	THIS SOFTWARE WITHOUT PRIOR WRITTEN CONSENT OF XLNT Designs,
	Inc. IS EXPRESSLY FORBIDDEN.
	
	This header file is used by all SMT modules. This file contains
	definitions for all SMT system dependent values like number of
	PHYs and MACs.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

/*********************************************************************
	Type Definitions
*********************************************************************/
#ifndef __FDDI_SMTDEFS_H
#   define __FDDI_SMTDEFS_H
#   include "fddi.h"

/*********************************************************************
	System Definitions
*********************************************************************/

/*
*	Line State Values
*	Each line state must correspond to an individual bit in an
*	integer value.
*/
#define	Noise_Line_State		0x10
#define	Master_Line_State		0x08
#define	Idle_Line_State			0x01
#define	Super_Idle_Line_State		0x40
#define	Halt_Line_State			0x04
#define	Quiet_Line_State		0x02
#define	Active_Line_State		0x104
#define	Transmit_PHY_Data_Request	0x100

/*
*	E, A, and C indicator bit positions.
*	The frame interface routines must provide the E, A, and C
*	indicator values with all frames received. The indicator
*	values will be passed to the frame services process as a
*	bit string. These defined values determine the bit positions
*	of each indicator.
*/
#define	E_Bit_Position	0x02
#define	A_Bit_Position	0x80
#define	C_Bit_Position	0x01

/*
*	Losing bid T_Req value.
*	This value is used for Change_Actions in RMT where the MAC is
*	configured to lose the claim process during duplicate address
*	detections.
*/
#define	Jam_T_Req_Value	(-(uInt32) 0x7FFFFFFF)


/*********************************************************************
*	Operational Limitations
*	These value determine the limits of the SMT software.
*********************************************************************/

/*
*	CSP Signal queue limitations
*/
#define	MAX_SIG_QUEUE_SIZE	(MAX_PORT_COUNT*300)

/*
*	FBM Action queue limitations
*/
#define	MAX_FBM_QUEUE_SIZE	32

/*
*	Timer list limitations
*/
#define	MAX_TIMER_LIST_SIZE	(MAX_PORT_COUNT*6)

#define	MIN_USECS		0


/*********************************************************************
*	System Configurations
*	These values describe the target environment for the SMT software.
*********************************************************************/

/*
*	The bit format used by the processor must be known.
*	Either BIG_ENDIAN or LITTLE_ENDIAN must be defined.
*	Do not define both.
*/
#define	LITTLE_ENDIAN
/* #define	BIG_ENDIAN */

#define	WORDSIZE	4

/*
*	Padding sizes.
*	The padding size moves the first character of the frame buffer
*	into the last byte of a word. This first character of the frame
*	buffer is used by the FC field which is usually handled
*	separately from the rest of the frame. By forcing this type of
*	alignment, the remaining data in the frame starts on a word
*	boundary, thus making data transfers easier and more efficient.
*/
#define	FC_PAD_SIZE	3


#endif /* __FDDI_SMTDEFS_H */
