/*********************************************************************
	Type Definitions used by FDDI Concentrator
*********************************************************************/
#ifndef __FDDI_TYPEDEFS_H
#   define __FDDI_TYPEDEFS_H

#include <types.h>
#include "constant.h"

/*
*	Integer Definitions
*	The target environment must be able to support 16- and 32-bit
*	signed and unsigned integer values.
*/
typedef	short		Int16;
typedef	unsigned short	uInt16;

typedef	long		Int32;
typedef	unsigned long	uInt32;

typedef	unsigned int	uInt;
typedef unsigned char   uByte;
typedef char            Byte;

/*
*	Character Definitions
*	The C type "char" is assumed to be a signed 8-bit value.
*/
typedef	unsigned char	uChar;


/*
*	Boolean Definitions
*	A Boolean variable may take on one of two values. The FDDI SMT
*	uses the term "flag" for Boolean variables. A flag may either be
*	set or cleared. The constant SET is equivalent to a logical
*	TRUE and the constant CLEAR is a logical FALSE.
*/
typedef	short	Flag;

typedef void (*MallocFuncVector()) (size_t);

typedef struct SignalMsgType
{
   uInt16 type;
   uInt32 data;
   /* entity can be got from dev_num in GenericMsgType */
} SignalMsgType;


#endif /* __FDDI_TYPEDEFS_H */


















