/*********************************************************************
	Management Information Base Module

	Local Processing Module

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		miblocal.c
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	This module contains all implementor initialization and 
	enhancment routines.

	Modification History:

	*** Updated to SMT 6.2 ***

        $Log:   /usr/shasta/pvcs/fddicon/smt/dp83200if/mib/miblocal.c_v  
 * 
 *    Rev 1.13   02 Aug 1993 17:47:24   jlin
 * Add macTREQ in drv_mib
 * 
 *    Rev 1.12   27 Jul 1993 17:52:04   jlin
 * 
 *    Rev 1.11   26 Jul 1993 18:36:24   jlin
 * Initialize the fddiATTACHMENTInsertPolicy according to the value
 * of fddiATTACHMENTOpticalBypassPresent
 * 
 *    Rev 1.10   16 Apr 1993 11:52:28   jang
 * added code to let driver mib points to RMTState directly
 * 
 *    Rev 1.9   02 Apr 1993 16:53:18   jlin
 * 
 *    Rev 1.8   22 Mar 1993 10:03:10   gregs
 * ifdef to set board_id if fddi-eth bridge
 * 
 *    Rev 1.7   12 Feb 1993 15:43:08   jlin
 * 
 *    Rev 1.6   08 Feb 1993 11:47:22   jlin
 * 
 *    Rev 1.5   05 Feb 1993 14:29:36   jlin
 * 
 *    Rev 1.4   18 Dec 1992 17:05:44   jang
 * chagned the board id to FDDICON_MASTER, still hard coded. It should be
 * read from EEPROM during bootup.

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include        "mibdefs.h"
#include        "mibtypes.h"
#include        "mibglbl.h"
#include        "ifglobal.h"
#include	"nvrecs.h"
#include        "drv.h"
#include        "miscsmtmib.h"



/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/
SMTStationIdType *ThisStationId;
SMT_PRIVATE_MAC_OBJECTS  SmtMibMacObjects[MAX_MAC_COUNT];
SMT_PRIVATE_PORT_OBJECTS SmtMibPortObjects[MAX_PORT_COUNT];

/*********************************************************************
	External Functions
*********************************************************************/


/*********************************************************************
	FBM Processing Routines
*********************************************************************/
void MIB_InitDrvMibs(drv_mib)
DRV_INIT_MIB *drv_mib;
{
   uInt16 i;

#ifdef __FEBRIDGE
   drv_mib->board_id = FDDI_BRIDGE;
#else
   drv_mib->board_id = FDDICON_MASTER;
#endif
   drv_mib->mac_num = mib->SMTStationConfigGrp.MAC_Ct;
   drv_mib->port_num = mib->SMTStationConfigGrp.NonMaster_Ct +
                       mib->SMTStationConfigGrp.Master_Ct;
   for (i=0; i < drv_mib->mac_num; i++)
   {
      drv_mib->s_mib[i].swRingOp = (unsigned char *)&(mib->MACStatusGrp[i].RMTState);
      drv_mib->s_mib[i].mac_addr = mib->MACAddressGrp[i].SMTAddress;
      drv_mib->s_mib[i].tvx      = mib->MACOperationGrp[i].TvxValue;
      drv_mib->s_mib[i].tmax      = mib->MACOperationGrp[i].T_Max;
      drv_mib->d_mib[i].macFrameRxCount = 
	(uint32*) &(mib->MACCountersGrp[i].Frame_Ct);
      drv_mib->d_mib[i].macErrIsolateCount = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].Error_Ct);
      drv_mib->d_mib[i].macLostFrameCount = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].Lost_Ct);
      drv_mib->d_mib[i].macFrameCopiedCount = 
	(uint32*) &(mib->MACCountersGrp[i].Copied_Ct);
      drv_mib->d_mib[i].macFrameNotCopiedCount = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].NotCopied_Ct);
      drv_mib->d_mib[i].macFrameTxCount = 
	(uint32*) &(mib->MACCountersGrp[i].Transmit_Ct);
      drv_mib->d_mib[i].macTokenRxCount = 
	(uint32*) &(mib->MACCountersGrp[i].Token_Ct);
      drv_mib->d_mib[i].macRingLatencyCount = 
	(uint32*) &(mib->ClassPATHConfigGrp[i].RingLatency);
      drv_mib->d_mib[i].macLateCount = 
	(uint16*) &(mib->MACErrorCtrsGrp[i].Late_Ct);
      drv_mib->d_mib[i].macTVXExpiredCount = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].TvxExpired_Ct);
      drv_mib->d_mib[i].macRingOpCount = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].RingOp_Ct);
      drv_mib->d_mib[i].macTREQ    = &(mib->MACOperationGrp[i].T_Req);
#if 0
      drv_mib->d_mib[i].phyElasticityBufErrorCount = 
	(uint32*) &(mib->PORTErrorCtrsGrp[i].EBErr_Ct);
      drv_mib->d_mib[i].macLCTCount = 
	(uint32*) &(mib->);
      drv_mib->d_mib[i].macStripping = 
	(uint32*) &(mib->MACErrorCtrsGrp[i].RingOp_Ct);
#endif 
   }
}

uInt32
InitMIBLocal ()
/*********************************************************************
Function:	Provide local initialization support. Such support can
			include hardware initialization, local data
			initialization, and system interfaces.
Parameters:	None.
Input:
Output:
Return:		0 if initialization is successful, otherwise an error
		code is returned.
*********************************************************************/
{
NVR_FDDI *FddiRec;
int i;

        FddiRec = &nvr_fddi_rec;
	/*
	 *  Correct the Manyfacturer Data changed in the core module InitMIB()
	 */
	MEMCOPY (mib->SMTStationIdGrp.ManufacturerData.data, 
		 NVR_FDDI_SMT.manufacturerData.data, 
		 sizeof(NVR_FDDI_SMT.manufacturerData.data));

        /* Reset array indexes */
        LongAliasesIndex   = 0;
        ShortAliasesIndex  = 0;
        LongGrpAddrsIndex  = 0;
        ShortGrpAddrsIndex = 0;

        /* copy mib values from nvram */
        mib->ClassConfigGrp.Trace_MaxExpiration =
	     NVR_FDDI_PATH[0].Trace_MaxExpiration;

        for (i=0; i < mib->XDISMTGrp.Port_Ct; i++)
	{
	  mib->PORTOperationGrp[i].TB_Max = 
	       NVR_FDDI_PORT[i].TB_Max;
	  /* For UI use */
	  MEMZERO(&SmtMibPortObjects[i], sizeof(SMT_PRIVATE_PORT_OBJECTS));
	  mib->ATTACHMENTConfigGrp[i].InsertPolicy
	    = NVR_FDDI_ATTACHMENT[i].opticalBypassPresent;
	}
        
        ThisStationId = &NVR_FDDI_SMT.stationID;

        /* For UI use */
        for (i=0; i < mib->SMTStationConfigGrp.MAC_Ct; i++)
	{
           /* For UI use */
	   MEMZERO(&SmtMibMacObjects[i], sizeof(SMT_PRIVATE_MAC_OBJECTS));
       
	   mib->MACConfigGrp[i].DownstreamPORTType 
	     = mib->PORTConfigGrp[i].PC_Type;
	   mib->ClassPATHConfigGrp[i].Type
	     = mib->MACConfigGrp[i].PathsAvailable;
	}

	return (0);
}

uInt32
LocalMIBMessages (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Process messages not handled through standard MIB
		message processing.
Parameters:	smtmsg	= address of SMT message buffer.
Input:		smtmsg	= contains message to process.
Output:		Implementor defined.
Return:		Return values are reserved. Routine should always
		return 0.
*********************************************************************/
{
	return (0);
}
