#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbmmsg.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Message Processing Module

	File:		fbmmsg.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This module is responsible for processing incoming FBM messages
	and for formatting standard outgoing FBM messages.

	Modification History:

	*** Updated to SMT 6.2 ***

	910220-002	LJP
		The FBM_ACTION_SEND_FRAME processing did not allow
		sending Response ESFs. This is now available.
	910404-002	LJP
		Corrected function calls to BuildPMFChangeRequest(),
		BuildPMFAddRequest() and BuildPMFRemoveRequest(). The
		parameter list had too many parameters.
*********************************************************************/
#undef __FBM_DEBUG
#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"
#include	"fbmmacro.h"
#include	"mibdefs.h"
#include        "smtmacro.h"
#include        <pkt.h>
#include        "krnl.h"       /* jlin */

/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/


/*********************************************************************
	External Functions
*********************************************************************/

extern	void	SendFBMMessage ();
extern	void	ClearFrameBuffer ();
extern	void	InitFBMMIBData ();
extern	void	SendSMTFrame ();
extern	uInt16	ntohs ();
extern	void	AddECParam ();
extern	uInt32	LocalFBMMessages ();

extern	uInt32	BuildEchoRequest ();
extern	uInt32	BuildEchoResponse ();
extern	uInt32	BuildESFAnnouncement ();
extern	uInt32	BuildESFRequest ();
extern	uInt32	BuildESFResponse ();
extern	uInt32	BuildNIFAnnouncement ();
extern	uInt32	BuildNIFRequest ();
extern	uInt32	BuildNIFResponse ();
extern	uInt32	BuildRAFAnnouncement ();
extern	uInt32	BuildRAFRequest ();
extern	uInt32	BuildRAFResponse ();
extern	uInt32	BuildSIFConfigRequest ();
extern	uInt32	BuildSIFConfigResponse ();
extern	uInt32	BuildSIFOpRequest ();
extern	uInt32	BuildSIFOpResponse ();
extern	uInt32	BuildRDFResponse ();
extern	uInt32	BuildPMFGetRequest ();
extern	uInt32	BuildPMFChangeRequest ();
extern	uInt32	BuildPMFAddRequest ();
extern	uInt32	BuildPMFRemoveRequest ();

extern  PKT     *SMTFrameDBD_tx;  /* jlin */
extern  SEM     FBMSyncSema;      /* jlin */

/*********************************************************************
	FBM Outgoing Message Routines
*********************************************************************/

void
PassMAPFrame (messageType, framePtr, frameLen, MACNum, EACbits)
	uInt16	messageType;
	uChar	*framePtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:	This function passes a frame received by FBM to the MAP.
		The frame will generally be a response frame that answers
		a request issued by the MAP.
Parameters:	messageType	= message type ID to use in message
		framePtr	= address of frame buffer.
		frameLen	= length of frame (in bytes)
		MACNum		= index of MAC that received the frame.
		EACbits		= E, A, and C indicators from MAC.
Input:		framePtr	= contains complete frame received by MAC.
Output:		Issues message containing frame to MAP.
Return:		No value returned.
*********************************************************************/
{
SMTMessage	msg;			/* address of message buffer */
RecFrameBuf	recBuf;			/* frame info */

	/*
	*	Fill in message information.
	*/
	msg.destination = MAP_MSG_ID;
	msg.source = FBM_MSG_ID;
	msg.type = messageType;
	msg.entity = (uInt16) MACNum;
	msg.localID = 0;
	msg.p1.recFrameBuf = &recBuf;
	msg.len1 = sizeof (RecFrameBuf);
	msg.p2 = framePtr;
	msg.len2 = frameLen + FC_PAD_SIZE;

	recBuf.EACbits = EACbits;
	recBuf.frameLen = frameLen;

	/*
	*	Send the message.
	*/
	SendFBMMessage (&msg);

	return;
}

void
SendFBMEvent (eventType, entity)
	uInt16	eventType;
	uInt16	entity;
/*********************************************************************
Function:	Send an FBM generated event to another process. This
		function determines what processes need to be notified
		based upon the event type.
Parameters:	eventType	= type of FBM event.
		entity		= MAC or PHY index associated with the
					event (if necessary).
Input:		fbmStationData, fbmMACData, and fbmPORTData.
Output:		Issues event message to appropriate process(es).
Return:		None.
*********************************************************************/
{
SMTMessage	eventMsg;		/* message to send */

	/*
	*	Fill in message buffer.
	*/
	eventMsg.source = FBM_MSG_ID;
	eventMsg.destination = MIB_MSG_ID;	/* most messages go to MIB */
	eventMsg.type = FBM_EVENT_NOTIFY_MIB;
	eventMsg.typeInfo = (uInt16) eventType;
	eventMsg.entity = (uInt16) entity;
	eventMsg.len1 = 0;
	eventMsg.len2 = 0;
	eventMsg.localID = 0;

	/*
	*	Fill in data.
	*/
	switch (eventType)
	{
	case fddiMACUpstreamNbr:
		MCopyAddress (eventMsg.data.addr, fbmMACData[entity].UNA);
		break;

	case fddiMACDownstreamNbr:
		MCopyAddress (eventMsg.data.addr, fbmMACData[entity].DNA);
		break;

	case fddiMACDup_Addr_Test:
		eventMsg.data.b16 = fbmMACData[entity].dupAddrTest;
		break;

	case fddiMACDa_Flag:
		eventMsg.data.b8 = fbmMACData[entity].myDuplicate;
		break;

	case fddiMACUnaDa_Flag:
		eventMsg.data.b8 = fbmMACData[entity].myUNADuplicate;
		break;

	default:
		return;
	}

	/*
	*	Send message.
	*/
	SendFBMMessage (&eventMsg);

	return;
}

void
ProcessSendFrame (msg)
	SMTMessage	*msg;
/*********************************************************************
Function:	Process a message that requests a SMT frame to be sent.
Parameters:	msg	= address of buffer containing message.
Input:		msg	= complete contents of message.
Output:		Performs actions appropriate to message type and info.
Return:		None.
*********************************************************************/
{
SendFrameBuf	*buf;			/* send frame info */
uInt32		transID;		/* request frame ID */
#if 0
uInt16		frameLen;		/* send frame length */
TLVParamType	*attrPtr;		/* MIB attribute pointer */
#endif
uInt16		outputMAC=PRIMARY_MAC;	/* index of MAC to send frame on */

	/*
	*	Set buffer pointer.
	*/
	buf = msg->p1.sendFrameBuf;

	/*
	*	Clear frame buffer.
	*/
	ClearFrameBuffer (fbmFrameBuffer);

	/*
	*	If frame is a response frame, then create
	*	a frame buffer for the request frame in the
	*	message.
	*/
	if (buf->frameType == SMTRESPONSE)
	{
		/*
		*	Select frame processing.
		*/
		switch (buf->frameClass)
		{
		case RDF_CLASS:
			transID = BuildRDFResponse
				(msg->p2,
				fbmFrameHeader,
				buf->frameData.rdf.sourceMAC,
				buf->frameData.rdf.reasonCode,
				msg->len2);
			outputMAC = buf->frameData.rdf.sourceMAC;
			break;

		/*
		*	910220-002	LJP
		*	Added capability to send Response ESFs.
		*/
		case ESF_CLASS:
			transID = BuildESFResponse (fbmFrameBuffer,
				buf->frameData.esf.destAddr,
				buf->frameData.esf.sourceMAC,
				buf->sentTransID,
				buf->frameData.esf.esfID,
				msg->p2, msg->len2);
			outputMAC = buf->frameData.esf.sourceMAC;
			break;

		default:
			transID = 0;
		}
	}

	else if (buf->frameType == SMTREQUEST)
	{
		/*
		*	Select frame processing.
		*/
		switch (buf->frameClass)
		{
		case NIF_CLASS:
			transID = BuildNIFRequest (fbmFrameBuffer,
				buf->frameData.nif.FC,
				buf->frameData.nif.destAddr,
				buf->frameData.nif.sourceMAC,
				buf->frameData.nif.transID);
			outputMAC = buf->frameData.nif.sourceMAC;
			break;

		case SIFCONFIG_CLASS:
			transID = BuildSIFConfigRequest (fbmFrameBuffer,
				buf->frameData.sif.FC,
				buf->frameData.sif.destAddr,
				buf->frameData.sif.sourceMAC);
			outputMAC = buf->frameData.sif.sourceMAC;
			break;

		case SIFOP_CLASS:
			transID = BuildSIFOpRequest (fbmFrameBuffer,
				buf->frameData.sif.FC,
				buf->frameData.sif.destAddr,
				buf->frameData.sif.sourceMAC);
			outputMAC = buf->frameData.sif.sourceMAC;
			break;

		case ECHO_CLASS:
			transID = BuildEchoRequest (fbmFrameBuffer,
				buf->frameData.ecf.FC,
				buf->frameData.ecf.destAddr,
				buf->frameData.ecf.sourceMAC,
				msg->p2, msg->len2);
			outputMAC = buf->frameData.ecf.sourceMAC;
			break;

		case RAF_CLASS:
			transID = 0;
			break;

		case ESF_CLASS:
			transID = BuildESFRequest (fbmFrameBuffer,
				buf->frameData.esf.FC,
				buf->frameData.esf.destAddr,
				buf->frameData.esf.sourceMAC,
				buf->frameData.esf.esfID,
				msg->p2, msg->len2);
			outputMAC = buf->frameData.esf.sourceMAC;
			break;

		case PMFGET_CLASS:
			FBMDPT("$Build PMFGetRequest$");
			transID = BuildPMFGetRequest (fbmFrameBuffer,
				buf->frameData.pmf.destAddr,
				buf->frameData.pmf.sourceMAC,
				&buf->frameData.pmf.attribute);
			outputMAC = buf->frameData.pmf.sourceMAC;
			FBMDPT1("$PMFGetRequest's transID %x $", transID);
			break;

		case PMFCHANGE_CLASS:
			/* 910404-002 LJP Corrected function call */
			transID = BuildPMFChangeRequest (fbmFrameBuffer,
				buf->frameData.pmf.destAddr,
				buf->frameData.pmf.sourceMAC,
				&buf->frameData.pmf.setCount,
				&buf->frameData.pmf.attribute);
			outputMAC = buf->frameData.pmf.sourceMAC;
			break;

		case PMFADD_CLASS:
			/* 910404-002 LJP Corrected function call */
			transID = BuildPMFAddRequest (fbmFrameBuffer,
				buf->frameData.pmf.destAddr,
				buf->frameData.pmf.sourceMAC,
				&buf->frameData.pmf.setCount,
				&buf->frameData.pmf.attribute);
			outputMAC = buf->frameData.pmf.sourceMAC;
			break;

		case PMFREMOVE_CLASS:
			/* 910404-002 LJP Corrected function call */
			transID = BuildPMFRemoveRequest (fbmFrameBuffer, 
				buf->frameData.pmf.destAddr,
				buf->frameData.pmf.sourceMAC,
				&buf->frameData.pmf.setCount,
				&buf->frameData.pmf.attribute);
			outputMAC = buf->frameData.pmf.sourceMAC;
			break;

		default:
			transID = 0;
		}
	}

	else if (buf->frameType == SMTANNOUNCE)
	{
		/*
		*	Select frame processing.
		*/
		switch (buf->frameClass)
		{
		case NIF_CLASS:
			transID = BuildNIFAnnouncement (fbmFrameBuffer,
				buf->frameData.nif.sourceMAC,
				buf->frameData.nif.transID);
			outputMAC = buf->frameData.nif.sourceMAC;
			break;

		case RAF_CLASS:
			transID = 0;
			break;

		case ESF_CLASS:
			transID = BuildESFAnnouncement (fbmFrameBuffer,
				buf->frameData.esf.destAddr,
				buf->frameData.esf.sourceMAC,
				buf->frameData.esf.esfID,
				msg->p2, msg->len2);
			outputMAC = buf->frameData.esf.sourceMAC;
			break;

		default:
			transID = 0;
		}
	}

	else
		/*
		*	Unknown frame type.
		*/
		transID = 0;

	/*
	*	If frame was built, then send it and notify requesting
	*	process of transaction ID.
	*/
	if (transID != 0)
	{
		/*
		*	Send frame.
		*/
		SendSMTFrame (fbmFrameBuffer,
			ntohs (fbmFrameHeader->smtHdr.InfoField_Length)
				+ SMT_FRAME_HDR_SIZE, outputMAC);

		/*
		*	Set message header info.
		*/
		msg->destination = msg->source;
		msg->source = FBM_MSG_ID;
		msg->type = FBM_RESPONSE_FRAME_SENT;

		/*
		*	Return SendFrameBuf structure as well.
		*/
		buf->sentTransID = transID;

		SendFBMMessage (msg);
	}

	/*
	*	Otherwise issue an error message returning
	*	the frame requested.
	*/
	else
	{
		/*
		*	Set message header info.
		*/
		msg->destination = msg->source;
		msg->source = FBM_MSG_ID;
		msg->type = FBM_ERROR_MSG;
		msg->typeInfo = EFBM_BAD_FRAME_REQUESTED;

		SendFBMMessage (msg);
	}

	return;
}

void
ProcessFBMNotification (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Process a message from the MIB indicating an event
		or condition to be reported through status report frames.
Parameters:	smtmsg	= address of buffer containing message.
Input:		smtmsg	= complete contents of message.
Output:		Updates event/condition list.
Return:		None.
Modification History:
*********************************************************************/
{
	/*
	*	Add event/condition to current list.
	*/
	AddECParam ((TLVHdrType *) smtmsg->p1.ptr);

	/*
	*	Set interval limit to 2 seconds so that at next interval
	*	a new SRF is sent.
	*/
	fbmStationData.nextSRF = 2;

	return;
}

void
ProcessFBMMIBChange (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Process a change from the MIB.
Parameters:	smtmsg	= address of buffer containing message.
Input:		smtmsg	= complete contents of message.
Output:		changes global data for FBM to use.
Return:		None.
Modification History:
*********************************************************************/
{
	switch (smtmsg->typeInfo)
	{
	case fddiSMTOpVersionId:
		fbmStationData.opVersionID = smtmsg->data.b16;
		break;

	case fddiSMTReportLimit:
		fbmStationData.reportLimit = smtmsg->data.b32;
		break;

	case fddiSMTT_Notify:
		fbmStationData.T_Notify = smtmsg->data.b16;
		break;

	case fddiMACDa_Flag:
		fbmMACData[smtmsg->entity].myDuplicate = smtmsg->data.b8;
		break;

	case fddiMACSMTAddress:
		MCopyAddress (fbmMACData[smtmsg->entity].SMTAddress,
			smtmsg->data.addr);
		break;
	}

	return;
}

void
ProcessFBMMessage (msg)
	SMTMessage	*msg;
/*********************************************************************
Function:	Process a message received by FBM.
Parameters:	msg	= address of buffer containing message.
Input:		msg	= complete contents of message.
Output:		Performs actions appropriate to message type and info.
Return:		None.
Modification History:
*********************************************************************/
{
	/*
	*	Process only if FBM is initialized.
	*/
	if (!fbmStationData.FBMInitialized)
	{
		return;
	}

	/*
	*	Select message processing.
	*/
	switch (msg->type)
	{
	/*
	*	Process events.
	*/
	case MIB_EVENT_NOTIFY_CHANGE:
		ProcessFBMMIBChange (msg);
		break;

	case MIB_EVENT_NOTIFY_SMT:
		ProcessFBMNotification (msg);
		break;

	/*
	*	Process actions.
	*/
	case FBM_ACTION_SEND_FRAME:
		RcvSignal (&FBMSyncSema);  /* jlin */
		CheckSMTDBDBuffer();     /* JLIN: Allocate tx buffer */
		ProcessSendFrame (msg);	
		SendSignal (&FBMSyncSema); /* jlin */
		break;

	/*
	*	Handle all others locally.
	*/
	default:
		LocalFBMMessages (msg);
		break;
	}

	return;
}

