#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbmtimer.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Process FBM Timer Module

	File:		fbmtimer.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This module is responsible for processing the timer tick for
	FBM that occurs every FBM_CLOCK_TICK seconds (either 1 or 2).
	For every clock tick, FBM handles the various periodic tasks
	that need to be performed for the different protocols done
	in FBM.

	Modification History:
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"


/*********************************************************************
	External functions used.
*********************************************************************/

extern	void	ProcessNNTick ();
extern	void	ProcessSRPTick ();
extern	void	ProcessLocalTick ();


/*********************************************************************
	FBM Receive Routines
*********************************************************************/

void
ProcessFBMTimer ()
/*********************************************************************
Function:	This function processes the timer tick received
		every FBM_CLOCK_TICK seconds. Each of the timer based
		protocol routines are called from here.
Parameters:	None.
Input:		None.
Output:		None.
Return:		No value is returned.
Modification History:
*********************************************************************/
{
	/*
	*	Don't do processing until intialized.
	*/
	if (!fbmStationData.FBMInitialized)
		return;

	/* Neighbor Notification protocol */
	ProcessNNTick ();

	/* Status Reporting protocol */
	ProcessSRPTick ();

	/* any local timed processing */
	ProcessLocalTick ();

	return;
}

