#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbminit.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Initialization Module

	File:		fbminit.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This module is responsible for initializing FBM for
	processing. The basic system services are initialized
	when FBM starts. However, FBM cannot begin its service
	until the MIB has completed its initialization. After
	the MIB has been initialized, it notifies FBM to finish
	its initialization. After FBM completes its initialization,
	the MIB and FBM are ready to work.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"
#include	"mibdefs.h"


/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/


/*********************************************************************
	External Functions
*********************************************************************/

extern	uInt32	FBMGetMIBAttr ();


/*********************************************************************
	FBM Processing Routines
*********************************************************************/

uInt32
InitFBMData ()
/*********************************************************************
Function:	Initialize FBM processing.
Parameters:	None.
Input:		None.
Output:		Initializes FBM global data.
Return:		0 returned if initialization was successful.
		Otherwise an error value is returned.
*********************************************************************/
{
Int16	i;

	/*
	*	Initialize station data.
	*/
	fbmStationData.macCount = 0;
	fbmStationData.attachCount = 0;
	fbmStationData.masterCount = 0;
	fbmStationData.opVersionID = 0;
	fbmStationData.hiVersionID = 0;
	fbmStationData.loVersionID = 0;
	fbmStationData.T_Notify = 0;
	fbmStationData.reportLimit = 0;
	fbmStationData.useSRP = CLEAR;
	fbmStationData.usePMF = FBM_PMF_SUPPORTED;
	fbmStationData.useAuthorization = CLEAR;
	fbmStationData.phyCount = 0;
	fbmStationData.FBMInitialized = CLEAR;
	fbmStationData.TSR = 0;
	fbmStationData.nextSRF = 0;
	fbmStationData.latencyRing1 = 0;
	fbmStationData.latencyRing2 = 0;

	/*
	*	Initialize MAC data.
	*/
	for (i = 0; i < MAX_MAC_COUNT; i++)
	{
		MCopyAddress (fbmMACData[i].SMTAddress, NULL_ADDRESS);
		fbmMACData[i].operational = CLEAR;
		MCopyAddress (fbmMACData[i].UNA, NULL_ADDRESS);
		MCopyAddress (fbmMACData[i].DNA, NULL_ADDRESS);
		fbmMACData[i].myDuplicate = CLEAR;
		fbmMACData[i].myUNADuplicate = CLEAR;
		fbmMACData[i].dupAddrTest = CLEAR;
		fbmMACData[i].TNN = 0;
		fbmMACData[i].TVU = 0;
		fbmMACData[i].TVD = 0;
		fbmMACData[i].NNTransactionID = 0;
	}


	return (0);
}

uInt32
InitFBMMIBData ()
/*********************************************************************
Function:       Initialize FBM global data after MIB has been initialized.
parameters:     None.
Input:          None.
Output:         All global values set to current MIB settings.
Return:         0 if successful, otherwise an error value is returned.
Notes:          This function is called when the MIB initialization
                message is received.
Modification History:
*********************************************************************/
{
TLVParamType    buffer;
Int16		i;

        /*
        *       Initialize station data
        */
        buffer.paramType = fddiSMTMAC_Ct;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.macCount = buffer.SMTPARAM8;

        buffer.paramType = fddiSMTNonMaster_Ct;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.attachCount = buffer.SMTPARAM8;

        buffer.paramType = fddiSMTMaster_Ct;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.masterCount = buffer.SMTPARAM8;

        buffer.paramType = fddiSMTOpVersionId;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.opVersionID = buffer.SMTPARAM16;

        buffer.paramType = fddiSMTHiVersionId;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.hiVersionID = buffer.SMTPARAM16;

        buffer.paramType = fddiSMTLoVersionId;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.loVersionID = buffer.SMTPARAM16;

        buffer.paramType = fddiSMTT_Notify;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.T_Notify = buffer.SMTPARAM16;

        buffer.paramType = fddiSMTReportLimit;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.reportLimit = buffer.SMTPARAM32;

        buffer.paramType = fddiSMTStatusReporting;
        buffer.paramLen = 0;
        FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
        fbmStationData.useSRP = buffer.SMTPARAM8;

	fbmStationData.phyCount = fbmStationData.attachCount
		+ fbmStationData.masterCount;

	/*
	*	Initialize MAC data.
	*/
	for (i = 0; i < fbmStationData.macCount; i++)
	{
		buffer.paramType = xdiMACOperational;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		FBMGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		fbmMACData[i].operational = buffer.MACPARAM8;

		if (fbmMACData[i].operational)
		{
			buffer.paramType = fddiMACSMTAddress;
			buffer.paramLen = 4;
			buffer.MACINDEX = i + 1;
			FBMGetMIBAttr (sizeof (buffer), &buffer,
				(SetCountType *) NULL);
			MCopyAddress (fbmMACData[i].SMTAddress,
				buffer.MACADDR);
		}
	}

	/*
	*	Set initialized flag.
	*/
	fbmStationData.FBMInitialized = SET;

	return (0);
}

