#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbmsup.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Frame Support Module

	File:		fbmsup.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	Frame Based Management for SMT.  This module contains routines
	which support building frames for transmission.

	Modification History:

	*** Updated to SMT 6.2 ***

	910605-001	LJP
		Routine AttrNetOrder() assumed the parameter type was
		passed to it in HOST_ORDER. This is not always the case.
		If the requested order is HOST_ORDER, the routine now
		assumes the type is in network order and will convert
		it before using it.
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"
#include	"fbmmacro.h"
#include	"mibdefs.h"


/*********************************************************************
	External Functions
*********************************************************************/

extern	uInt16	ntohs ();
extern	uInt32	ntohl ();
extern	uInt16	htons ();
extern	uInt32	htonl ();

/*********************************************************************
	Frame Support Routines
*********************************************************************/

uInt32
htonl (value)
	uInt32	value;
/*********************************************************************
Function:	This function converts a 32 bit half word quantity from
		litte endian format to network byte order.  
		If this machine is a big endian machine then we do nothing.
Parameters:	value	= 32 bit value to be converted.
Input:		
Output:		
Return:		Converted 32 bit value.
*********************************************************************/
{
union {
	uInt32	longval;
	char	strval[4];
} cnvrter1, cnvrter2;
	
#ifndef LITTLE_ENDIAN

	/*
	*	If this is a big endian machine there is no conversion
	*	necessary.
	*/
	return(value);

#else

	/*	
	*	Do conversion on little endian machines.  Convert
	*	to network byte order.
	*/
	cnvrter1.longval = value;
	cnvrter2.strval[0] = cnvrter1.strval[3];
	cnvrter2.strval[1] = cnvrter1.strval[2];
	cnvrter2.strval[2] = cnvrter1.strval[1];
	cnvrter2.strval[3] = cnvrter1.strval[0];

	return (cnvrter2.longval);

#endif
}

uInt16
htons (value)
	uInt16	value;
/*********************************************************************
Function:	This function converts a 16 bit half word quantity from 
		litte endian format to network byte order.  On machines such
		as Intel processors half words are stored "backwards".  On the
		network we always send most significant byte first, so we must
		convert half words to the proper order.  If this machine is a
		big endian machine then we do nothing.
Parameters:	value	= Half word to be converted.
Input:
Output:		
Return:		Converted half word.
*********************************************************************/
{
union {
	uInt16	shortval;
	char	strval[2];
} cnvrter1, cnvrter2;
	
#ifndef LITTLE_ENDIAN

	return (value);

#else

	cnvrter1.shortval = value;
	cnvrter2.strval[0] = cnvrter1.strval[1];
	cnvrter2.strval[1] = cnvrter1.strval[0];

	return (cnvrter2.shortval);

#endif
}

uInt32
ntohl (value)
	uInt32	value;
/*********************************************************************
Function:	This function converts a 32 bit value from network byte order
		to host byte order.  The only time any conversion is needed is
		if the host is a little endian machine.  
Parameters:	value	= 32-bit value to convert.
Input:		
Output:		
Return:		Converted 32-bit value.
*********************************************************************/
{
union {
	uInt32	longval;
	char	strval[4];
} cnvrter1, cnvrter2;
	
#ifndef LITTLE_ENDIAN

	/*
	*	If this is a big endian machine there is no conversion
	*	necessary.
	*/
	return (value);

#else

	/*	
	*	Do conversion on little endian machines.  Convert
	*	from network byte order.
	*/
	cnvrter1.longval = value;
	cnvrter2.strval[0] = cnvrter1.strval[3];
	cnvrter2.strval[1] = cnvrter1.strval[2];
	cnvrter2.strval[2] = cnvrter1.strval[1];
	cnvrter2.strval[3] = cnvrter1.strval[0];

	return (cnvrter2.longval);

#endif
}

uInt16
ntohs (value)
	uInt16	value;
/*********************************************************************
Function:	This function converts a 16 bit half word quantity from 
		network byte order to little endian format.  On machines such
		as Intel processors half words are stored "backwards".  On the
		network we always send most significant byte first, so we must
		convert half words to the proper order.  If this machine is a
		big endian machine then we do nothing.
Parameters:	value	= Half word to be converted.
Input:		
Output:
Return:		Converted half word.
*********************************************************************/
{
union {
	uInt16	shortval;
	char	strval[2];
} cnvrter1, cnvrter2;
	
#ifndef LITTLE_ENDIAN

	return (value);

#else

	cnvrter1.shortval = value;
	cnvrter2.strval[0] = cnvrter1.strval[1];
	cnvrter2.strval[1] = cnvrter1.strval[0];

	return (cnvrter2.shortval);

#endif
}

void
AttrNetOrder (param, netOrder)
	TLVParamType	*param;
	Flag		netOrder;
/*********************************************************************
Function:	This function converts a MIB attribute between host byte
		order and network byte order.
Parameters:	param	= buffer containing MIB attribute.
		netOrder= selects which order to output.
Input:		param	= contains a TLV encoded MIB attribute.
		netOrder= if set then convert from host to network byte
			order, else vice versa.
Output:		param	= TLV encoded MIB attribute with all values
			converted to requested byte order.
Return:		None.
Notes:		The conversion is done in situ. If the original value
		should preserved, then it must be copied before
		calling this routine.
Modifications:
910605-001	LJP
*********************************************************************/
{
#if 0
Int16		i;
#endif
SMTTimeStamp	*tsp;
SetCountType	*scp;
union {
	EvtCfgChgType		*evtCfgChg;
	CondDAType		*condDA;
	CondFrErrType		*condFrErr;
	CondNotCopiedType	*condNotCopied;
	EvtNbrChgType		*evtNbrChg;
	EvtTrStatType		*evtTrStat;
	CondLerType		*condLer;
	EvtConnectType		*evtConnect;
	CondEBErrType		*condEBError;
} event;
uInt16	ptype;			/* 910605-001 LJP */

	/*
	*	910605-001	LJP
	*	If the requested order is HOST_ORDER, then the
	*	data is assumed to be in network order. This means
	*	that the parameter type must be converted before it
	*	can be used.
	*/
	if (netOrder == HOST_ORDER)
		ptype = ntohs (param->paramType);
	else
		ptype = param->paramType;

	/*
	*	Handle SMT values that do not have an index.
	*/
	/* 910605-001 LJP Use converted parameter type */
	if ((ptype & MIB_OBJECT_MASK) == fddiSMT)
	{
		/*
		*	Select data types by size.
		*/
		/* 910605-001 LJP Use converted parameter type */
		switch (ptype)
		{
		/*
		*	Convert 16-bit types.
		*/
		case fddiSMTOpVersionId:
		case fddiSMTHiVersionId:
		case fddiSMTLoVersionId:
		case fddiSMTConfigCapabilities:
		case fddiSMTConfigPolicy:
		case fddiSMTConnectionPolicy:
		case fddiSMTT_Notify:
		case fddiSMTHoldState:
			param->SMTPARAM16 = (netOrder)
				? htons (param->SMTPARAM16)
				: ntohs (param->SMTPARAM16);
			break;

		/*
		*	Convert 32-bit types.
		*/
		case fddiSMTReportLimit:
			param->SMTPARAM32 = (netOrder)
				? htonl (param->SMTPARAM32)
				: ntohl (param->SMTPARAM32);
			break;

		/*
		*	Convert special types.
		*/
		case fddiSMTMsgTimeStamp:
		case fddiSMTTransitionTimeStamp:
			tsp = (SMTTimeStamp *) &param->SMTOTHER;
			tsp->hiword = (netOrder)
				? htonl (tsp->hiword)
				: ntohl (tsp->hiword);
			tsp->loword = (netOrder)
				? htonl (tsp->loword)
				: ntohl (tsp->loword);
			break;

		case fddiSMTSetCount:
			scp = (SetCountType *) &param->SMTOTHER;
			scp->count = (netOrder)
				? htonl (scp->count)
				: ntohl (scp->count);
			scp->setTimeStamp.hiword = (netOrder)
				? htonl (scp->setTimeStamp.hiword)
				: ntohl (scp->setTimeStamp.hiword);
			scp->setTimeStamp.loword = (netOrder)
				? htonl (scp->setTimeStamp.loword)
				: ntohl (scp->setTimeStamp.loword);
			break;

		case fddiSMTConfigurationChgEvent:
			/* get structure format */
			event.evtCfgChg = (EvtCfgChgType *) param;

			/* convert CF_State */
			AttrNetOrder (&event.evtCfgChg->CF_StateHdr,
				netOrder);
#ifdef OPTIONAL_PARAMETER
			/* convert path list */
			AttrNetOrder (&event.evtCfgChg->PathListHdr,
				netOrder);
#endif
			break;

		/*
		*	Convert groups.
		*/
		case fddiSMTStationIdGrp:
		case fddiSMTStationConfigGrp:
		case fddiSMTStatusGrp:
		case fddiSMTMIBOperationGrp:
			break;

		/*
		*	All other values are not converted.
		*/
		default:
			break;
		}
	}

	/*
	*	Handle attribute with an index field.
	*/
	else
	{
		/* 910605-001 LJP Use converted parameter type */
		switch (ptype)
		{
		/*
		*	Convert 16-bit values.
		*/
		case fddiMACFrameStatusCapabilities:
		case fddiMACBridgeFunction:
		case fddiMACCurrentPath:
		case fddiMACDup_Addr_Test:
		case fddiMACDownstreamPORTType:
		case fddiMACFrameStatus:
		case fddiMACLate_Ct:
		case fddiMACFrameErrorThreshold:
		case fddiMACFrameErrorRatio:
		case fddiMACNotCopiedThreshold:
		case fddiMACNotCopiedRatio:
		case fddiMACRootMACCurrentPath:
		case fddiPATHClassPATHClassType:
		case fddiPATHClassPATHPORTOrder:
		case fddiPATHClassPATHTraceStatus:
		case fddiPATHClassPATHSbaOverhead:
		case fddiPATHClassPATHStatus:
		case fddiPORTMACPlacement:
		case fddiPORTConnectState:
		case fddiATTACHMENTClass:
			param->MACPARAM16 = (netOrder)
				? htons (param->MACPARAM16)
				: ntohs (param->MACPARAM16);
			break;

		/*
		*	Convert 32-bit values.
		*/
		case fddiMACT_MaxGreatestLowerBound:
		case fddiMACTVXGreatestLowerBound:
		case fddiMACT_Req:
		case fddiMACT_Neg:
		case fddiMACT_Max:
		case fddiMACTvxValue:
		case fddiMACT_Min:
		case fddiMACT_Pri0:
		case fddiMACT_Pri1:
		case fddiMACT_Pri2:
		case fddiMACT_Pri3:
		case fddiMACT_Pri4:
		case fddiMACT_Pri5:
		case fddiMACT_Pri6:
		case fddiMACFrame_Ct:
		case fddiMACCopied_Ct:
		case fddiMACTransmit_Ct:
		case fddiMACToken_Ct:
		case fddiMACError_Ct:
		case fddiMACLost_Ct:
		case fddiMACTvxExpired_Ct:
		case fddiMACNotCopied_Ct:
		case fddiMACRingOp_Ct:
		case fddiMACBaseFrame_Ct:
		case fddiMACBaseError_Ct:
		case fddiMACBaseLost_Ct:
		case fddiMACBaseNotCopied_Ct:
		case fddiMACBaseCopied_Ct:
		case fddiPATHClassTrace_MaxExpiration:
		case fddiPATHClassTVXLowerBound:
		case fddiPATHClassT_MaxLowerBound:
		case fddiPATHClassPATHRingLatency:
		case fddiPATHClassPATHSba:
		case fddiPATHClassPATHT_Rmode:
		case fddiPORTMACLoop_Time:
		case fddiPORTTB_Max:
		case fddiPORTEBError_Ct:
		case fddiPORTLCTFail_Ct:
		case fddiPORTLem_Reject_Ct:
		case fddiPORTLem_Ct:
		case fddiPORTBaseLem_Reject_Ct:
		case fddiPORTBaseLem_Ct:
		case fddiATTACHMENTI_MaxExpiration:
			param->MACPARAM32 = (netOrder)
				? htonl (param->MACPARAM32)
				: ntohl (param->MACPARAM32);
			break;

		/*
		*	Convert special values.
		*/
		case fddiMACBaseTimeFrameError:
		case fddiMACBaseTimeNotCopied:
		case fddiPORTBaseLer_TimeStamp:
			tsp = (SMTTimeStamp *) &param->MACOTHER;
			tsp->hiword = (netOrder)
				? htonl (tsp->hiword)
				: ntohl (tsp->hiword);
			tsp->loword = (netOrder)
				? htonl (tsp->loword)
				: ntohl (tsp->loword);
			break;

		case fddiPATHClassPATHConfiguration:
			break;

		case fddiMACNeighborChangeEvent:
			/* get structure */
			event.evtNbrChg = (EvtNbrChgType *) param;

			/* convert values (header and index converted
				below */
			event.evtNbrChg->Condition = (netOrder)
				? htons (event.evtNbrChg->Condition)
				: ntohs (event.evtNbrChg->Condition);
			break;

		case fddiPATHTraceStatusEvent:
			/*
			* Note: the values in this condition are all
			* 8 bits long and do not need converting.
			* However, although this is a PATH attribute,
			* there is no PATH index. Since this section
			* of the code expects an index value, it will
			* try to convert the index below. To nullify
			* the effect of this later conversion, an index
			* conversion is done here so that it can be undone
			* by the normal processing below.
			*/
			param->MACINDEX = (netOrder)
				? htons (param->MACINDEX)
				: ntohs (param->MACINDEX);
			break;

		case fddiPORTUndesiredConnectionAttempt:
			/*
			* All values are 8 bits long and do not need
			* converting.
			*/
			break;

		case fddiMACDuplicateAddressCondition:
			/* get structure */
			event.condDA = (CondDAType *) param;

			/* convert values */
			event.condDA->Condition = (netOrder)
				? htons (event.condDA->Condition)
				: ntohs (event.condDA->Condition);
			break;

		case fddiMACFrameErrorConditionEvent:
			/* get structure */
			event.condFrErr = (CondFrErrType *) param;

			/* convert values */
			event.condFrErr->Condition_State = (netOrder)
				? htons (event.condFrErr->Condition_State)
				: ntohs (event.condFrErr->Condition_State);

			event.condFrErr->Frame_Ct = (netOrder)
				? htonl (event.condFrErr->Frame_Ct)
				: ntohl (event.condFrErr->Frame_Ct);

			event.condFrErr->Error_Ct = (netOrder)
				? htonl (event.condFrErr->Error_Ct)
				: ntohl (event.condFrErr->Error_Ct);

			event.condFrErr->Lost_Ct = (netOrder)
				? htonl (event.condFrErr->Lost_Ct)
				: ntohl (event.condFrErr->Lost_Ct);

			event.condFrErr->BaseFrame_Ct = (netOrder)
				? htonl (event.condFrErr->BaseFrame_Ct)
				: ntohl (event.condFrErr->BaseFrame_Ct);

			event.condFrErr->BaseError_Ct = (netOrder)
				? htonl (event.condFrErr->BaseError_Ct)
				: ntohl (event.condFrErr->BaseError_Ct);

			event.condFrErr->BaseLost_Ct = (netOrder)
				? htonl (event.condFrErr->BaseLost_Ct)
				: ntohl (event.condFrErr->BaseLost_Ct);

			event.condFrErr->BaseTimeStamp.hiword = (netOrder)
				? htonl (event.condFrErr->BaseTimeStamp.hiword)
				: ntohl (event.condFrErr->BaseTimeStamp.hiword);

			event.condFrErr->BaseTimeStamp.loword = (netOrder)
				? htonl (event.condFrErr->BaseTimeStamp.loword)
				: ntohl (event.condFrErr->BaseTimeStamp.loword);

			event.condFrErr->FrameErrorRatio = (netOrder)
				? htons (event.condFrErr->FrameErrorRatio)
				: ntohs (event.condFrErr->FrameErrorRatio);

			break;

		case fddiMACNotCopiedConditionEvent:
			/* get structure */
			event.condNotCopied = (CondNotCopiedType *) param;

			/* convert values */
			event.condNotCopied->Condition_State = (netOrder)
				? htons (event.condNotCopied->Condition_State)
				: ntohs (event.condNotCopied->Condition_State);

			event.condNotCopied->NotCopied_Ct = (netOrder)
				? htonl (event.condNotCopied->NotCopied_Ct)
				: ntohl (event.condNotCopied->NotCopied_Ct);

			event.condNotCopied->Copied_Ct = (netOrder)
				? htonl (event.condNotCopied->Copied_Ct)
				: ntohl (event.condNotCopied->Copied_Ct);

			event.condNotCopied->BaseNotCopied_Ct = (netOrder)
				? htonl (event.condNotCopied->BaseNotCopied_Ct)
				: ntohl (event.condNotCopied->BaseNotCopied_Ct);

			event.condNotCopied->BaseCopied_Ct = (netOrder)
				? htonl (event.condNotCopied->BaseCopied_Ct)
				: ntohl (event.condNotCopied->BaseCopied_Ct);

			event.condNotCopied->BaseTimeStamp.hiword = (netOrder)
				? htonl (event.condNotCopied->BaseTimeStamp.hiword)
				: ntohl (event.condNotCopied->BaseTimeStamp.hiword);

			event.condNotCopied->BaseTimeStamp.loword = (netOrder)
				? htonl (event.condNotCopied->BaseTimeStamp.loword)
				: ntohl (event.condNotCopied->BaseTimeStamp.loword);

			event.condNotCopied->NotCopiedRatio = (netOrder)
				? htons (event.condNotCopied->NotCopiedRatio)
				: ntohs (event.condNotCopied->NotCopiedRatio);

			break;

		case fddiPORTLerConditionEvent:
			/* get structure */
			event.condLer = (CondLerType *) param;

			/* convert values */
			event.condLer->ConditionState = (netOrder)
				? htons (event.condLer->ConditionState)
				: ntohs (event.condLer->ConditionState);

			event.condLer->Lem_Reject_Ct = (netOrder)
				? htonl (event.condLer->Lem_Reject_Ct)
				: ntohl (event.condLer->Lem_Reject_Ct);

			event.condLer->Lem_Ct = (netOrder)
				? htonl (event.condLer->Lem_Ct)
				: ntohl (event.condLer->Lem_Ct);

			event.condLer->BaseLem_Reject_Ct = (netOrder)
				? htonl (event.condLer->BaseLem_Reject_Ct)
				: ntohl (event.condLer->BaseLem_Reject_Ct);

			event.condLer->BaseLem_Ct = (netOrder)
				? htonl (event.condLer->BaseLem_Ct)
				: ntohl (event.condLer->BaseLem_Ct);

			event.condLer->BaseLer_TimeStamp.hiword = (netOrder)
				? htonl (event.condLer->BaseLer_TimeStamp.hiword)
				: ntohl (event.condLer->BaseLer_TimeStamp.hiword);

			event.condLer->BaseLer_TimeStamp.loword = (netOrder)
				? htonl (event.condLer->BaseLer_TimeStamp.loword)
				: ntohl (event.condLer->BaseLer_TimeStamp.loword);

			break;

		case fddiPORTEBErrorConditionEvent:
			/* get structure */
			event.condEBError = (CondEBErrType *) param;

			/* convert values */
			event.condEBError->ConditionState = (netOrder)
				? htons (event.condEBError->ConditionState)
				: ntohs (event.condEBError->ConditionState);

			event.condEBError->EbError_Ct = (netOrder)
				? htonl (event.condEBError->EbError_Ct)
				: ntohl (event.condEBError->EbError_Ct);

			break;

		/*
		*	All other values not converted.
		*/
		default:
			break;
		}

		/*
		*	Convert index.
		*/
		param->MACINDEX = (netOrder)
			? htons (param->MACINDEX)
			: ntohs (param->MACINDEX);
	}

	/*
	*	Convert type and length.
	*/
	param->paramType = (netOrder)
		? htons (param->paramType)
		: ntohs (param->paramType);

	param->paramLen = (netOrder)
		? htons (param->paramLen)
		: ntohs (param->paramLen);

	return;
}


/*********************************************************************
	Frame Parsing Routines
*********************************************************************/

uChar *
FindFrameParam (paramType, frameBuf)
	uInt16	paramType;
	uChar	*frameBuf;
/*********************************************************************
Function:	This function searches through a frame to find a
		particular parameter.
Parameters:	paramType	= parameter type to search for.
		frameBuf	= address of frame buffer.
Input:		frameBuf	= contains frame to search through.
Output:		None.
Return:		Address of header for parameter requested.
		NULL if parameter could not be found.
*********************************************************************/
{
uInt16		plen;		/* length of parameter */
uChar		*curpos;	/* current position in frame */
ParamHdrType	*phdr;		/* address of parameter header */
SMTFrameHdrType	*frameHdr;	/* SMT frame header */
uInt16		frameLen;	/* length of SMT INFO */

	/*
	*	Get size of INFO field.
	*/
	frameHdr = (SMTFrameHdrType *) frameBuf;
	frameLen = ntohs (frameHdr->smtHdr.InfoField_Length);

	/*
	*	Move to first parameter in SMT frame.
	*/
	curpos = (uChar *) (frameHdr + 1);

	while (frameLen)
	{
		/*
		*	Get parameter header.
		*/
		phdr = (ParamHdrType *) (curpos);

		/*
		*	Check type.
		*/
		if (ntohs (phdr->type) == paramType)
			return ((uChar *) phdr);

		/*
		 * If the parameter type is 0 or the length is not a
		 * multiple of 4, then the contents of the buffer cannot
		 * be considered usable beyond this point, so abort 
		 * the search.
		 */
		if ((ntohs (phdr->type) == 0) || (ntohs (phdr->length) & 3)
		    || (ntohs (phdr->length) == 0))
		         break;
		/*
		*	Move to next parameter.
		*/
		plen = (ntohs (phdr->length) + sizeof (ParamHdrType));
		curpos += plen;
		frameLen -= plen;
	}

	return ((uChar *) NULL);
}


/*********************************************************************
	Transaction ID Generator
*********************************************************************/

/*
*	Each frame initiated by this station must have a unique
*	transaction id.  This is generated by through a counter which
*	is incremented each time a new transaction id is needed.  The
*	counter is kept below.
*/
static	uInt32 FBMTransaction_id;


uInt32
GenTransID ()
/*********************************************************************
Function:	Generate a transaction identifier to be used in an outgoing
		SMT frame.  The transaction identifier is a 32 bit number that
		is used to track SMT frames.  The implementation here is to
		keep a global counter which is incremented each time it read.
		The pre-incremented value is returned to the caller to be used
		in the SMT frame.
Parameters:	None.
Input:
Output:
Return:		A 32 bit number is returned which may be used
		as a transaction identifier in an SMT frame.
Modification History:
*********************************************************************/
{
#if 0
ProcState	CurIntLvl;	/* For saving interrupt level */
#endif
uInt32		RetVal;		/* Value of global counter before
					incrementing it.  This is the value
					returned to our caller */

	MDisableInterrupts (&CurIntLvl);
	RetVal = FBMTransaction_id;
	FBMTransaction_id += 1;
	if (FBMTransaction_id == 0)
		FBMTransaction_id = 1;
	MRestoreInterrupts (&CurIntLvl);
	return (RetVal);
}

uInt32
InitFBMTransId ()
/*********************************************************************
Function:	Initialize the transaction identifier to be used in
		outgoing SMT frames.
Parameters:	None.
Input:		None.
Output:		Sets FBMTransaction_id to 1.
Return:		0 if successful, otherwise error code.
Modification History:
*********************************************************************/
{
	FBMTransaction_id = 1;
	return (0);
}

