#ifndef __CSPHDR_H
#define __CSPHDR_H
/*
@(#) csphdr.h V6.2.3:cs.911022:7:7 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Connection Services Process Header File
	
	CSP Header File
	
	File:		csphdr.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.911022	10/28/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This is the header file used by all CSP modules. This file contains
	definitions for data structures, defined values of states, signals,
	and variables.

	Modification History:

	*** Updated to SMT 6.2 ***
	910122-005	LJP
		Removed unused resID members from CSPMACInfo 
		and CSPPHYInfo.
	910419-003	LJP
		Added array to CEM info to track the current RM_Join
		for each MAC from each port.
	910426-001	LJP
		Added array to CEM info for RM_Loop for each MAC.
	911022-003	LJP
		Added WAT_Flag to struct CSPStationInfo to support
		SMT-LBC-69 (avoid MAC-less wrap and rapid cycling of
		withheld A connection).
*********************************************************************/

/*********************************************************************
	Data Structures
*********************************************************************/

/*
*	The following data structures define the global data used 
*	throughout CSP. The data is divided to correspond to the station as
*	an object and each state machine as an object. The organization
*	for the data is based on the facilities description of the FDDI SMT
*	Connection Management.
*/

/*
*	This data structure defines the set of data associated with the
*	station.
*/

struct	CSPStationInfo {
	/* MIB SMT values */
	uChar	macCount;		/* total # of MACs */
	uChar	attachCount;		/* # of attach PHYs */
	uChar	masterCount;		/* # of master PHYs */
	uChar	pathsAvailable;		/* paths available in the station */
	uInt16	configPolicy;		/* station configuration policies */
	uInt16	connectionPolicy;	/* station connection policies */

	/* SMT values from other attributes */
	Flag	Bypass;		/* bypass switch present */
	uInt16	bothWrapPolicy;	/* place both MACs on same path in WRAP */
	uInt32	Trace_Max;	/* Trace_Max expiration value */
	uInt32	I_Max;		/* I_Max expiration value */
	uInt32	T_Rmode;	/* Timer for restricted dialogs */

	/* Locally determined values */
	uInt16	phyCount;	/* total # of PHYs */
	Flag	CF_MAC;		/* SET if MAC available for LCT or loopback */
	Flag	CSPInitialized;	/* SET after CSP initialized from MIB */

	/* State information */
	uChar	cfState;	/* CFM state */
	Flag	WA_Flag;	/* CFM WA_Flag */
	Flag	WAT_Flag;	/* CFM WAT_Flag 911022-003 LJP */
};

/*
*	This data structure defines the set of data associated with the
*	MACs.
*/

struct	CSPMACInfo {
	/* MIB MAC values */
	MACAddr48	SMTAddress;	/* MAC's SMT address */
	MACAddr48	upstreamNbr;	/* MAC's upstream neighbor */
	uChar		pathsRequested;	/* request path for MAC */
	uTime		RM34cTime;	/* Wait time for checking RM34c */

	/* MAC values from other attributes */
	Flag		operational;	/* SET if MAC is working */
	MACAddr48	dataAddress;	/* MAC's address in data frames */
	uChar		dupPolicy1;	/* RMT DA policy 1 */
	uChar		dupPolicy2;	/* RMT DA policy 2 */
	/* 910122-005 LJP Removed resID */

	/* State information */
	Flag		Loop_Avail;	/* indicating MAC is ready for loop */
	Flag		MAC_Avail;	/* MAC available for PDUs */
};

/*
*	This data structure defines the set of data associated with the
*	PHYs.
*/

struct	CSPPHYInfo {
	/* MIB PORT values */
	uChar	PC_Type;	/* PHY type */
	uChar	connectionPolicies;	/* PHY's connection policies */
	uChar	pathsRequested;	/* requested path for this PHY */
	uInt32	MACLoop_Time;	/* time for loopback */
	uInt32	TB_Max;		/* value for PCM TB_Max */

	/* PORT values from other attributes */
	Flag	operational;	/* SET if PHY is to be used */
	/* 910122-005 LJP Removed resID */

	/* State information */
	uChar	PC_Neighbor;	/* PHY's neighbor's type */
	uChar	PC_Mode;	/* physical connection mode */
	uChar	PC_Withhold;	/* reason for not connecting */
	uInt32	PC_LCT_Fail;	/* count of LCT failures */
	Flag	LCT_Passed;	/* set if LCT passes */
};

/*
*	This data structure defines the set of data associated with the
*	ECM state machine.
*/

struct	ECMInfo {
	uChar	Path_Test;	/* path test status */
	Flag	SB_Flag;	/* stuck bypass */
	Flag	Hold;		/* set if hold policy is enabled */
	Flag	RE_Flag;	/* recovery enabled for hold policy */
	uInt16	TEC;		/* ECM timer ID */
	uChar	ecState;	/* current ECM state */
};

/*
*	This data structure defines the set of data associated with the
*	PCM state machine.
*/

struct	PCMInfo {
	LineState	Maint_LS;	/* line state in maint state */
	uInt16		PC_LS;		/* current line state */
	uChar		n;		/* next signal value */
	Flag		LS_Flag;	/* line state detected */
	Flag		RC_Flag;	/* receive pcode started */
	Flag		TC_Flag;	/* transmit pcode started */
	Flag		TD_Flag;	/* delay transmit pcode */
	uInt16		T_Val;		/* bits sent to neighbor PHY */
	uInt16		R_Val;		/* bits from neighbor PHY */
	Flag		TR_Flag;	/* trace received */
	Flag		BS_Flag;	/* stuck in break */
	Flag		RE_Needed;	/* recovery needed flag */
	uInt16		TPC;		/* PCM state timer ID */
	uInt16		TNE;		/* PCM noise timer */
	uInt16		TScrub;		/* PCM scrubbing timer */
	uTime		LC_Test;	/* time for LCT (in usecs) */
	uChar		pcState;	/* current PCM state */
};

/*
*	This data structure defines the set of data associated with the
*	CEM state machine.
*/

struct	CEMInfo {
	Flag	CF_Loop;		/* requesting MAC for PHY */
	Flag	CF_Join;		/* requesting PHY to join ring */
	uChar	ceState;		/* current CEM state */
	Flag	RM_Join[MAX_MAC_COUNT];	/* 910419-003 LJP */
	Flag	RM_Loop[MAX_MAC_COUNT];	/* 910426-001 LJP */
};

/*
*	This data structure defines the set of data associated with the
*	RMT state machine.
*/
struct	RMTInfo {
	uInt16	traceStatus;	/* current trace status */
	Flag	RM_Loop;	/* indicating MAC set to PHY */
	Flag	RM_Join;	/* indicating PHY is in token path */
	Flag	JM_Flag;	/* jam flag */
	Flag	DA_Flag;	/* duplicate address detected */
	Flag	BN_Flag;	/* beacon state reached */
	Flag	ringOP;		/* current ring operational state */
	Flag	NO_Flag;	/* non-op flag for hold policy */
	uChar	rmState;	/* current RMM state */
	uInt16	TRM;		/* RMT timer ID */
	Flag	inClaim;	/* currently claiming */
	Flag	claimTimed;	/* time since claiming > 2*D_Max */
	uInt16	TRC;		/* RMT claim timer */
	Flag	beaconTimed;	/* time since beaconing > 2*D_Max */
	uInt16	TRB;		/* RMT beacon timer */
};

/*
*	This data structure defines the set of data associated with
*	LEM processing.
*/
struct	LEMInfo {
	uChar	cutoffRate;	/* abs value of LER cutoff exponent */
	uChar	estimate;	/* last LER estimate */
	uChar	leState;	/* current LEM state */
	uInt16	TLE;		/* LEM timer ID */
	uChar	rateIndex;	/* current rate estimate array index */
	uInt16	threshhold;	/* current threshhold error count */
	Flag	LEM_Fail;	/* SMT flag set when link fails */
	uInt32	LEM_Reject_Ct;	/* # times link was rejected */
	uInt32	lemCount;	/* aggregate count */
};


/*********************************************************************
	Signals
*********************************************************************/

/*
*	As defined in the FDDI SMT, signals are used to initiate state
*	transitions. Signals may be sent from a management entity or another
*	state machine, or as a result of a change in hardware status. The
*	signals are divided into groups based upon the state machine used
*	to process the signal. Note that the high byte determines the state
*	machine and the low byte identifies the signal.
*/

#define	TIMER_SIGNAL	0xFF

#define	ECM_SIGNALS		0x100
#define	SIG_Connect	(ECM_SIGNALS | 0x01)
#define	SIG_Disconnect	(ECM_SIGNALS | 0x02)
#define	SIG_Trace_Prop	(ECM_SIGNALS | 0x03)
#define	SIG_Path_Test	(ECM_SIGNALS | 0x04)
#define	SIG_EC_Test_BP	(ECM_SIGNALS | 0x05)	/* line state change in EC6 */
#define	SIG_EC_NO_Flag	(ECM_SIGNALS | 0x06)	/* change in NO_Flag in RMT */
#define	SIG_EC_Timer	(ECM_SIGNALS | TIMER_SIGNAL)

#define	PCM_SIGNALS		0x200
#define	SIG_PC_Start	(PCM_SIGNALS | 0x01)
#define	SIG_PC_Maint	(PCM_SIGNALS | 0x02)
#define	SIG_PC_Trace	(PCM_SIGNALS | 0x03)
#define	SIG_PC_Stop	(PCM_SIGNALS | 0x04)
#define	SIG_PC_Signal	(PCM_SIGNALS | 0x05)
#define	SIG_PC_PDR	(PCM_SIGNALS | 0x06)
#define	SIG_PC_Join	(PCM_SIGNALS | 0x07)
#define	SIG_Line_State	(PCM_SIGNALS | 0x09)
#define	SIG_Noise_Event	(PCM_SIGNALS | 0x0A)
#define	SIG_Noise_Timer	(PCM_SIGNALS | 0x0B)
#define	SIG_PC_Scrub_Start\
			(PCM_SIGNALS | 0x0C)
#define	SIG_PC_Scrub_Complete\
			(PCM_SIGNALS | 0x0D)
#define	SIG_PC_Enable	(PCM_SIGNALS | 0x0F)
#define	SIG_PC_Disable	(PCM_SIGNALS | 0x10)
#define	SIG_PC_LEM_Fail	(PCM_SIGNALS | 0x11)
#define	SIG_PC_RE_Flag	(PCM_SIGNALS | 0x12)	/* change in RE_Flag in ECM */
#define	SIG_PC_Timer	(PCM_SIGNALS | TIMER_SIGNAL)

#define	CFM_SIGNALS		0x300
#define	SIG_CF_Loop	(CFM_SIGNALS | 0x01)
#define	SIG_CF_Join	(CFM_SIGNALS | 0x02)
#define	SIG_CF_Wrap_AB	(CFM_SIGNALS | 0x08)
#define	SIG_CF_Timer	(CFM_SIGNALS | TIMER_SIGNAL)

#define	RMT_SIGNALS		0x400
#define	SIG_RM_Loop	(RMT_SIGNALS | 0x01)
#define	SIG_RM_Join	(RMT_SIGNALS | 0x02)
#define	SIG_Ring_OP	(RMT_SIGNALS | 0x03)	/* change in Ring_OP */
#define	SIG_MAC_Interrupt\
			(RMT_SIGNALS | 0x04)	/* change in MAC state */
#define	SIG_Dup_Addr	(RMT_SIGNALS | 0x06)	/* dupl addr found in FBM */
#define	SIG_RM_DA_Flag	(RMT_SIGNALS | 0x0B)	/* change to DA_Flag */
#define	SIG_RM_RE_Flag	(RMT_SIGNALS | 0x0C)	/* change to RE_Flag */
#define	SIG_RM_Timer	(RMT_SIGNALS | TIMER_SIGNAL)

#define	LEM_SIGNALS		0x500
#define	SIG_LEM_Start	(LEM_SIGNALS | 0x01)	/* start LEM monitoring */
#define	SIG_LEM_Stop	(LEM_SIGNALS | 0x02)	/* stop LEM monitoring */
#define	SIG_LCT_Start	(LEM_SIGNALS | 0x03)	/* start LCT */
#define	SIG_LCT_Stop	(LEM_SIGNALS | 0x04)	/* stop LCT */
#define	SIG_LEM_Threshhold\
			(LEM_SIGNALS | 0x05)	/* H/W count overflow */
#define	SIG_LE_Timer	(LEM_SIGNALS | TIMER_SIGNAL)


/*********************************************************************
	CSP Defined Values
*********************************************************************/

/*
*	MAC Interrupt Types
*/
#define	MAC_My_Claim		0x0001
#define	MAC_My_Beacon		0x0002
#define	MAC_Other_Beacon	0x0004
#define	MAC_TRT_In_T4T5		0x0008
#define	MAC_Rmode		0x0010	/* enters restricted mode */

/*
*	First master port index
*/
#define	PHY_M	(stationData.attachCount)


/*********************************************************************
	CSP Defined Macros
*********************************************************************/

#define	MCF_WRAP_AB	(stationData.configPolicy & Config_CF_Wrap_AB)
#define	MCF_PATH_S	(stationData.pathsAvailable & PA_SECONDARY)
#define	MCF_INSERT_S(n)	(phyData[n].pathsRequested & PA_SECONDARY)

#endif /* __CSPHDR_H */
