/*
@(#) fbmframe.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Frame Based Management Header File

	Frame structure definitions.

	File:		fbmframe.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This file defines the formats of SMT frames.  SMT frames are
	used by SMT to communicate with other stations on the ring for
	the purpose of managing the ring.  The primary purpose of SMT
	frames is to provide information to the other stations to be
	used in managing the network.  These frames are not to be 
	confused with any LLC frames which may be sent on the network.
	SMT frames do not use any LLC format and are defined by in
	section 4 of the X3T9.5 FDDI Station Management Specification.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/
#pragma align 1
#pragma pack  1

/*
*	Every frame sent on an FDDI network has a MAC header prepended
*	to it.  This MAC header is typically put on the frame by the
*	interface for LLC frames, however SMT builds its own MAC headers
*	for a number of reasons.  SMT needs to know more information than
*	most of the protocols because it is keeping track of the FDDI ring
*	status and needs to see information in the MAC header to track 
*	this. Also SMT uses a different FC field in the MAC header than
*	LLC frames.  The layout of the MAC header is fixed and defined
*	in the X3T9.5 MAC standard.
*/
typedef struct MACHdrStruct {
	uChar		pad[FC_PAD_SIZE];	/* shift FC to last byte */
	uChar		FC;		/* Frame control field */
	MACAddr48	DA;		/* Destination 48 bit address */
	MACAddr48	SA;		/* Source 48 bit address */
} MACHdrType;


/*
*	Every SMT frame has an SMT header on it.  The header immediately
*	follows the MAC header of the FDDI frame.  The format of an
*	SMT header is defined below.  This format is fixed and defined in
*	the X3T9.5 FDDI Station Management specification.
*/
typedef struct SMTHdrStruct {
	uChar		Frame_Class;		/* Frame class field */
	uChar		Frame_Type;		/* Frame type field */
	uInt16		Version_ID;		/* Version id field */
	uInt32		Transaction_ID;		/* Transaction id field */
	SMTStationIdType Station_ID;		/* Station id field */
	uChar		pad[2]; 		/* Padding */
	uInt16		InfoField_Length;	/* Length of the info field */
} SMTHdrType;

/*
*	General structure for SMT frame headers.
*/
typedef struct SMTFrameHdrStruct {
	MACHdrType	macHdr;
	SMTHdrType	smtHdr;
} SMTFrameHdrType;

/*
*	Size of SMT frame header.
*/
#define	SMT_FRAME_HDR_SIZE	(sizeof (SMTFrameHdrType) - FC_PAD_SIZE)


/*********************************************************************
	FC fields used by SMT.
*********************************************************************/

#define SMT_NSA_FC	0x4f		/* Next Station Addressing */
#define SMT_INFO_FC	0x41		/* SMT info */


/*********************************************************************
	The following constants are used in building smt headers.
*********************************************************************/

/*
*	Definitions for the frame class field.
*/
#define NIF_CLASS	0x01		/* NIF class */
#define SIFCONFIG_CLASS	0x02		/* SIF configuration class */
#define SIFOP_CLASS	0x03		/* SIF operation class */
#define ECHO_CLASS	0x04		/* Echo frame class */
#define RAF_CLASS	0x05		/* Resource allocation frame class */
#define RDF_CLASS	0x06		/* Request denied frame class */
#define	SRF_CLASS	0x07		/* Status report frame class */
#define	PMFGET_CLASS	0x08		/* PMF get class */
#define	PMFCHANGE_CLASS	0x09		/* PMF change class */
#define	PMFADD_CLASS	0x0A		/* PMF add class */
#define	PMFREMOVE_CLASS	0x0B		/* PMF remove class */
#define ESF_CLASS	0xFF		/* Extended service frame class */

/*
*	Definitions for the frame type field.
*/
#define SMTANNOUNCE	0x01		/* SMT announcement frame type */
#define SMTREQUEST	0x02		/* SMT request frame type */
#define SMTRESPONSE	0x03		/* SMT response frame type */

/*
*	Throughout the info fields of the smt frames are found parameters
*	which have very strict layout conventions.  These conventions 
*	provide for a type and length field for each parameter and are 
*	defined in the SMT specification.  The following typedefs provide
*	skeletons for these parameters.  These parameters are used by
*	SMT to build info fields for the frames it sends and for parsing
*	frames it received.
*/

/*
*	Each parameter has a fixed header on it which describes the
*	length and type of the parameter.
*/
typedef struct SMTParamHdrStruct {
	uInt16	type;		/* The type of the parameter */
	uInt16	length;		/* Length of the parameter */
} ParamHdrType;

/*
*	Defines for the type field of the ParamHdrType
*/
#define UNA_PARAM_TYPE			0x01	/* Upstream neighbor address */
#define STATION_DESC_PARAM_TYPE		0x02	/* Station Descriptor */
#define STATION_STATE_PARAM_TYPE	0x03	/* Station State */
#define MSG_TIME_STAMP_PARAM_TYPE	0x04	/* Time Stamp */
#define STATION_POLICIES_PARAM_TYPE	0x05	/* Policies used by station */
#define PATH_LATENCY_PARAM_TYPE		0x06	/* Path latency type */
#define	MAC_NEIGHBORS_PARAM_TYPE	0x07	/* MAC neighbors */
#define PATH_DESC_PARAM_TYPE		0x08	/* Path descriptor */
#define MAC_STATUS_PARAM_TYPE		0x09	/* MAC status */
#define LER_STATUS_PARAM_TYPE		0x0a	/* PORT LER monitor status */
#define FRAME_COUNTERS_PARAM_TYPE	0x0b	/* MAC frame counters */
#define FRAME_NOT_COPIED_PARAM_TYPE	0x0c	/* Frames not copied count */
#define PRIORITY_VALUES_PARAM_TYPE	0x0d	/* MAC priority values */
#define EB_STATUS_PARAM_TYPE		0x0e	/* Elasticity buffer status */
#define MANUFACTURER_PARAM_TYPE		0x0f	/* Manufacturer data field */
#define USER_PARAM_TYPE			0x10	/* User defined data field */
#define ECHO_PARAM_TYPE			0x11	/* Echo data */
#define REASON_CODE_PARAM_TYPE		0x12	/* Reason code */
#define REJECTED_FRAME_PARAM_TYPE	0x13	/* Rejected frame beginning */
#define SUPPORTED_VERSIONS_PARAM_TYPE	0x14	/* SMT versions supported */
#define ESFID_PARAM_TYPE		0xffff	/* Extended service field */
#define	AUTHORIZATION_PARAM_TYPE	0x21	/* PMF authorization field */

/*********************************************************************
	The various parameter types.
*********************************************************************/

/*
*	Upstream neighbor address
*/
typedef struct UNAParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	MACAddr48	UNA;		/* The actual address of the una */
} UNAParamType;


/*
*	Station Descriptor
*/
typedef struct StationDescParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		NodeClass;	/* Type of station. */
	uChar		Mac_Ct;		/* Number of MACs in station */
	uChar		NonMaster_Ct;	/* Number of attachments */
	uChar		Master_Ct;	/* Number of Master attachments */
} StationDescParamType;


/*
*	Station State
*/
typedef struct StationStateParamStruct  {
	ParamHdrType	hdr;		/* Parameter header */
	uChar		pad[2];		/* Padding */
	uChar		Topology;	/* Topology of station */
	uChar		DuplAddr;	/* Duplicate address status */
} StationStateParamType;

typedef struct MsgTimeStampParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	SMTTimeStamp	MsgTimeStamp;	/* The actual time stamp */
} MsgTimeStampParamType;

/*
*	Station Policies
*/
typedef struct StationPoliciesParamStruct  {
	ParamHdrType	hdr;		/* Parameter header */	
	uInt16		ConfigPolicy;	/* 1 if Hold available */
	uInt16		ConnectionPolicy; /* connection types rejected */
} StationPoliciesParamType;

/*
*	Path Latency Contribution per Ring
*/
typedef struct PathLatencyParamStruct {
	ParamHdrType	hdr;			/* Parameter header */	
	uInt16		PORTOutIndex1;		/* output PORT on ring 1 */
	uInt16		PathLatencyRing1;	/* Latency in octets */
	uInt16		PORTOutIndex2;		/* output PORT on ring 2 */
	uInt16		PathLatencyRing2;	/* Latency in in octets */
} PathLatencyParamType;

/*
*	MAC Neighbors
*/
typedef struct MACNeighborsParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		MAC_Index;	/* index for MAC */
	MACAddr48	UNA;		/* Upstream neighbor */
	MACAddr48	DNA;		/* Downstream neighbor */
} MACNeighborsParamType;


/*
*	Path Descriptor
*	The path descriptor consists of records for each PORT and each
*	MAC in the station.
*/	
typedef struct PathPORTRecordStruct {
	uChar	pad[2];			/* Padding */
	uChar	PORTType;		/* PHY type A B S M */
	uChar	ConnectState;		/* Connect state */
	uChar	RemotePORTType;		/* Remote PHY type */
	uChar	RemoteMAC;		/* Remote MAC */
	uInt16	ConResourceIndex;	/* Resource PORT output connected to */
} PathPORTRecordType;

typedef struct PathMACRecordStruct {
	MACAddr48	MAC_Addr;		/* MAC's address */
	uInt16		ConResourceIndex;	/* Output of MAC */
} PathMACRecordType;

typedef struct PathDescParamStruct {
	ParamHdrType	hdr;		/* parameter header */
	uChar		data;		/* start of data records */
} PathDescParamType;

/*
*	MAC Status
*/
typedef struct MACStatusStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		MAC_Index;	/* Index of MAC */
	uInt32		T_Req;		/* T-Req for this MAC */
	uInt32		T_Neg;		/* T-Neg for this MAC */
	uInt32		T_Max;		/* T-Max for this MAC */
	uInt32		TVXValue;	/* TVX value for this MAC */
	uInt32		T_Min;		/* T-Min for this MAC */
	uInt32		SBA;		/* SBA for this MAC */
	uInt32		Frame_Ct;	/* Frame count for this MAC */
	uInt32		Error_Ct;	/* Error count for this MAC */
	uInt32		Lost_Ct;	/* Lost frame count for this MAC */
} MACStatusParamType;

/*
*	PORT Link Error Rate Monitoring (LER) Status
*/
typedef struct LERStatusParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		PORT_Index;	/* PHY index */
	uChar		pad1;		/* More padding */
	uChar		Ler_Cutoff;	/* LER cutoff value */
	uChar		Ler_Alarm;	/* LER alarm value */
	uChar		Ler_Estimate;	/* LER estimate value */
	uInt32		Lem_Reject_Ct;	/* LEM reject count value */
	uInt32		Lem_Ct;		/* LEM count value */
} LERStatusParamType;

/*
*	MAC Frame Counters
*/
typedef struct FrameCountersParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		MAC_Index;	/* MAC index */
	uInt32		Receive_Ct;	/* Number of frames received (copied) */
	uInt32		Transmit_Ct;	/* Number of frames transmitted */
} FrameCountersParamType;

/*
*	MAC Frame Not Copied Count
*/
typedef struct FrameNotCopiedParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		MAC_Index;	/* MAC index */
	uInt32		NotCopied_Ct;	/* Number of frames not copied */
} FrameNotCopiedParamType;

/*
*	MAC Priority Values
*/
typedef struct PriorityValuesParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		MAC_Index;	/* MAC index */
	uInt32		T_Pri0;		/* T priority 0 */
	uInt32		T_Pri1;		/* T priority 1 */
	uInt32		T_Pri2;		/* T priority 2 */
	uInt32		T_Pri3;		/* T priority 3 */
	uInt32		T_Pri4;		/* T priority 4 */
	uInt32		T_Pri5;		/* T priority 5 */
	uInt32		T_Pri6;		/* T priority 6 */
} PriorityValuesParamType;

/*
*	PORT EB Status
*/
typedef struct EBStatusParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		pad[2];		/* Padding */
	uInt16		PORT_Index;	/* PHY index */
	uInt32		EbErrorCt;	/* Elasticity buffer error count */
} EBStatusParamType;

/*
*	Manufacturer Field
*/
typedef struct ManufacturerParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	SMTManufacturerDataType
			manuf;		/* manufacturer OUI and data */
} ManufacturerParamType;

/*
*	User Field
*/
typedef struct UserParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	SMTUserDataType	user_data;	/* user data field */
} UserParamType;

/*
*	Echo Data
*/
typedef struct EchoParamStruct {
	ParamHdrType	hdr;		/* Parameter header */	
	uChar		echo_data[1];	/* variable length array */
} EchoParamType;

/*
*	Reason Code
*/
typedef struct ReasonCodeParamStruct {
	ParamHdrType	hdr;		/* parameter headers */
	uInt32		reason;		/* Reason an SMT frame is rejected */
} ReasonCodeParamType;

/*
*	Rejected Frame Beginning
*/
typedef	struct RejectedFrameParamStruct {
	ParamHdrType	hdr;		/* parameter header */
	uChar		pad[3];		/* alignment for MAC header */
	uChar		rejected_frame_beginning[1];	/* first n octets */
} RejectedFrameParamType;

/*
*	SMT Supported Versions
*/
typedef struct SupportedVersionsParamStruct {
	ParamHdrType	hdr;		/* parameter header */
	uChar		pad[2];		/* padding */
	uChar		numVersions;	/* # of versions supported */
	uChar		indexOpVersion;	/* current operational version */
	uInt16		Version[1];	/* variable list of versions */
} SupportedVersionsParamType;

/*
*	ESF ID
*/
typedef struct ESFIDParamStruct {
	ParamHdrType	hdr;		/* parameter header */
	uChar		pad[2];		/* padding */
	uChar		ESF_ID[6];	/* 48-bit, IEEE-assigned ID */
} ESFIDParamType;

/*
*	Authorization Parameter
*/
typedef struct AuthorizationParamStruct {
	ParamHdrType	hdr;		/* parameter header */
	uChar		Authorization[1];/* authorization data */
} AuthorizationParamType;


#pragma align 16
#pragma pack  16

/*********************************************************************
	Specific Frame Parameter Values

	These values are used only by frame parameters and are not
	generally used in SMT.
*********************************************************************/

/*
*	Connection policies for Station State
*/
#define	FBM_rejectA_A	0x01
#define	FBM_rejectB_B	0x02
#define	FBM_rejectS_S	0x04
#define	FBM_rejectA_M	0x08
#define	FBM_rejectB_M	0x10
#define	FBM_rejectA_S	0x20
#define	FBM_rejectB_S	0x40


