/*
@(#) fddihdr.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Station Management Header File

	FDDI Header File

	File:		fddihdr.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This is the header file contains all definitions and constant
	values specified in the FDDI SMT documentation.

	Modification History:

	*** Updated to SMT 6.2 ***

	910429-001	LJP
		Define beacon type constant definitions.
*********************************************************************/
#ifndef __FDDI_FDDIHDR_H
#   define __FDDI_FDDIHDR_H
/*********************************************************************
	Timer Values
*********************************************************************/

/*
*	These time values are specified in the FDDI SMT Connection Management
*	Facilities documentation. For convenience in handling time values, all
*	times are expressed in microseconds (usecs).
*/

/*	Timer Calculation Elements */
#define	D_Max		(uTime) 1773

/*	ECM Expiration Values */
#define	I_Max_Default	(uTime) 25000
#define	IN_Max		(uTime) 40000
#define	TD_Min		(uTime) 5000
#define	Trace_Max_Default	(uTime) 7000000
#define	Min_Trace_Max	(uTime) 6001773		/* min value for Trace_Max */

/* PCM Expiration Values */
#define	C_Min		(uTime) 1600
#define	TL_Min		(uTime) 30
	/* LS_Min	0.48 usecs must be handled by hardware */
#define	TB_Min		(uTime) 5000
#define	TB_Max_Default	(uTime) 50000
#define	T_Out		(uTime) 100000
#define	NS_Max		(uTime) 1300
#define	LC_Short	(uTime) 50000
#define	LC_Medium	(uTime) 500000
#define	LC_Long		(uTime) 5000000
#define	LC_Extended	(uTime) 50000000
#define	T_Next_9	(uTime) 200000

/* CFM Expiration Values */
#define	T_Scrub		(uTime) 3500

/* RMT Expiration Values */
#define	T_Non_OP	(uTime) 1000000
#define	T_Stuck		(uTime) 8000000
#define	T_Direct	(uTime) 370000
#define	T_Jam		(uTime) 370000
#define	T_DBJ		(uTime) 82000
#define	T_Announce	(uTime) 2500000
#define	T_Rmode_Default	(uTime) 0
#define	Dup_Max		(D_Max + D_Max)
	/*
	* The amount of skew is the amount of time to reduce T_Max
	* for checking the RM(34c) transition.
	*/
#define T_RM34c		(uTime) 5000

/* FBM Expiration Values */
/*
*	Note: These values represent time in seconds.
*/
#define	T_Notify_Default	30
#define	T_NN_Out		228


/*********************************************************************
	CMT & RMT States
*********************************************************************/

/*
*	The following defined values are used to determine the current
*	states for each state machine. The values and names used follow
*	the FDDI SMT documentation.
*/

/*
*	ECM States
*/
#define	EC_OUT		0
#define	EC_IN		1
#define	EC_TRACE	2
#define	EC_LEAVE	3
#define	EC_PATH_TEST	4
#define	EC_INSERT	5
#define	EC_CHECK	6
#define	EC_DEINSERT	7

/*
*	CFM States
*/
#define	CF_ISOLATED	0
#define	CF_WRAP_S	1
#define	CF_WRAP_A	2
#define	CF_WRAP_B	3
#define	CF_WRAP_AB	4
#define	CF_THRU		5

/*
*	CCE States
*/
#define	CE_ISOLATED	0
#define	CE_INSERT_P	1
#define	CE_INSERT_S	2
#define	CE_INSERT_X	3
#define	CE_LOCAL	4

/*
*	PCM States
*/
#define	PC_OFF		0
#define	PC_BREAK	1
#define	PC_TRACE	2
#define	PC_CONNECT	3
#define	PC_NEXT		4
#define	PC_SIGNAL	5
#define	PC_JOIN		6
#define	PC_VERIFY	7
#define	PC_ACTIVE	8
#define	PC_MAINT	9

/*
*	RMT States
*/
#define	RM_ISOLATED	0
#define	RM_NON_OP	1
#define	RM_RING_OP	2
#define	RM_DETECT	3
#define	RM_NON_OP_DUP	4
#define	RM_RING_OP_DUP	5
#define	RM_DIRECTED	6
#define	RM_TRACE	7

/*
*	RMT Substates used in XDI SMT implementation.
*/
#define	RM_JAM_A_WAIT_TJAM	41
#define	RM_JAM_B_WAIT_TDBJ	42
#define	RM_JAM_B_WAIT_TJAM	43

/*
*	LEM States used in XDI SMT implementation.
*/
#define	LE_OFF		0
#define	LE_MONITOR	1
#define	LE_LCT		2


/*********************************************************************
	SMT Definitions
*********************************************************************/

/*
*	Configuration Capabilities/Policies
*/
#define	Config_None		0x0
#define	Config_Hold_Available	0x0001
#define	Config_CF_Wrap_AB	0x0002

/*
*	Connection Policies
*/
#define	Policy_rejectA_A	0x0001
#define	Policy_rejectA_B	0x0002
#define	Policy_rejectA_S	0x0004
#define	Policy_rejectA_M	0x0008
#define	Policy_rejectB_A	0x0010
#define	Policy_rejectB_B	0x0020
#define	Policy_rejectB_S	0x0040
#define	Policy_rejectB_M	0x0080
#define	Policy_rejectS_A	0x0100
#define	Policy_rejectS_B	0x0200
#define	Policy_rejectS_S	0x0400
#define	Policy_rejectS_M	0x0800
#define	Policy_rejectM_A	0x1000
#define	Policy_rejectM_B	0x2000
#define	Policy_rejectM_S	0x4000
#define	Policy_rejectM_M	0x8000
/* Additional policy types used by XLNT Manager */
#define	Policy_limited		(~(Policy_rejectA_B | Policy_rejectB_A\
					| Policy_rejectS_M | Policy_rejectM_S))
#define	Policy_expanded		(Policy_rejectM_M)
#define	Policy_acceptAll	0x0
#define	Policy_rejectAll	0xFFFF

/*
*	Hold State
*/
#define	HS_Not_Holding	0
#define	HS_Holding_Prm	1			/* holding on primary */
#define	HS_Holding_Sec	2			/* holding on secondary */

/*
*	T_Notify Limits
*/
#define	T_Notify_Min		2
#define	T_Notify_Max		30

/*
*	Station Actions
*/
#define	StationAction_Connect		0
#define	StationAction_Disconnect	1
#define	StationAction_Path_Test		2
#define	StationAction_Self_Test		3


/*********************************************************************
	MAC Definitions
*********************************************************************/

/*
*	Frame Status Capabilities
*/
#define	FSC_None	0
#define	FSC_Type0	0x0001
#define	FSC_Type1	0x0002
#define	FSC_Type2	0x0004
#define	FSC_Type0_Pgm	0x0100
#define	FSC_Type1_Pgm	0x0200
#define	FSC_Type2_Pgm	0x0400

/*
*	Bridge Function
*/
#define	Bridge_None	0
#define	Bridge_Type0	0x01
#define	Bridge_Type1	0x02

/*
*	Master-Slave Loop Status
*/
#define	MSLoop_Unknown		0
#define	MSLoop_Suspected	1
#define	MSLoop_None		2

/*
*	Duplicate Address Test
*/
#define	DA_Test_None		0
#define	DA_Test_Pass		1
#define	DA_Test_Fail		2

/*
*	Neighbor Change Event Conditions
*/
#define	EVENT_UNA_CHANGED	0x01
#define	EVENT_DNA_CHANGED	0x02

/*
*	MAC Actions
*/
#define	MACAction_EnableLLCService	0
#define	MACAction_DisableLLCService	1
#define	MACAction_ConnectMAC		2
#define	MACAction_DisconnectMAC		3


/*********************************************************************
	PATH Definitions
*********************************************************************/

/*
*	Paths Available/Current Path
*/
#define	PA_UNKNOWN	0x00
#define	PA_PRIMARY	0x01
#define	PA_SECONDARY	0x02
#define	PA_LOCAL	0x04
#define	PA_ISOLATED	0x08

/*
*	PATH Order
*/
#define	Path_Order_Unsupported	0
#define	Path_Order_Ascending	1
#define	Path_Order_Descending	2

/*
*	PATH Class Type
*/
#define	Path_Type_Local		0
#define	Path_Type_nonLocal	1

/*
*	PATH Trace Status
*/
#define	Trace_NoCurrent		0
#define	Trace_Initiated		1
#define	Trace_Propagated	2
#define	Trace_Terminated	3

/*
*	Path Status
*/
#define	Path_Status_Wrapped	0
#define	Path_Status_Thru	1


/*********************************************************************
	PORT Definitions
*********************************************************************/

/*
*	PC_Type & PC_Neighbor Values
*/
#define	PC_Type_A	0
#define	PC_Type_B	1
#define	PC_Type_S	2
#define	PC_Type_M	3
#define	PC_Type_Unknown	4
#define	PC_Type_None	PC_Type_Unknown

/*
*	Connection State Values
*/
#define	Connect_Disabled	0	/* PC0:OFF */
#define	Connect_Connecting	1	/* !PC8:ACTIVE & !PC0:OFF !PC2:TRACE
						& PC_Withhold = None */
#define	Connect_Standby		2	/* PC_Withhold != None */
#define	Connect_Active		3	/* PC8:ACTIVE */

/*
*	PORT Connection Policies.
*/
#define	PC_MAC_None		0
#define	PC_MAC_LCT		0x01
#define	PC_MAC_Loop		0x02
#define	PC_MAC_Placement	0x04

/*
*	PC_Withhold Values
*/
#define	PC_WH_None		0	/* no withholding */
#define	PC_WH_M_to_M		1	/* PHY M to PHY M */
#define	PC_WH_Other		2	/* Other incompatible PHY types */

/*
*	Maintenance Line States
*/
#define	Maint_QLS	0
#define	Maint_ILS	1
#define	Maint_MLS	2
#define	Maint_HLS	3
#define	Maint_PDR	4

/*
*	Limits on LER ranges
*/
#define	LER_MIN	4
#define	LER_MAX	15

/*
*	PORT FOTX Class
*/
#define	FOTX_Multimode		0
#define	FOTX_Single_Mode1	1
#define	FOTX_Single_Mode2	2
#define	FOTX_SONET		3

/*
*	PORT Actions
*/
#define	PORTAction_Maint	0
#define	PORTAction_Enable	1
#define	PORTAction_Disable	2
#define	PORTAction_Start	3
#define	PORTAction_Stop		4


/*********************************************************************
	ATTACHMENT Definitions
*********************************************************************/

/*
*	ATTACHMENT Classes
*/
#define	Attachment_Class_Single		0
#define	Attachment_Class_Dual		1
#define	Attachment_Class_Concentrator	2


/*********************************************************************
	CMT Definitions
*********************************************************************/

/*
*	Path_Test Values
*/
#define	PT_None		0
#define	PT_Testing	1
#define	PT_Passed	2
#define	PT_Failed	3
#define	PT_Pending	4
#define	PT_Exiting	5

/*
*	PC_Mode Values
*/
#define	PC_Mode_Peer	0
#define	PC_Mode_Tree	1
#define	PC_Mode_None	2

/*
*	Line States
*	These lines define the constant names used in the CSP code.
*	The actual values for the line states are defined in smtdefs.h.
*/
#define	ALS		(Active_Line_State)
#define	HLS		(Halt_Line_State)
#define	ILS		(Idle_Line_State)
#define	MLS		(Master_Line_State)
#define	NLS		(Noise_Line_State)
#define	PDRLS		(Transmit_PHY_Data_Request)
#define	QLS		(Quiet_Line_State)
#define	SILS		(Super_Idle_Line_State)

/*
*	RMT Duplicate Address Policies
*/
#define	RMT_DUP_CHANGE	1		/* perform change actions */
#define	RMT_DUP_JAM_A	2		/* perform jam actions */
#define	RMT_DUP_JAM_B	3		/* perform jam actions */
#define	RMT_DUP_LEAVE	4		/* leave ring */


/*********************************************************************
	FBM Definitions
*********************************************************************/

/*
*	Known Address Formats
*/
	/* FDDI broadcast address X'FF FF FF FF FF FF' */
#define	BROADCAST_ADDRESS	"\377\377\377\377\377\377"

	/* FDDI Null address X'00 00 00 00 00 00' */
#define	NULL_ADDRESS		"\0\0\0\0\0\0"
#define	UNKNOWN_ADDRESS		NULL_ADDRESS

	/* Directed beacon for RMT X'01 80 C2 00 01 00' (canonical) */
	/*                         X'80 01 43 00 80 00' (FDDI) */
#define	DIR_BCN_ADDRESS		"\200\001\103\000\200\000"

	/* SRF Multicast address X'01 80 C2 00 01 10' (canonical) */
	/*                       X'80 01 43 00 80 08' (FDDI) */
#define	SRF_MULTICAST_ADDRESS	"\200\001\103\000\200\010"

/*
*	Beacon Types
*
*	910429-001	LJP
*	Added definitions for beacon types.
*/
#define	BCN_CLAIM_FAILED	0
#define	BCN_DIRECTED		1

/*
*	Reason Denied Codes
*/
#define	RC_FRAME_CLASS		((uInt32) 0x01)
#define	RC_FRAME_VERSION	((uInt32) 0x02)
#define	RC_SUCCESS		((uInt32) 0x03)
#define	RC_BAD_SET_COUNT	((uInt32) 0x04)
#define	RC_READ_ONLY		((uInt32) 0x05)
#define	RC_NO_PARAM		((uInt32) 0x06)
#define	RC_NO_MORE		((uInt32) 0x07)
#define	RC_OUT_OF_RANGE		((uInt32) 0x08)
#define	RC_NOT_AUTHORIZED	((uInt32) 0x09)
#define	RC_LENGTH_ERROR		((uInt32) 0x0A)
#define	RC_FRAME_TOO_LONG	((uInt32) 0x0B)
#define	RC_ILLEGAL_PARAMETER	((uInt32) 0x0C)

/* XLNT Manager value */
#define	RC_ERROR_UNKNOWN	((uInt32) 0xFE)
#define	RC_BUFFER_ERROR		((uInt32) 0xFF)

/*
*	Node Class of Station Descriptor Parameter
*	The type of station we are can be one of two things, either a
*	station or a concentrator.  The values for these are defined
*	below.
*/
#define SMT_Type_Station	0
#define SMT_Type_Concentrator	1

/*
*	Topology Bit Assignments of Station State Parameter
*	The station's current topology is indicated by which bit is set.
*/
#define	Topology_Thru		0x00
#define	Topology_Wrapped	0x01
#define	Topology_Unrooted	0x02
#define	Topology_Twisted_AA	0x04
#define	Topology_Twisted_BB	0x08
#define	Topology_Rooted_Station	0x10
#define	Topology_SRF		0x20

/*
*	Duplicate Address Bit Assignments of Station State Parameter
*	MAC's current duplicate address status for the
*	Station State parameter.
*/
#define	DuplAddr_My_Duplicate		0x01
#define	DuplAddr_My_UNA_Duplicate	0x02

/*
*	Maximum Interval Between SRFs (in seconds).
*/
#define	MAX_SRF_INTERVAL	32

/*
*	Frame Status Values
*	Defined in smtdefs.h.
*/
#define	E_Indicator	E_Bit_Position
#define	A_Indicator	A_Bit_Position
#define	C_Indicator	C_Bit_Position


/*********************************************************************
*	XLNT Manager Standard Defined Values
*********************************************************************/

/*
*	Attach PORT Indexes
*/
#define	PHY_A	0
#define	PHY_B	1
#define	PHY_S	0

/*
*	Station MAC Indexes
*/
#define	PRIMARY_MAC	0
#define	SECONDARY_MAC	1
#define	LOCAL_MAC	2
#define	MAC_P		PRIMARY_MAC
#define	MAC_S		SECONDARY_MAC
#define	MAC_L		LOCAL_MAC

/* These values are left for compatibility with older software */
#define	MAC_1	0
#define	MAC_2	1

/*
*	PATH Indexes
*/
#define	PATH_P	0
#define	PATH_S	1
#define	PATH_L	2

/*
*	MIB Attach PORT Indexes
*/
#define	MIB_PHY_A	1
#define	MIB_PHY_B	2
#define	MIB_PHY_S	1

/*
*	MIB MAC Indexes
*/
#define	MIB_MAC_P	1
#define	MIB_MAC_S	2
#define	MIB_MAC_L	3

/*
*	Entity Types
*
*	These are arbitrary assignments until the SMT committee sets
*	the proper values.
*/
#define	PHY_TYPE	0
#define	PORT_TYPE	PHY_TYPE
#define	MAC_TYPE	1

#endif /*__FDDI_FDDIHDR_H */
