/*
@(#) mibtypes.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Management Information Base Header File

	MIB structure definition.

	File:		mibtypes.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This file contains type definitions used by the Management 
	Information Base (MIB).  The MIB is accessed through
	get, set, add and change routines.  It contains or has access 
	to all SMT attributes within a particular station.  

	Modification History:

	*** CREATED FOR SMT 6.2 ***
	910122-005	LJP
		Removed OutIndex1 and OutIndex2 from XDI SMT group.
	910412-001	LJP
		Added EBErrorCondition to XDI PORT group.
*********************************************************************/
#ifndef __MIBTYPES_H
#define __MIBTYPES_H

#pragma align 1
#pragma pack  1

/**********************************************************************
*
*	Typedefs for the attribute groups. Groups are based on the
*	format as defined in the SMT standard. The member names are
*	the attribute names with the object portion deleted (e.g.,
*	fddiSMTStationId becomes SMTStationId). The group names use the
*	attribute group names with the "fddi" portion deleted.
*
**********************************************************************/

/**********************************************************************
*	SMT Group Types
**********************************************************************/

/*
*	fddiSMTStationIdGrp	{fddiSMT 10}
*/
typedef struct SMTStationIdGrpStruct {
	SMTStationIdType	StationId;	/* the SMT station id */
	uInt16			OpVersionId;	/* version of SMT */
	uInt16			HiVersionId;	/* highest version supported */
	uInt16			LoVersionId;	/* lowest version supproted */
	SMTManufacturerDataType	ManufacturerData;/* manufacturer's data */
	SMTUserDataType		UserData;	/* user data */
} SMTStationIdGrpType;

/*
*	fddiSMTStationConfigGrp	{fddiSMT 20}
*/
typedef struct SMTStationConfigGrpStruct {
	uChar		MAC_Ct;			/* number of MACs */
	uChar		NonMaster_Ct;		/* number of attachments */
	uChar		Master_Ct;		/* number of masters */
	uChar		PathsAvailable;		/* available paths in stn */
	uInt16		ConfigCapabilities;	/* configuration options */
	uInt16		ConfigPolicy;		/* configuration selected */
	uInt16		ConnectionPolicy;	/* connections allowed */
	uInt32		ReportLimit;		/* SRF limit */
	uInt16		T_Notify;		/* NIF NN interval */
	uChar		StatusReporting;	/* SRF flag */
} SMTStationConfigGrpType;

/*
*	fddiSMTStatusGrp	{fddiSMT 40}
*/
typedef	struct SMTStatusGrpStruct {
	uChar		ECMState;		/* current ECM state */
	uChar		CF_State;		/* current config state */
	uInt16		HoldState;		/* current Hold condition */
	uChar		RemoteDisconnectFlag;	/* remotely disconnected */
} SMTStatusGrpType;

/*
*	fddiSMTMIBOperationGrp	{fddiSMT 50}
*/
typedef	struct SMTMIBOperationGrpStruct {
	SMTTimeStamp	MsgTimeStamp;		/* station time stamp */
	SMTTimeStamp	TransitionTimeStamp;	/* SRF time stamp */
	SetCountType	SetCount;		/* PMF support */
	SMTStationIdType	
			LastSetStationId;	/* last station to set MIB */
} SMTMIBOperationGrpType;

/**********************************************************************
*	MAC Group Types
**********************************************************************/

/*
*	fddiMACCapabilitiesGrp	{fddiMAC 10}
*/
typedef	struct MACCapabilitiesGrpStruct {
	uInt16		FrameStatusCapabilities;/* AC indicator capabilities */
	uInt16		BridgeFunction;		/* bridging type */
	uInt32		T_MaxGreatestLowerBound;/* lowest T_Max */
	uInt32		TVXGreatestLowerBound;	/* lowext TVX */
} MACCapabilitiesGrpType;

/*
*	fddiMACConfigGrp	{fddiMAC 20}
*/
typedef	struct MACConfigGrpStruct {
	uChar		PathsAvailable;		/* usable MAC paths */
	uInt16		CurrentPath;		/* path for MAC */
	MACAddr48	UpstreamNbr;		/* MAC's upstream neighbor */
	MACAddr48	DownstreamNbr;		/* MAC's dwnstrm neighbor */
	MACAddr48	OldUpstreamNbr;		/* MAC's previous nbr */
	MACAddr48	OldDownstreamNbr;	/* MAC's pervious nbr */
	uChar		RootConcentratorMAC;	/* flag if root */
	uInt16		Dup_Addr_Test;		/* dup addr test status */
	uChar		PathsRequested;		/* preferred path for MAC */
	uInt16		DownstreamPORTType;	/* PC-Type of dwnstrm prt */
} MACConfigGrpType;

/*
*	fddiMACAddressGrp	{fddiMAC 40}
*/
typedef	struct MACAddressGrpStruct {
	MACAddr48	SMTAddress;		/* MAC's 48-bit address */
	uChar		*LongAliases;		/* list of long aliases */
	uChar		*ShortAliases;		/* list of short aliases */
	uChar		*LongGrpAddrs;		/* list of long group addrs */
	uChar		*ShortGrpAddrs;		/* list of short group addrs */
} MACAddressGrpType;

/*
*	fddiMACOperationGrp	{fddiMAC 50}
*/
typedef	struct MACOperationGrpStruct {
	uInt32		T_Req;
	uInt32		T_Neg;
	uInt32		T_Max;
	uInt32		TvxValue;
	uInt32		T_Min;
	uInt32		T_Pri0;
	uInt32		T_Pri1;
	uInt32		T_Pri2;
	uInt32		T_Pri3;
	uInt32		T_Pri4;
	uInt32		T_Pri5;
	uInt32		T_Pri6;
	uInt16		FrameStatus;		/* MAC's current status */
} MACOperationGrpType;

/*
*	fddiMACCountersGrp	{fddiMAC 70}
*/
typedef	struct MACCountersGrpStruct {
	uInt32		Frame_Ct;
	uInt32		Copied_Ct;
	uInt32		Transmit_Ct;
	uInt32		Token_Ct;
} MACCountersGrpType;

/*
*	fddiMACErrorCtrsGrp	{fddiMAC 80}
*/
typedef	struct MACErrorCtrsGrpStruct {
	uInt32		Error_Ct;
	uInt32		Lost_Ct;
	uInt32		TvxExpired_Ct;
	uInt32		NotCopied_Ct;
	uInt16		Late_Ct;
	uInt32		RingOp_Ct;
} MACErrorCtrsGrpType;

/*
*	fddiMACFrameErrorConditionGrp	{fddiMAC 90}
*/
typedef	struct MACFrameErrorConditionGrpStruct {
	uInt32		BaseFrame_Ct;
	uInt32		BaseError_Ct;
	uInt32		BaseLost_Ct;
	SMTTimeStamp	BaseTimeFrameError;
	uInt16		FrameErrorThreshold;
	uInt16		FrameErrorRatio;
} MACFrameErrorConditionGrpType;

/*
*	fddiMACNotCopiedConditionGrp	{fddiMAC 100}
*/
typedef	struct MACNotCopiedConditionGrpStruct {
	uInt32		BaseNotCopied_Ct;
	SMTTimeStamp	BaseTimeNotCopied;
	uInt16		NotCopiedThreshold;
	uInt32		BaseCopied_Ct;
	uInt16		NotCopiedRatio;
} MACNotCopiedConditionGrpType;

/*
*	fddiMACStatusGrp	{fddiMAC 110}
*/
typedef	struct MACStatusGrpStruct {
	uChar		RMTState;		/* current RMT state */
	uChar		Da_Flag;		/* dup addr flag */
	uChar		UnaDa_Flag;		/* dup addr from UNA */
	uChar		FrameErrorCondition;	/* current condition */
	uChar		NotCopiedCondition;	/* current condition */
	uChar		LLCServiceAvailable;	/* LLC service enabled */
} MACStatusGrpType;

/*
*	fddiMACRootMACStatusGrp	{fddiMAC 120}
*/
typedef	struct MACRootMACStatusGrpStruct {
	uChar		MasterSlaveLoopStatus;	/* loop detection stat */
	uChar		RootMACDownStreamPORTType;
	uInt16		RootMACCurrentPath;	/* path for root MAC */
} MACRootMACStatusGrpType;

/**********************************************************************
*	PATH Class Group Types
**********************************************************************/

/*
*	fddiPATHClassConfigGrp	{fddiPATHClass 10}
*/
typedef	struct ClassConfigGrpStruct {
	uInt32		Trace_MaxExpiration;	/* value of Trace_Max */
	uInt32		TVXLowerBound;		/* lower bound of TVX */
	uInt32		T_MaxLowerBound;	/* lower bound of T_Max */
} ClassConfigGrpType;

/**********************************************************************
*	PATH Class PATH Group Types
**********************************************************************/

/*
*	fddiPATHClassPATHConfigGrp	{fddiPATHClassPATH 10}
*/
typedef	struct ClassPATHConfigGrpStruct {
	uInt16		Type;			/* which path */
	uInt16		PORTOrder;		/* ascending/descending */
	uInt32		RingLatency;		/* latency on this path */
	uInt16		TraceStatus;		/* current trace status */
	uInt32		Sba;			/* SBA for path */
	uInt16		SbaOverhead;		/* overhead for path */
	uInt16		Status;			/* wrapped/through */
	PathConfigType	Configuration;		/* path configuration */
	uInt32		T_Rmode;		/* restricted dialog limit */
} ClassPATHConfigGrpType;

/**********************************************************************
*	PORT Group Types
**********************************************************************/

/*
*	fddiPORTConfigGrp	{fddiPORT 10}
*/
typedef	struct PORTConfigGrpStruct {
	uChar		PC_Type;		/* type of PORT */
	uChar		PC_Neighbor;		/* type of neighbor PORT */
	uChar		ConnectionPolicies;	/* requested policies */
	uChar		RemoteMACIndicated;	/* 1 if True, 0 False */
	uChar		CE_State;		/* config element state */
	uChar		PathsRequested;		/* requested path for S/M */
	uInt16		MACPlacement;		/* MAC index of upstream MAC */
	uChar		AvailablePaths;		/* paths usable for S/M */
	uInt32		MACLoop_Time;		/* value of T_Next(9) */
	uChar		FotxClass;		/* optic xmitter class */
} PORTConfigGrpType;

/*
*	fddiPORTOperationGrp	{fddiPORT 30}
*/
typedef	struct PORTOperationGrpStruct {
	uChar		MaintLineState;		/* current maint LS */
	uInt32		TB_Max;			/* value of TB_Max */
	uChar		BS_Flag;		/* 1 True, 0 False */
} PORTOperationGrpType;

/*
*	fddiPORTErrorCtrsGrp	{fddiPORT 40}
*/
typedef	struct PORTErrorCtrsGrpStruct {
	uInt32		EBErr_Ct;		/* EB overflow count */
	uInt32		LCTFail_Ct;		/* # fails for LCT */
} PORTErrorCtrsGrpType;

/*
*	fddiPORTLerGrp	{fddiPORT 50}
*/
typedef	struct PORTLerGrpStruct {
	uChar		Ler_Estimate;		/* exponent of estimate */
	uInt32		Lem_Reject_Ct;		/* # times link rejected */
	uInt32		Lem_Ct;			/* # errors detected */
	uChar		BaseLer_Estimate;
	uInt32		BaseLem_Reject_Ct;
	uInt32		BaseLem_Ct;
	SMTTimeStamp	BaseLer_TimeStamp;
	uChar		Ler_Cutoff;		/* level for cutoff */
	uChar		Ler_Alarm;		/* level for alarm */
} PORTLerGrpType;

/*
*	fddiPORTStatusGrp	{fddiPORT 50}
*/
typedef	struct PORTStatusGrpStruct {
	uInt16		ConnectState;		/* current connect state */
	uChar		PCMState;		/* state of PCM */
	uChar		PC_Withhold;		/* withhold reason */
	uChar		LerCondition;		/* current condition state */
} PORTStatusGrpType;

/**********************************************************************
*	ATTACHMENT Group Types
**********************************************************************/

/*
*	fddiATTACHMENTConfigGrp	{fddiATTACHMENT 10}
*/
typedef	struct ATTACHMENTConfigGrpStruct {
	uInt16		Class;			/* dual, single, conc. */
	uChar		OpticalBypassPresent;	/* 1 True, 0 False */
	uInt32		I_MaxExpiration;	/* I_Max value */
	uChar		InsertedStatus;		/* 1 True, 0 False */
	uChar		InsertPolicy;		/* 1 insert, 0 don't insert */
} ATTACHMENTConfigGrpType;

/**********************************************************************
*	XDI Group Types
**********************************************************************/

/* 910122-005 LJP Removed unused OutIndex1 and OutIndex2 */
typedef	struct XDISMTGrpStruct {
	uChar		BothWrapCapability;
	uChar		BothWrapPolicy;
	uChar		Topology;
	uInt16		Port_Ct;
	uChar		SB_Flag;
} XDISMTGrpType;

typedef	struct XDIMACGrpStruct {
	uChar		RMTDupPolicy1;
	uChar		RMTDupPolicy2;
	uChar		NeighborChange;
	MACAddr48	DataAddress;
	uChar		Operational;
} XDIMACGrpType;

typedef	struct XDIPORTGrpStruct {
	uChar		Operational;
	uInt32		BaseEBError_Ct;
	uChar		EBErrorCondition;	/* 910412-001 LJP */
} XDIPORTGrpType;

/************************
 *    HLS Group Types
 ************************/
typedef struct HLSSMTGrpStruct {
	SMTStationIdType	
			RemoteDisconnectStationId;/* last station to set MIB */	
      } HLSSMTGrpType;

/**********************************************************************
*
*	MIB Structure Definition
*
**********************************************************************/

typedef	struct MIBStruct {
	/* SMT attributes - 1 per station */
	SMTStationIdGrpType		SMTStationIdGrp;
	SMTStationConfigGrpType		SMTStationConfigGrp;
	SMTStatusGrpType		SMTStatusGrp;
	SMTMIBOperationGrpType		SMTMIBOperationGrp;

	/* MAC attributes - 1 per MAC */
	MACCapabilitiesGrpType		MACCapabilitiesGrp[MAX_MAC_COUNT];
	MACConfigGrpType		MACConfigGrp[MAX_MAC_COUNT];
	MACAddressGrpType		MACAddressGrp[MAX_MAC_COUNT];
	MACOperationGrpType		MACOperationGrp[MAX_MAC_COUNT];
	MACCountersGrpType		MACCountersGrp[MAX_MAC_COUNT];
	MACErrorCtrsGrpType		MACErrorCtrsGrp[MAX_MAC_COUNT];
	MACFrameErrorConditionGrpType	
				MACFrameErrorConditionGrp[MAX_MAC_COUNT];
	MACNotCopiedConditionGrpType	MACNotCopiedConditionGrp[MAX_MAC_COUNT];
	MACStatusGrpType		MACStatusGrp[MAX_MAC_COUNT];
	MACRootMACStatusGrpType		MACRootMACStatusGrp[MAX_MAC_COUNT];

	/* PATH Class attributes - for all paths */
	ClassConfigGrpType		ClassConfigGrp;

	/* PATH Class PATH attributes - 1 per path */
	ClassPATHConfigGrpType		ClassPATHConfigGrp[MAX_PATH_COUNT];

	/* PORT attributes - 1 per port */
	PORTConfigGrpType		PORTConfigGrp[MAX_PORT_COUNT];
	PORTOperationGrpType		PORTOperationGrp[MAX_PORT_COUNT];
	PORTErrorCtrsGrpType		PORTErrorCtrsGrp[MAX_PORT_COUNT];
	PORTLerGrpType			PORTLerGrp[MAX_PORT_COUNT];
	PORTStatusGrpType		PORTStatusGrp[MAX_PORT_COUNT];

	/* ATTACHMENT attributes - (1 per S port or A/B port pair) 
		+ 1 per M port (use PORT count) */
	ATTACHMENTConfigGrpType		ATTACHMENTConfigGrp[MAX_PORT_COUNT];

	/* XDI attributes */
	XDISMTGrpType			XDISMTGrp;
	XDIMACGrpType			XDIMACGrp[MAX_MAC_COUNT];
	XDIPORTGrpType			XDIPORTGrp[MAX_PORT_COUNT];
	
	/* HLS attributes */
	HLSSMTGrpType                   HLSSMTGrp;

} MIBType;

#pragma align 16
#pragma pack  16

#endif /* __MIBTYPES_H */
