#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) mibinit.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/**********************************************************************
	Management Information Base Module

	MIB Initialization Processing.

	File:		mibinit.c
	Created:	12/01/89
	SMT Version:	6.2

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is responsible for initializing the Management
	Information Base (MIB).  The module initializes the MIB and
	calls implementor initialization routines to initialize
	the hardware associated with the MIB attributes. The implementor
	routines are responsible for providing the correct default
	values (they may be either defined in a header file or read
	from the station).

	Modification History:

	*** Updated to SMT 6.2 ***

	910301-002	LJP
		Converted Trace_MaxExpiration to FddiTimerTwosComplement
		format as stated in the standard.
	910315-005	LJP
		Added code to set first six bytes of Manufacturer Data
		field reserved for XDI use.
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"fddihdr.h"
#include	"smtmacro.h"
#include	"smterror.h"
#include	"mibdefs.h"
#include	"mibtypes.h"
#include	"mibglbl.h"


/*********************************************************************
*
*	External Routines
*
*********************************************************************/

extern	MIBType	*CreateMIB ();
extern	Flag	SetupMIB ();


/*********************************************************************
*
*	Initialization Routines
*
*********************************************************************/

uInt32
InitMIB ()
/*********************************************************************
Function:	This routine is called during start of day processing
		to fill in the default values in the Management Information
		Base (MIB).
			Because many values will vary from implementation to
		implementation, this initialization routine must be followed
		by an implementor supplied routine (called from the start
		of day processing after this routine runs).
Parameters:	None.
Input:		None.
Output:		Allocate MIB data base memory then sets MIB data base
		to default values for a SM-DAS.
Return:		0		if successful.
		EMIB_INIT_MIB	if MIB memory could not be allocated.
Modification History:
*********************************************************************/
{
Int16	i;

	/*
	*	Allocate space for MIB.
	*/
	mib = CreateMIB ();
	if (mib == NULL)
		return (EMIB_INIT_MIB);

	/*
	*	Get hardware/implementation dependent values.
	*/
	if (SetupMIB (mib))
		return (EMIB_INIT_MIB);

	/*
	*	Initialize fddiSMTStationIdGrp
	*/
	mib->SMTStationIdGrp.OpVersionId = SMTOPVERSION;
	mib->SMTStationIdGrp.HiVersionId = SMTHIVERSION;
	mib->SMTStationIdGrp.LoVersionId = SMTLOVERSION;

	/*
	*	910315-005	LJP
	*	Set first six bytes of Manufacturer Data field.
	*/
	MEMCOPY (mib->SMTStationIdGrp.ManufacturerData.data, 
		XDIMANUFDATA, 6);

	/*
	*	Initialize fddiSMTStationConfigGrp
	*/
	mib->SMTStationConfigGrp.StatusReporting = SET;

	/*
	*	Initialize fddiSMTStatusGrp
	*/
	mib->SMTStatusGrp.ECMState = EC_OUT;
	mib->SMTStatusGrp.CF_State = CE_ISOLATED;
	mib->SMTStatusGrp.HoldState = HS_Not_Holding;
	mib->SMTStatusGrp.RemoteDisconnectFlag = CLEAR;

	/*
	*	Initialize fddiSMTMIBOperationGrp
	*
	*	No initialization required since all values
	*	should start at 0. The allocated memory for
	*	the MIB has already been cleard to 0s.
	*/

	/*
	*	Initialize XDISMTGrp
	*/
	mib->XDISMTGrp.Topology = Topology_Thru;
	mib->XDISMTGrp.Port_Ct = mib->SMTStationConfigGrp.NonMaster_Ct
		+ mib->SMTStationConfigGrp.Master_Ct;
	mib->XDISMTGrp.SB_Flag = CLEAR;
		
	/*
	*	MAC Group Initialization (one per MAC)
	*/
	for (i = 0; i < mib->SMTStationConfigGrp.MAC_Ct; i++)
	{
		/*
		*	Initialize fddiMACCapabilitiesGrp
		*
		*	This group must be set by implementor.
		*/

		/*
		*	Initialize fddiMACConfigGrp
		*/
		mib->MACConfigGrp[i].CurrentPath = PA_UNKNOWN;
		MCopyAddress (mib->MACConfigGrp[i].UpstreamNbr,
			UNKNOWN_ADDRESS);
		MCopyAddress (mib->MACConfigGrp[i].DownstreamNbr,
			UNKNOWN_ADDRESS);
		MCopyAddress (mib->MACConfigGrp[i].OldUpstreamNbr,
			UNKNOWN_ADDRESS);
		MCopyAddress (mib->MACConfigGrp[i].OldDownstreamNbr,
			UNKNOWN_ADDRESS);
		mib->MACConfigGrp[i].RootConcentratorMAC = CLEAR;
		mib->MACConfigGrp[i].Dup_Addr_Test = CLEAR;
		/*
		* The following attribute uses PC_Type_Unknown even though the
		* standard does not define this value for this attribute
		* type.
		*/
		mib->MACConfigGrp[i].DownstreamPORTType 
			= PC_Type_Unknown;

		/*
		*	Initialize fddiMACAddressGrp
		*	Initialize fddiMACOperationGrp
		*
		*	These groups must be provided by the implementor.
		*/

		/*
		*	Initialize:
		*		fddiMACCountersGrp
		*		fddiMACErrorCtrsGrp
		*		fddiMACFrameErrorConditionGrp
		*		fddiMACNotCopiedConditionGrp
		*
		*	These groups are already initialized to 0s
		*	except for the threshold values which get set
		*	by the implementor.
		*/

		/*
		*	Initialize fddiMACStatusGrp
		*/
		mib->MACStatusGrp[i].RMTState = RM_ISOLATED;
		mib->MACStatusGrp[i].Da_Flag = CLEAR;
		mib->MACStatusGrp[i].UnaDa_Flag = CLEAR;
		mib->MACStatusGrp[i].FrameErrorCondition = CLEAR;
		mib->MACStatusGrp[i].NotCopiedCondition = CLEAR;
		mib->MACStatusGrp[i].LLCServiceAvailable = CLEAR;

		/*
		*	Initialize fddiMACRootMACStatusGrp
		*/
		mib->MACRootMACStatusGrp[i].MasterSlaveLoopStatus
			= MSLoop_Unknown;
		/*
		* The following attribute uses PC_Type_Unknown even though the
		* standard does not define this value for this attribute
		* type.
		*/
		mib->MACRootMACStatusGrp[i].RootMACDownStreamPORTType 
			= PC_Type_Unknown;
		mib->MACRootMACStatusGrp[i].RootMACCurrentPath
			= PA_UNKNOWN;

		/*
		*	Initialize XDIMACGrp
		*
		*	Done in interface.
		*/
	}

	/*
	*	Initialize fddiPATHClassConfigGrp
	*/
	/*
	*	910301-002	LJP
	*	Convert value to FddiTimerTwosComplement format.
	*/
	mib->ClassConfigGrp.Trace_MaxExpiration = 
		-MUsecs2Fddi (Trace_Max_Default);
		/* Remaining values set be implementor */

	/*
	*	PATH Class PATH Group Initialization
	*
	*	Since SMT 6.2 defines PATH Class PATH attributes for
	*	non-local paths only, the Primary path is assumed and
	*	filled in. If the Secondary path is available, it is 
	*	also set.
	*/

		/*
		*	Initialize fddiPATHClassPATHConfigGrp
		*
		*	The Configuration attribute must be calculated
		*	at the time of the request.
		*/
		mib->ClassPATHConfigGrp[PATH_P].TraceStatus 
			= Trace_NoCurrent;
		mib->ClassPATHConfigGrp[PATH_P].Status 
			= Path_Status_Thru;

		if (mib->SMTStationConfigGrp.PathsAvailable 
			& PA_SECONDARY)
		{
			mib->ClassPATHConfigGrp[PATH_S].TraceStatus 
				= Trace_NoCurrent;
			mib->ClassPATHConfigGrp[PATH_S].Status 
				= Path_Status_Thru;
		}

	/*
	*	PORT Group Initialization (one per PORT)
	*/
	for (i = 0; i < mib->XDISMTGrp.Port_Ct; i++)
	{
		/*
		*	Initialize fddiPORTConfigGrp
		*/
		mib->PORTConfigGrp[i].PC_Neighbor = PC_Type_Unknown;
		mib->PORTConfigGrp[i].RemoteMACIndicated = CLEAR;
		mib->PORTConfigGrp[i].CE_State = CE_ISOLATED;
		mib->PORTConfigGrp[i].MACPlacement = 0;

		/*
		*	Initialize fddiPORTOperationGrp
		*/
		mib->PORTOperationGrp[i].MaintLineState = Maint_QLS;
		/* convert to FddiTimerTwosComplement */
		mib->PORTOperationGrp[i].TB_Max =
			-MUsecs2Fddi (TB_Max_Default);
		mib->PORTOperationGrp[i].BS_Flag = CLEAR;

		/*
		*	Initialize fddiPORTErrorCtrsGrp
		*
		*	Cleared to 0 by MIB allocation.
		*/

		/*
		*	Initialize fddiPORTLerGrp
		*
		*	Ler_Cutoff and Ler_Alarm set by implementor.
		*	All other values cleared by MIB allocation.
		*/

		/*
		*	Initialize fddiPORTStatusGrp
		*/
		mib->PORTStatusGrp[i].ConnectState = Connect_Disabled;
		mib->PORTStatusGrp[i].PCMState = PC_OFF;
		mib->PORTStatusGrp[i].PC_Withhold = PC_WH_None;

		/*
		*	Initialize XDIPORTGrp
		*
		*	Done in interface.
		*/
	}

	/*
	*	ATTACHMENT Group Initialization (one per PORT or PORT pair)
	*
	*	The default initialization is for a dual attachment
	*	station. Therefore, a two-port pair is initialized and
	*	no master ports are set.
	*
	*	Class and OpticalBypassPresent set by implementor.
	*/
	for (i = 0; i < mib->XDISMTGrp.Port_Ct; i++)
	{
		/*
		*	Initialize fddiATTACHMENTConfigGrp
		*/
		/* convert to FddiTimerTwosComplement */
		mib->ATTACHMENTConfigGrp[i].I_MaxExpiration =
			-MUsecs2Fddi (I_Max_Default);
		mib->ATTACHMENTConfigGrp[i].InsertedStatus = CLEAR;
		mib->ATTACHMENTConfigGrp[i].InsertPolicy = CLEAR;
	}

	return (0);
}
