/*********************************************************************
 *  File  fddi_diag.c
 *
 *  Description
 *      All the entry points to test FDDI driver functions
 *
 *  Copyright (c) 1992, 1993 Hughes LAN Systems
 *  
 *  Programmer:   Jiawei Jang
 *  
 *  $Log:   /user/pvcs/fddicon/tester/fddi_diag.c_v  
 * 
 *    Rev 1.12   16 Jul 1993 09:57:02   gregs
 * Made phy range 1-2 for FDDI-eth bridge phy test.
 * 
 *    Rev 1.11   15 Jul 1993 16:51:50   jang
 * added 2 tests to test bsi performance
 * 
 *    Rev 1.10   10 Jun 1993 13:24:14   gregs
 * fix typos, misc changes for eth-fddi bridge.
 * 
 *    Rev 1.9   06 May 1993 09:39:56   gregs
 * Changes to tester menus for fddi-eth bridge.
 * 
 *    Rev 1.8   17 Apr 1993 13:53:32   jang
 * update bsi test menu
 * 
 *    Rev 1.7   06 Jan 1993 19:53:00   jang
 * put rev 1.5 back
 * 
 *    Rev 1.5   30 Dec 1992 12:00:12   jang
 * modified type error show_memu
 ********************************************************************/

#include <types.h>
#include <cmd.h>
#include <fddihdr.h>
#include <drv.h>


/*
 *-----------------------------------------------------------------
 *        Import variables
 *-----------------------------------------------------------------
 */
extern int port_list[];
extern int bsi_diag();
extern int bmac_diag();
extern int test_phy();


/*
 *-----------------------------------------------------------------
 *        Local variables
 *-----------------------------------------------------------------
 */
static char cmd_str[80]; /* hold the cmd string */ 
typedef struct _fddi_diag_tbl {
    int pt_name;      /* describing character */
    char *pt_desc;    /* printf string */
} FDDI_DIAG_TBL;

FDDI_DIAG_TBL player_tbl[] = {
  {'w',"wrap port"},
  {'i',"isolate port"},
  {'p',"insert to primary ring"},
  {'s',"insert to secondary ring"},
  {'d',"display all registers"},
  {'q',"tx quiet symbol"},
  {'h',"tx halt symbol"},
  {'m',"tx master symbol"},
  {'l',"tx idle symbol"},
  {'a',"tx active symbol"},
  {'n',"init all ports to default"},
  {'e',"exit from the phy test"},
  { 0 }
};

FDDI_DIAG_TBL bmac_tbl[] = {
  { 'b',"send beacon frame"},
  { 'c',"send claim frame"},
  { 'd',"display all registers"},
  { 'g',"set long group address"},
  { 'i',"initialize MAC(s) to default"},
  { 'l',"set long address"},
  { 's',"set short address"},
#ifdef __FEBRIDGE
#else
  { 't',"Line Confidence Test"},
#endif
  {'e',"exit from the mac test"},
  { 0 }
};

FDDI_DIAG_TBL bsi_tbl[] = {
  { 'a',"start performance test"},
  { 'b',"stop performance test"},
  { 'e',"exit from the bsi test"},
  { 'd',"display all the BSI registers"},
  { 'i',"send LLC and SMT test frames"},
  { 'm',"show all the descriptors ptop"},
  { 'n',"show all the descriptors lmop"},
  { 'o',"test SMT frame transfer"},
  { 'r',"test BSI LMOP operation"},
  { 's',"test BSI PTOP operation"},
  { 't',"test LLC frame transfer"},
  { 0 }
};

FDDI_DIAG_TBL monp_tbl[] = {  /* test application only */
  { 'i',"initialization"},
  { 0 }
};


/*
 *-----------------------------------------------------------------
 *        Function Prototypes
 *-----------------------------------------------------------------
 */
static void show_menu(FDDI_DIAG_TBL *);






/**********************************************************************
 *  Function    fddi_test_phys
 *
 *  Description
 *      This function is the entry point to test all the players.
 *
 *  Parameters:
 *      register PT *p
 *
 *  Return: [SUCCEED | FAIL]
 *********************************************************************/
int fddi_test_phys ()
{
    int  port_num, phy_num, act;

    /* get the first parameter - the port number */
#ifdef __FEBRIDGE
    printf("Enter port no. (1-2): ");
#else
    printf("Enter port no. (1-8. Backplane port b->7, backplane port a->8): ");
#endif
    gets(cmd_str);
    port_num = *cmd_str - '1';
#ifdef __FEBRIDGE
    if (port_num < 0 || port_num > 1) {
#else
    if (port_num < 0 || port_num > 7) {
#endif
      printf("illegal port number\n");
      return (FAIL);
    }
    phy_num = port_list[port_num];
    show_menu(player_tbl);
    printf("Please enter your choice:  ");
    /* get the secondary parameter */
    gets(cmd_str);
    switch (*cmd_str) {
          case 'w':
            act = 1;
	    break;
	  case 'i':
            act = 2;
	    break;
	  case 'p':
            act = 3;
	    break;
	  case 's':
            act = 4;
	    break;
	  case 'n':
            act = 5;
	    break;
	  case 'd':
            act = 6;
	    break;
	  case 'q':
            act = 7;
	    break;
	  case 'h':
            act = 8;
	    break;
	  case 'm':
            act = 9;
	    break;
	  case 'l':
            act = 10;
	    break;
	  case 'a':
            act = 11;
	    break;
	  case 'e':
	    act = 12;
	    break;
	  default:
	    printf("Unrecognized command\n");
	    return FAIL;
    }    /* switch */

    return (test_phy(phy_num,act));
}




/**********************************************************************
 *  Function    fddi_test_bmac
 *
 *  Description
 *      This function is the entry point to test all the bmacs
 *
 *  Parameters:
 *      register PT *p
 *
 *  Return: [SUCCEED | FAIL]
 *********************************************************************/
int fddi_test_bmac ()
{
    int  mac_num,i, act;

#ifdef __FEBRIDGE
    mac_num = 0;
#else
    for (i=0; i < 80; i++)
      cmd_str[i] = 0;

    /* get the first parameter - the bsi number */
    printf("Enter the mac number (MAC A->1; MAC B->0): ");
    gets(cmd_str);
    mac_num = *cmd_str - '0';
    if (mac_num != 0 && mac_num != 1) {
      printf("illegal mac number %d, %c\n",mac_num,*cmd_str);
      return (FAIL);
    }
#endif

    show_menu(bmac_tbl);
    for (i=0; i < 80; i++)
      cmd_str[i] = 0;
    printf("Please enter your choice:  ");
    /* get the secondary parameter */
    gets(cmd_str);
    act = (int)*cmd_str;

    return (bmac_diag(mac_num,act));
}


/**********************************************************************
 *  Function    fddi_test_bsi
 *
 *  Description
 *      This function is the entry point to test all the BSIs.
 *
 *  Parameters:
 *      register PT *p
 *
 *  Return: [SUCCEED | FAIL]
 *********************************************************************/
int fddi_test_bsi ()
{
    int  bsi_num,i, act;

#ifdef __FEBRIDGE
    bsi_num = 0;
#else
    for (i=0; i < 80; i++)
      cmd_str[i] = 0;

    /* get the first parameter - the bsi number */
    printf("Enter the bsi number (BSI A->1; BSI B->0): ");
    gets(cmd_str);
    bsi_num = *cmd_str - '0';
    if (bsi_num != 0 && bsi_num != 1) {
      printf("illegal mac number %d, %c\n",bsi_num,*cmd_str);
      return (FAIL);
    }
#endif
    show_menu(bsi_tbl);
    for (i=0; i < 80; i++)
      cmd_str[i] = 0;
    printf("Please enter your choice:  ");
    /* get the secondary parameter */
    gets(cmd_str);
    act = (int)*cmd_str;

    return (bsi_diag(bsi_num,act));
}




/************************************************************************
 *  Function  fddi_test_monp
 *
 *  Description
 *    This is the entry point of testing fddi application
 *
 *  Parameter:  none
 *
 *  Return:
 ***********************************************************************/
int fddi_test_monp ()
{
  int i, act;

  show_menu(monp_tbl);
  for (i=0; i < 80; i++)
    cmd_str[i] = 0;
  printf("Please enter your choice:  ");
  /* get the secondary parameter */
  gets(cmd_str);
  act = (int)*cmd_str;

  return(MONP_Diag(act));
}



/*
 *------------------------------------------------------------------------
 *        Local Functions
 *------------------------------------------------------------------------
 */

static void show_menu (tbl_ptr)
FDDI_DIAG_TBL *tbl_ptr;
{
    int i;
    register FDDI_DIAG_TBL *p;

    for (i=0, p = tbl_ptr; p->pt_name != NULL; p++) {
        printf(" %c) %33-s%s",p->pt_name,p->pt_desc, ++i & 1 ? "" : "\n");
    }
    if (i & 1)
        putchar('\n');
}

