
/**
 *	Program Name:	nim960 program
 *
 *	Filename:	dbdbuf.c
 *
 *	$Log:   /usr/shasta/pvcs/trc/util/dbdbuf.c_v  $
 * 
 *    Rev 1.11   01 Mar 1993 19:36:40   jang
 * return immediately if dbd in free_dbd() is wrong
 * 
 *    Rev 1.10   10 Feb 1993 13:22:06   holeman
 * switch Di Ei calles for crit_on and crit_off
 * 
 *    Rev 1.9   06 Feb 1993 12:08:48   jang
 * added one more parameter to init_dbd() to reserve 
 * some words in front of db_buffer
 * 
 *    Rev 1.8   29 Jan 1993 16:48:40   jang
 * modified the memory allocation in the init_dbd()
 * 
 *    Rev 1.7   07 Dec 1992 09:49:38   jang
 * changed DBD_BUF_ALIGN from 32 to 16 bytes alignment
 * 
 *    Rev 1.6   04 Dec 1992 18:58:48   jang
 * added code to alignment the dbd buffer for fddi
 * 
 *    Rev 1.5   03 Dec 1992 15:24:54   szewei
 * Increment and decrease dbd_count in free_dbd and get_dbd.
 * 
 *    Rev 1.4   25 Nov 1992 15:39:38   holeman
 * 
 *    Rev 1.3   20 Nov 1992 13:14:52   holeman
 * 
 *    Rev 1.2   13 Nov 1992 12:13:30   szewei
 * 
 *    Rev 1.1   27 Aug 1992 10:04:36   holeman
 * 
 *    Rev 1.0   01 Jul 1992 13:07:18   holeman
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <drv.h>
#include <mpd.h>
#ifdef __FDDI_CON
#include <fddi.h>
#endif

#ifdef notdef	/* everything, almost */

#ifdef __FDDI_CON
#define DBD_BUF_ALIGN    FDDI_BUF_ALIGN   /* 4k bytes boundary */
#else
#define DBD_BUF_ALIGN    1
#endif

extern	int fault_cnt;


MBOX f_FreeMbox;
DBD *f_dbd_start = 0;
int f_dbd_size   = 0;
int f_dbd_count  = 0;

int
f_init_dbd(buf_size, cnt, res_words)
int  buf_size;
int  cnt;
int res_words;    /* # of reserved words in front of db_buffer */
{
	int	i, res_cnt;
	DBD	*dbdp;
	byte	*bufp;
        int     *wp;
	
	/*
	* data buffer descriptors and data buffers are allocated as one chunk
	*/

	res_cnt = sizeof(int) * res_words;
#ifdef notdef		/* GJS */
	if (DBD_BUF_ALIGN <= 1)  /* no alignment requested */
	  f_dbd_start = (DBD *)shmalloc((sizeof(DBD) + (buf_size+res_cnt)) * cnt);
	else
	  f_dbd_start = (DBD *)shmalloc((sizeof(DBD) + (res_cnt+buf_size)) * (cnt+1));
	/* allocate from shared RAM */
	if (f_dbd_start == NULL)
		return(0);

#else
	f_dbd_start = (DBD *)0x50030000;		/* temporary zzz */
#endif
	f_dbd_size = buf_size + res_cnt;
	f_dbd_count += cnt;

	/*
	* data buffer descriptors or in the first part of the chunk
	* the data buffers are in the last part of the chunk
	*/
	dbdp = (DBD *)f_dbd_start;
	bufp = (byte *)f_dbd_start + sizeof(DBD) * cnt;
	bufp = (byte *)ALIGN(bufp,DBD_BUF_ALIGN);

	/*
	* create the mailbox where the free dbds are kept
	*/
	CreatMailbox(&f_FreeMbox);

	for (i = 0; i < cnt; i++, dbdp++, bufp += ALIGN(buf_size,DBD_BUF_ALIGN))
		{
		dbdp->db_idmark = DBD_MARK; 	/* buffer type */
		dbdp->db_nxtdbd = NULL;
		if (res_cnt != 0) {
		  wp = (int *)bufp;
		  *wp = (int) dbdp;  /* store dbdp in 1st word */
		}
		dbdp->db_buffer = bufp + res_cnt;		/* user's buffer addr */
		dbdp->db_bufsiz = buf_size;	/* set buffer length */
		dbdp->db_actcnt = 0;		/* no data in it yet */
		dbdp->db_indent = 0;		/* user's receive indent */
		dbdp->db_contrl = 0;
		dbdp->db_index  = i;		/* index for channel driver */
		SendMessage((MSGHDR *)dbdp, &f_FreeMbox);
		}

	return(1);
}

DBD *
f_get_dbd()
{
	DBD	*dbdp;
	long s;
#ifdef _FEBRIDGE
	ulong saveMask;
#endif

#ifdef _FEBRIDGE
	MaskAllInts(saveMask);
#else
	s = crit_on();
#endif
	if (dbdp = (DBD*)AcptMessage(&f_FreeMbox))	/* get a free buffer */
	{
		f_dbd_count--;
		dbdp->db_idmark = DBD_MARK; 	/* buffer type */
		dbdp->db_nxtdbd = NULL;		/*	     */
		dbdp->db_actcnt = 0;		/* no data in it yet */
		dbdp->db_snccnt = 0;            /* no xmit now */
		dbdp->db_indent = 0; 		/* no indenting */
		dbdp->db_rcvportno=0;		/* mark as chnl 1 */
		dbdp->db_xmtportlist=0;			
		dbdp->db_contrl = 1; 		/* one user */
	}
#ifdef _FEBRIDGE
	RestoreMask(saveMask);
#else
	crit_off(s);
#endif

	return dbdp;
}


void
f_free_dbd(dbdp) 
DBD	*dbdp;		/* DBD ptr */
{
	long s;

	s = crit_on();
	if ((dbdp->db_contrl == 0) || (dbdp->db_idmark != DBD_MARK))
	{
	    printf("warning error dbd %x\t", dbdp);
	    if (dbdp->db_contrl == 0) 
		printf("db_contrl is 0\n");
	    if (dbdp->db_idmark != DBD_MARK)
			printf("Bad dbd marker %x\n", dbdp->db_idmark);
	    crit_off(s);
		return;
	}

	--dbdp->db_contrl;
	if (dbdp->db_contrl == 0)          /* last user is done free it */
	{
		dbdp->db_nxtdbd = 0;	/* end of list has null fwp */
		f_dbd_count++;
		SendMessage((MSGHDR*)dbdp, &f_FreeMbox);		
	}
	crit_off(s);

	return;
}


#endif	/* everything */


swap_bits(byte *bp, int length)
{
	int i;
	byte temp;

	for (i =0; i < length; i++)
		{
		temp = 0;
		if (bp[i] & 0x01)
			temp |= 0x80;
		if (bp[i] & 0x02)
			temp |= 0x40;
		if (bp[i] & 0x04)
			temp |= 0x20;
		if (bp[i] & 0x08)
			temp |= 0x10;
		if (bp[i] & 0x10)
			temp |= 0x08;
		if (bp[i] & 0x20)
			temp |= 0x04;
		if (bp[i] & 0x40)
			temp |= 0x02;
		if (bp[i] & 0x80)
			temp |= 0x01;
		bp[i] = temp;
		}

	return;
}
#ifdef notdef
#define FDDI_HEADER_LEN         13  /* fddi header: 1 FC + 6 DA + 6 SA */
#define	OK				0
#endif

/********************************************************************
 *  Function  PutMacHeader
 *
 *  Description
 *    This function puts the FDDI mac header and LLC, SNAP header
 *    in front of the IP packet.
 *
 *  Parameters:
 *    DBD *dbd - point to the packet to send
 *    NID *np - dest addr
 *    int packet_type - IP or ARP
 *    byte *routing_info - not used
 *    int routing_length - not used.
 *
 *  Return: OK
 *******************************************************************/
PutMacHeader (dbd,np,packet_type,routing_info,routing_length)
DBD *dbd;
NID *np;
int packet_type; 
byte *routing_info; 
int routing_length;
{
  byte *bp;
  byte *header;
  int mac_num=0;
  byte da[6];

  /* point header to the FC field */
  header = dbd->nb_prot - FDDI_HEADER_LEN - sizeof(struct snap);
  dbd->db_indent = header - dbd->db_buffer;
  if (dbd->db_indent < 0) {
    if (get_debug() )
      printf("dbd->nb_prot needs to be adjusted, error\n");
    return(1);
  }

  dbd->db_actcnt += FDDI_HEADER_LEN + sizeof(struct snap);
#if 0
  if ((dbd->db_xmtportlist <= 2) &&  (dbd->db_xmtportlist > 0))
    mac_num = dbd->db_xmtportlist - 1;
#else
  mac_num = PortList2Num(dbd->db_xmtportlist);
  if (mac_num > 1) 
    mac_num = 0;
#endif

  /* now start to build the header */
  *header++ = 0x51;   /* FC: long addr */
  /* swap to FDDI order, ACR doesn't work. Since check out broadcast addr
     takes almost same amount of time, we simply go ahead to swap it */
#if 0
  ncopy(da,np);   /* np may directly point to ARP cache table */
#else
  memcpy(da,np,6);
#endif
  swap_bits(da,6);    
  ncopy(header,da);   /* DA */
  header += 6;
#if 0
  ncopy(header,(byte *)MyNid(mac_num + 1));  /* SA */
#else
  ncopy(header,(byte *)MyNid(mac_num));  /* SA */
#endif
  header += 6;

  /* set LLC fields: snap auth=DOD type */
  *header++ = IEEESNP0;
  *header++ = IEEESNP1;
  *header++ = IEEESNP2;
  *header++ = IEEEDOD0;
  *header++ = IEEEDOD1;
  *header++ = IEEEDOD2;
  bp = (byte *) &packet_type;
  *header++ = bp[0];  
  *header++ = bp[1];  

  return OK;
}
