/*******************************************************************************
 *  File    fddichnl.c
 *
 *  Description
 *    This module is based on the chnl.c in token ring code. It is the interface
 *    between mpd module and driver module
 *
 *  Copyright (c)  - 1993 Hughes LAN System
 *
 *  $Log:   /usr/shasta/pvcs/fddicon/util/fddichnl.c_v  
 * 
 *    Rev 1.41   23 Jul 1993 18:53:40   jlin
 * 
 *    Rev 1.40   23 Jul 1993 18:10:06   jlin
 * polling bmac RELR0
 * 
 *    Rev 1.39   15 Jul 1993 16:55:34   jang
 * changed BSI_poll() to the pointer to a function to test the performance
 * 
 *    Rev 1.38   13 Jul 1993 18:48:16   jlin
 * Fix the big in InitPortList() which didn't return TRUE when initialization 
 * is successful
 * 
 *    Rev 1.37   09 Jul 1993 11:41:50   jlin
 * Change the FDDI Disconnect function call inside the chnl_stop()
 * 
 *    Rev 1.36   08 Jul 1993 18:27:10   jang
 * added more debug info for DBD_CHNL_DEBUG
 * 
 *    Rev 1.35   18 Jun 1993 15:47:40   jang
 * 
 *    Rev 1.34   18 Jun 1993 14:42:42   jang
 * changed LLCActive to LLCActive[]
 * 
 *    Rev 1.33   17 Jun 1993 14:31:42   jang
 * check LLCActive
 * 
 *    Rev 1.33   17 Jun 1993 14:28:34   jang
 * added DBDFREE
 * 
 *    Rev 1.32   11 Jun 1993 13:38:12   jang
 * fixed type error
 * 
 *    Rev 1.31   10 Jun 1993 18:58:36   jang
 * added DRV_WairForChnlRdy() to chnl_init()
 * 
 *    Rev 1.30   08 Jun 1993 11:58:16   jang
 * deleted crit_on() & crit_off() from chnl_poll()
 * 
 *    Rev 1.29   07 Jun 1993 16:58:32   jang
 * changed chnl_poll()
 * 
 *    Rev 1.28   27 May 1993 15:08:16   fddiuser
 * 
 *    Rev 1.27   27 May 1993 15:00:56   jang
 * moved PortInitState out from if ()
 * 
 *    Rev 1.26   11 May 1993 10:45:56   jlin
 * Remove the LAN Chip Reset command out of chnl_stop()
 * 
 *    Rev 1.25   30 Apr 1993 11:55:04   jlin
 * Add DRV_Reset() in chnl_stop()
 * 
 *    Rev 1.24   28 Apr 1993 14:52:00   jang
 * changed the return code from chnl_transmit() so that the tcpip knows what happened.
 * 
 *    Rev 1.23   26 Apr 1993 10:25:36   jlin
 * Move DoConnect() to init_fddi since it should be called before the FDDI BRIP
 * in the boot code
 * 
 *    Rev 1.22   24 Apr 1993 14:01:50   jlin
 * disable interrupt in chnl_poll()
 * 
 *    Rev 1.21   24 Apr 1993 12:13:58   jlin
 * 
 *    Rev 1.20   17 Apr 1993 10:24:54   jlin
 * 
 *    Rev 1.19   16 Apr 1993 16:44:28   jang
 * moved MONP_InitPortState() to main/init.c
 * 
 *    Rev 1.18   15 Apr 1993 14:16:24   jang
 * took out the 2sec delay in chnl_init() and include monp.h to eliminate the
 * compiling warning message
 * 
 *    Rev 1.15   13 Apr 1993 13:44:26   jang
 * added code to handle port state during reset
 * 
 *    Rev 1.14   10 Apr 1993 11:51:04   jlin
 * 
 *    Rev 1.13   05 Apr 1993 09:14:42   jang
 * wait 2 msec after driver initialized and added MONP_BootINit()
 * 
 *    Rev 1.12   31 Mar 1993 18:47:58   jang
 * added debug info
 * 
 *    Rev 1.11   12 Mar 1993 12:04:46   jang
 * moved init_fdrmon() from init.c to chnl_init()
 * 
 *    Rev 1.10   05 Mar 1993 09:43:06   jang
 * added one parameter to chnl_init()
 * 
 *    Rev 1.9   02 Mar 1993 18:29:42   jang
 * added code to swap mac address during bootp
 * 
 *    Rev 1.8   01 Mar 1993 19:31:50   jang
 * removed init_dbd() from chnl_init()
 * 
 *    Rev 1.6   23 Feb 1993 09:34:00   jang
 * swap DA before sending out LLC frame due to BSI's ACR
 * doesn't work
 *******************************************************************************/


#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <led.h>
#include <memory.h>
#include <mpd.h>
#include <fddi.h>
#include <drv.h>
#include <bsi.h>
#include <dips.h>
#include <tcpip.h>
#include <monp.h>
#include <error.h>
#include <nodbd.h>
#include <smtmacro.h>


#define DBD_CHNL_DEBUG     0 /* used to debug when run out of DBDs */
#if DBD_CHNL_DEBUG
extern int drv_free_dbd_cnt;
#endif

#define PERFORMANCE_TEST         0
#if PERFORMANCE_TEST
static  byte *perf_ptr = (byte *)UNUSED_U107_PIN4;
#endif

#if LOSTPKT_DEBUG
extern int chnl_txpkt_cnt;
#endif

int *PortInitState;
extern int fault_cnt;

extern	MBOX	ReceiveMbox;


extern FDDI_CON_TYPE fddi_board;
extern BSI_TYPE bsi_dev[];
extern tcpip *_initp;
extern Flag SMTInitialized;
extern bool drv_init_flag, bsi_init_flag, bmac_init_flag, phy_init_flag;

word save_regs[16];
int (*pkt_proc_upcall)();
shrt chnl_flk_rx_led;
shrt chnl_flk_tx_led;

void PollPacket();

#define TR_RECEIVE_STACK_SIZE  4096
#define TR_TRANSMIT_STACK_SIZE 4096


/*
* variables needed for each media
*/
int NumberOfPorts;  /* including the SMT address */
int	media_state = 0;		/* not initialized */
long	MyGroup = 0;			/* no group */
long	MyFunction = 0xc000001a;	/* 0x10 = network manager */
					/* 0x08 = ring error monitor */
					/* 0x02 = ring parameter server */

/* 2 variables for converting port num to port list */
static byte *port_num2lst;
static byte *port_lst2num;



static bool InitPortList();
static int get_portStateFromNVRAM();



/***********************************************************************
 *  Function  PortNum2List
 *
 *  Description
 *    This function converts the port list in the ARP cache table to port
 *    number. The port number here means the MAC number. Currently this
 *    function is a dummy.
 *
 *  Parameter:
 *    port_num - the port list in the ARP cache table
 *
 *  Return: mac number where this frame should be transmitted.
 ************************************************************************/
unsigned PortNum2List(port_num)
unsigned int port_num;
{
#if 0
  return port_num;
#else
  return (port_num2lst[port_num]);
#endif
}

PortList2Num(list)
int list;
{
  return (port_lst2num[list]);
}


void snc_fpd_tmr()
{
}

/************************************************************************
 *  Function  chnl_config_bootp_mac
 *
 *  Description
 *    This function writes MAC 0 Nid to MAC 1 because in the server
 *    bootp table it expects MAC 0.
 *
 *  Parameter: none
 *
 *  Return: void
 ***********************************************************************/
void chnl_config_bootp_mac ()
{
#if 0
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[1].base_addr;

  bsi_dev[1].icr_val = r_ptr->icr;
  r_ptr->icr = 0xdb;
#endif
#if 0
  NID *addr;
  byte nid[6];
  
  addr = (NID *)MyNid(0);
  ncopy(nid,addr);
  swap_bits(nid,6);
  BMAC_SetLongAddr(1,(byte *)nid);
#endif
}

/************************************************************************
 *  Function  chnl_restore_bootp_mac
 *
 *  Description
 *    This function sets MAC to non promiscuous mode
 *
 *  Parameter: none
 *
 *  Return: void
 ***********************************************************************/
void chnl_restore_bootp_mac ()
{
#if 0
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[1].base_addr;

  r_ptr->icr = (byte )bsi_dev[1].icr_val;
#endif


#if 0
  NID *addr;
  byte nid[6];
  
  addr = (NID *)MyNid(1);
  ncopy(nid,addr);
  swap_bits(nid,6);
  BMAC_SetLongAddr(1,(byte *)nid);

  /* flush arp cache table to force sending out arp request */
  fls_arp_cache();
  BroadcastArpReply(_initp->in_me);
#endif
}

/************************************************************************
 *  Function  chnl_poll
 *
 *  Description
 *    This function polls each BSI's channel 2 for the receive frames for
 *    the monitor purpose. It is called each time slice.
 *
 *  Parameter:  none
 *
 *  Return: OK
 ***********************************************************************/
void chnl_poll()
{
  int bsi_num, tmp;
  extern void (*drv_polling)();

#if PERFORMANCE_TEST
  *perf_ptr = 0x50;
#endif
  krnl.krnl_slices++;  /* keep this from trc code */
  tmp = fault_cnt;
  fault_cnt = 1;
  if (drv_init_flag) {
    /* process any free tx dbd first */
    for (bsi_num=0; bsi_num < fddi_board.bsi_num; bsi_num++) {
      BMAC_PollRingOp(bsi_num);
      (*drv_polling)(bsi_num);
    }
  }  /* drv_init_flag */
  fault_cnt = tmp;
#if PERFORMANCE_TEST
  *perf_ptr = 0x51;
#endif
}

void snc_malloc()
{
}

/*************************************************************************
 *  Function chnl_free_dbd
 *
 *  Description:
 *    This function should be called by the protocol stack to free the
 *    rx dbd. If the BSI is configured as Frame Per Page mode, it only
 *    calles free_dbd(); Otherwise since one db_buffer may contains
 *    more than one pkt, special process need to be done.
 *
 *  Parameter
 *
 *  Return:
 ************************************************************************/
void chnl_free_dbd(DBD *dbd)
{
  if (dbd->db_contrl == 0)  {	
    if (get_debug()) {
      printf("chnl_free_dbd() db_contrl = 0, %x\n",dbd);
/*    asm("fmark"); */
      return;
    }
  }
#if DBD_CHNL_DEBUG
  else
    drv_free_dbd_cnt++;
#endif
  free_dbd(dbd);
}

word
chnl_init(source)
int source;   /* 0 from booter, 1 from application */
{
  if (media_state)
    return(TRUE);
		
  media_state = 1;

  drv_init_flag = bsi_init_flag = bmac_init_flag = phy_init_flag = FALSE;
#if DBD_CHNL_DEBUG
  drv_free_dbd_cnt = 0;
#endif

  if (InitPortList() == FALSE)
    return FALSE;

  init_fdrmon();    /* has to be done before chnl_init() */
  MONP_InitBoot();

  chnl_receive_mail_box(&ReceiveMbox);
  get_portStateFromNVRAM();

  if (!init_fddi(source))
    return FALSE;

  DRV_WaitForChnlRdy();

  return TRUE;
}

/*
* Initialize the network drivers
*/
void chnl_install(int (*UpCall)(), int PromiscuousMode)
{
#if 0
	int	PortFailed = 0;

	Di();

	if ((chnl_cam_add(0, MyNid(0)) != 0) ||
	    (chnl_cam_add(0, BROADCAST) != 0))
		PortFailed++;

	pkt_proc_upcall = UpCall;
	Ei();
	/*
	 *	Return ok if port is working.
	 */
	return PortFailed;
#endif
}

void chnl_config(word portnum,word rcvmode,word start_addr,word io_addr)
{
}

void chnl_set_upcall( int (*upcall) ())
{
}

void chnl_test(word portnum, word test_mode, word xmts, int (*test_upcall)(), word start_addr, word io_addr)
{
}

char *chnl_receive(word portnum)
{
	return NULL;
}


/********************************************************************
 *  Function chnl_start
 *
 *  Description
 *
 *  Parameters:
 *
 *  Return:
 *******************************************************************/
void chnl_start(word portnum)
{
#if 0
  /* FDDI */
  /* May be the LAN Chip Reset should be done here */
	byte *ioport;

	ioport = (byte*)TMS_RESET;
	*ioport = 1;

	return;
#endif
}

void chnl_stop(word portnum)
{

extern int hw_reset_flag;


  InitLed();

  if (SMTInitialized)
  {
     DRV_Reset();

     if (hw_reset_flag)
     {
        SignalDoDisconnect(); /* jlin: DisConnect all of the ports on primary 
				 and secondary rings by sending message
				 through Timer Mailbox since this function
				 can be called in ISR */
	BypassRequest(DEINSERTED);
     }
     else
     {
        DoDisconnect(); /* DisConnect all of the ports on primary 
			   and secondary rings */
     }
  }
}

chnl_cam_add(word portnum, NID *address)
{
	return 0;
}

chnl_clear()
{
	return 0;
}

/*
* Packet processing for the KERNEL.
* This function will be called by the tms380 driver whenever
* there is at least a packet received.
*/
void
PollPacket()
{
#if 0
	if (!media_state)
		return;

	ClearPortLedStatus();

	return;
#endif
}


/***************************************************************************
 *
 *  Name:	chnl_transmit
 *
 *  Function:	Transmit frame.
 *
 *  Algorithm:	Caller provides entire frame. include mac header.
 *              ip_send() will send the same frame to all the possible
 *              ports and then frees the dbd. Therefore we have to 
 *              increase the dbd user count because driver will also
 *              free dbd.
 *
 *  Parameters:
 *    DBD *dbd - point to the rx frame
 *    word freeit - dummy. token ring uses it to decide whether or
 *                  not the driver should free dbd
 *
 *  Returns:
 *
 *  History:
 *
 ****************************************************************************/

word chnl_transmit(DBD *dbd, word freeit)
{
  int port;
  word result;
  port = PortList2Num(dbd->db_xmtportlist);

  /* only 1 & 2 are legal values. We have only 2 MACs */
  if (port > 1)
    return INV_PORT;

  if (!LLCActive[port])   /* if llc is disable, don't send anything */
    return 0;

  if (freeit)
    dbd->db_contrl |= DBDFREE;

#if LOSTPKT_DEBUG
  chnl_txpkt_cnt++;
#endif
  result = DRV_SendFrame(dbd,port,DRV_REQ_RQCLS_ASYN);
#if DBD_CHNL_DEBUG
  if (result)
	printf("retn DRV_SendFrame() %x\n",result);
#endif

   return (result);		
}


/***************************************************************************
 *
 *  Name:	init_tms_data_buffers
 *
 *  Function:	allocate the transmit and receive data buffers
 *		initialize the structures which point to the buffers
 *
 *  Algorithm:	get system memory
 *
 *  Parameters: rdb_count = number of receive data buffers to allocate
 *
 *  Returns:	TRUE  = success
 *		FALSE = failure - not enough memory
 *
 *  History:
 *
 ****************************************************************************/

#if 0
init_tms_data_buffers(word rdb_count)
{
	int ii;
	byte *tdb;
	DBD *dbd;
	u_short *us;
	byte *bp;

	/*
	* link the transmit lists in a chain
	*/
	for (ii = 0; ii < NUM_XBUF; ii++)
		{
		bp = (byte *)&xl[ii+1];
		us = (u_short *)&bp;
		xl[ii].fwd.wrd[0] = us[1];
		xl[ii].fwd.wrd[1] = us[0];
		xl[ii].cstat   = XMT_SOF;	/* set start of frame */
		xl[ii].next_xl  = &xl[ii+1];
		xl[ii].in_use  = 0;
		xl[ii].dbd  = 0;
		swab((unsigned short *)&xl[ii], 3);
		}

	bp = (byte *)&xl[0];
	us = (u_short *)&bp;
	xl[NUM_XBUF-1].fwd.wrd[0] = us[1];
	xl[NUM_XBUF-1].fwd.wrd[1] = us[0];
	xl[NUM_XBUF-1].next_xl    = &xl[0];
	swab((unsigned short *)&xl[NUM_XBUF-1], 2);

	cur_xlp  = NULL;	/* no current xmit list */
	free_xlp = xl;		/* first free xmit command list */

	/*
	* initialize the circular receive list chain
	*/
	for (ii = 0; ii < NUM_RL; ii++)
		{
		/*
		* link all of the receive lists in a chain
		*/
		bp = (byte *)&rl[ii+1];
		us = (u_short *)&bp;
		rl[ii].fwd.wrd[0] = us[1];
		rl[ii].fwd.wrd[1] = us[0];
		swab((unsigned short *)&rl[ii], 2);
		rl[ii].next_rl  = &rl[ii+1];
		rl[ii].cstat = 0;	/* make sure VALID bit is off */
		rl[ii].dbd = 0;
		}

	bp = (byte *)&rl[0];
	us = (u_short *)&bp;
	rl[NUM_RL-1].fwd.wrd[0] = us[1];
	rl[NUM_RL-1].fwd.wrd[1] = us[0];
	rl[NUM_RL-1].next_rl    = &rl[0];
	swab((unsigned short *)&rl[NUM_RL-1], 2);

	/*
	* now setup the valid receive lists
	*/
	available_receive_buffers = 0;
	for (ii = 0; ii < rdb_count; ii++)
		{
		dbd = get_dbd();
		if (dbd == NULL)
			{
			printf("Abort: not enough receive data buffers\n");
			return(FALSE);
			}

		rl[ii].dbd   = dbd;		/* link to receive descriptor */
		available_receive_buffers++;

		us = (u_short *)&dbd->db_buffer;
		rl[ii].addr1[0] = us[1];
		rl[ii].addr1[1] = us[0];
		rl[ii].len   = 0;
		rl[ii].cnt1  = dbd->db_bufsiz;
		swab((unsigned short *)&rl[ii].len, 4);

		rl[ii].cstat = RVLD_SWP | RCV_INTREQ_SWP;
		}

	free_rlp = &rl[rdb_count];	/* this will be first free one */
	cur_rlp  = &rl[0];		/* this will be current receive list */
					/* pointer */

	return(TRUE);
}
#endif

MyHtype()
{
	return(6);
}


/********************************************************************
 *  Function  PutMacHeader
 *
 *  Description
 *    This function puts the FDDI mac header and LLC, SNAP header
 *    in front of the IP packet.
 *
 *  Parameters:
 *    DBD *dbd - point to the packet to send
 *    NID *np - dest addr
 *    int packet_type - IP or ARP
 *    byte *routing_info - not used
 *    int routing_length - not used.
 *
 *  Return: OK
 *******************************************************************/
PutMacHeader (dbd,np,packet_type,routing_info,routing_length)
DBD *dbd;
NID *np;
int packet_type; 
byte *routing_info; 
int routing_length;
{
  byte *bp;
  byte *header;
  int mac_num=0;
  byte da[6];

  /* point header to the FC field */
  header = dbd->nb_prot - FDDI_HEADER_LEN - sizeof(struct snap);
  dbd->db_indent = header - dbd->db_buffer;
  if (dbd->db_indent < 0) {
    if (get_debug() == DEBUG_ON)
      printf("dbd->nb_prot needs to be adjusted, error\n");
    return(1);
  }

  dbd->db_actcnt += FDDI_HEADER_LEN + sizeof(struct snap);
#if 0
  if ((dbd->db_xmtportlist <= 2) &&  (dbd->db_xmtportlist > 0))
    mac_num = dbd->db_xmtportlist - 1;
#else
  mac_num = PortList2Num(dbd->db_xmtportlist);
  if (mac_num > 1) 
    mac_num = 0;
#endif

  /* now start to build the header */
  *header++ = 0x51;   /* FC: long addr */
  /* swap to FDDI order, ACR doesn't work. Since check out broadcast addr
     takes almost same amount of time, we simply go ahead to swap it */
#if 0
  ncopy(da,np);   /* np may directly point to ARP cache table */
#else
  memcpy(da,np,6);
#endif
  swap_bits(da,6);    
  ncopy(header,da);   /* DA */
  header += 6;
#if 0
  ncopy(header,(byte *)MyNid(mac_num + 1));  /* SA */
#else
  ncopy(header,(byte *)MyNid(mac_num));  /* SA */
#endif
  header += 6;

  /* set LLC fields: snap auth=DOD type */
  *header++ = IEEESNP0;
  *header++ = IEEESNP1;
  *header++ = IEEESNP2;
  *header++ = IEEEDOD0;
  *header++ = IEEEDOD1;
  *header++ = IEEEDOD2;
  bp = (byte *) &packet_type;
  *header++ = bp[0];  
  *header++ = bp[1];  

  return OK;
}

void IsPacketForMe(DBD *d)
{
#if 0
	LANHDR *header;

	header = (LANHDR *) d->db_buffer;

	return IsMyNid(header->frm_dst);
#endif
}

void test_tms380()
{
#if 0
	int speed;

	/*
	* enable the TMS380
	*/
	chnl_start(0);

	/*
	* set up the speed the token ring will operate at
	*/
	speed = get_token_ring_speed() ? 0 : 1;
	*(byte *)TRSPEED = speed;
	printf("Token ring speed = %d megabit\n", speed ? 4 : 16);

	/*
	* stop tms380, download firmware, and start BUD
	*/
	if (tms_load_and_start())
		{
		/*
		* download of firmware failed compare test
		*/
		return(1);
		}
	printf("TMS380 start completed\n");

	if (tms_init())
		{
		/*
		* TMS380 initialization failed.
		*/
			return(1);
		}
		printf("TMS380 initialization completed\n");


	return 0;
#endif
}

void chnl_receive_mail_box(MBOX *mail_box)
{

/*	receive_mail_box = mail_box; */

	return;
}

void chnl_copy_all_frames()
{
#if 0
	return(tr_modify_open_parameters(0x7));
#endif
}

/***************************************************************************
 *  Function  InitPortList
 *
 *  Description:
 *    This function initializez 2 static table used to convert between
 *    port/mac number and port list (bit map
 *    port_list2num[8] = 0, 0, 1, 0, 2, 0, 0, 0
 *    port_num2lst[3] = 1, 2, 4
 *
 *  Parameter:  none
 *
 *  Return: [TRUE | FALSE]
 ***************************************************************************/
static bool InitPortList ()
{
  int max_ports, i;

  if ((port_num2lst = (byte *)lmalloc(sizeof(byte) * NumberOfPorts)) == NULL) {
    if (get_debug() == DEBUG_ON)
      printf("Error: no memory for num2list table\n");
    return FALSE;
  }
  max_ports = 1 << NumberOfPorts;
  if ((port_lst2num = (byte *)lmalloc(sizeof(byte) * max_ports)) == NULL) {
    if (get_debug() == DEBUG_ON)
      printf("Error: no memory for num2list table\n");
    return FALSE;
  }
  for (i=0; i < max_ports; i++)
    port_lst2num[i] = 0;
  for (i=0; i < NumberOfPorts; i++)  {
    port_num2lst[i] = 1 << i;
    port_lst2num[1 << i] = i;
  }
  return TRUE; /* jlin: 07/13/93 */
}

#include <nvrfddi.h>

static int get_portStateFromNVRAM ()
{
  int err;

    PortInitState = nvr_port_init.port_state;
  if ((err = Nvram_Load(NVR_PORT_INIT_ADDR,&nvr_port_init,NVR_PORT_INIT_SIZE)) != NVRAM_AOK) {
    memset(&nvr_port_init,0,NVR_PORT_INIT_SIZE);
    if ((err=Nvram_Updt(NVR_PORT_INIT_ADDR,&nvr_port_init,NVR_PORT_INIT_SIZE)) != NVRAM_AOK) {
      if (get_debug() == DEBUG_ON)
	printf("Error: can't write default value to port init record in NVRAM\n");

      return (err);
    }

  }

  return err;
}
