
#include <types.h>
#include <memory.h>
#include <led.h>
#include "fddi.h"
#include "fddiled.h"
#include "phy.h"
#include <dips.h>
#ifdef notdef		/* GJS */
#include <uart.h>
#include <nvrecs.h>
#endif				/* GJS */
#include <eeprecs.h>
#include <sys.h>
#include "smtdefs.h"
#include "cspmacro.h"

static byte seven_segment[] =
	{
	0x03,			/* 0 */
	0x9f,			/* 1 */
	0x25,			/* 2 */
	0x0d,			/* 3 */
	0x99,			/* 4 */
	0x49,			/* 5 */
	0x41,			/* 6 */
	0x1f,			/* 7 */
	0x01,			/* 8 */
	0x09,			/* 9 */
	0x11,			/* a */
	0xc1,			/* b */
	0x63,			/* c */
	0x85,			/* d */
	0x61,			/* e */
	0x71,			/* f */
	0x00,			/* all segments on */
	0xff			/* all segments off */
	};
#define SEGMENTS_ON  0x10
#define SEGMENTS_OFF 0x11
#define WRAP_BLINK_COUNT 50

/*************************************************************
 *
 */

uChar LedStatus[LED_REG_NO] = {0xff, 0xff, 0xff };
uChar LedStatusSaved[LED_REG_NO];
#ifdef notdef		/* GJS */
volatile uChar *LedPort[LED_REG_NO]  = { (volatile uChar*) LED_REG1, 
			       (volatile uChar*) (LED_REG1+0x80), 
			       (volatile uChar*) (LED_REG1+0x100) };
#endif				/* GJS */
uChar Power2[8] = { 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 };
volatile PHY_REG_TYPE *PhyReg[MAX_PORT_COUNT];
volatile struct SCCport *sccPort;
uChar PortMap[MAX_PORT_COUNT] = { 1, 5, 4, 3, 2, 0 };
uChar Port2LedMap[MAX_PORT_COUNT] = { 1, 6, 2, 3, 4, 5 };
uChar testStr[80] = "\nThis is FDDI concentrator...\n";
static uChar oldnum;
static Int32 BlinkCount[2];

extern int fault_cnt;
extern uChar UartCmdData[];
extern uInt32 PortWrap[];
extern uChar  TimeStampEnable;


InitLed()
{
#ifdef notdef		/* GJS */
   int i;

   TimeStampEnable = FALSE;
   PortWrap[PHY_A] = PortWrap[PHY_B] = FALSE;
   BlinkCount[PHY_A] = BlinkCount[PHY_B] = 0;

   for (i=0; i < LED_REG_NO; i++)
   {
       *LedPort[i] = LedStatusSaved[i] = LedStatus[i] = 0xff;
   }
#endif				/* GJS */

}

void WaitLoop(delay)
uInt32 delay;
{
   for (; delay--;)
   {
   }
}

void SaveLEDStatus()
{
#ifdef notdef		/* GJS */
   int i;
   for (i=0; i < LED_REG_NO; i++)
   {
      LedStatusSaved[i] = LedStatus[i];
   }
#endif				/* GJS */
}

void RestoreLEDStatus()
{
#ifdef notdef		/* GJS */
   int i;
   for (i=0; i < LED_REG_NO; i++)
   {
      *LedPort[i] = LedStatus[i] = LedStatusSaved[i];
   }
#endif				/* GJS */
}

void InitPhy()
{
   int i;
   volatile uChar *ioport, temp;


   ioport = (volatile uChar*) FDDI_LANRST_REG;
   *ioport = (volatile uChar) 0x00;          /* Reset FDDI Chip Set */
   *ioport = (volatile uChar) 0xff;          /* Reset FDDI Chip Set */

   for (i=0; i < MAX_PORT_COUNT; i++)
   {
      PhyReg[i] = (volatile PHY_REG_TYPE*) (0xb0000000 + i * 0x20);
      while ((PhyReg[i]->mr & PHY_MR_RUN));
      PhyReg[i]->icmr = (volatile uChar) 0;
      PhyReg[i]->rcmra = (volatile uChar) 0;
      PhyReg[i]->rcmrb = (volatile uChar) 0;
      PhyReg[i]->icr = (volatile uChar) 0;
      PhyReg[i]->cr = (volatile uChar) 
	              (  PHY_CR_AIND_AREQ
		      | PHY_CR_BIND_BREQ 
		      | PHY_CR_TRS_RBUS );
   }

   for (i=0; i < MAX_PORT_COUNT; i++)
   {
      temp = PhyReg[i]->ctsr;
      PhyReg[i]->ctsr = (volatile uChar) (PHY_CTSR_MTM);  /* master ls */
      PhyReg[i]->mr = (volatile uChar) (PHY_MR_RUN | PHY_MR_TE);
      while (((volatile char) PhyReg[i]->mr & (uChar) PHY_MR_RUN)==0);
   }
}

RefreshLED()
{
#ifdef notdef		/* GJS */
   int i;

   for (i=0; i < LED_REG_NO; i++)
   {
      *LedPort[i] = LedStatus[i];
   } 
#endif				/* GJS */
}


SetPortLed(port, led, state)
int port;
unsigned int led;
short state;
{
#ifdef notdef		/* GJS */
   ProcState pState;
   uChar portPos, bitPos, mask;
   uInt16 pos;

   if (--port < 0)
   {
      port = 0;
   }
   else if (port >= MAX_PORT_COUNT)
   {
      port = MAX_PORT_COUNT - 1;
   }


   if (led & LED_ACTIVE_READY)
   {
      portPos = (port + 4) / 8;
      bitPos  = (portPos)? ((port-4) % 8) : port;
      MDisableCSPInterrupts(&pState);
      if (state == LED_TURN_OFF)
      {
         LedStatus[portPos] |= Power2[bitPos];
      }
      else
      {
         LedStatus[portPos] &= ~Power2[bitPos];
      }
      MRestoreCSPInterrupts(&pState);
      *LedPort[portPos] = (volatile uChar) LedStatus[portPos];
   }

   if (led & LED_SET1)
   {
      pos = port * 2 + MAX_PORT_COUNT + 4 + ((port)? 1 : 0);
      portPos = pos / 8;
      bitPos  = pos % 8;
      if ((port) && (port < (MAX_PORT_COUNT-1)))
      {
	 mask = led &                       /* If it's a M port */
	        (LED_PRIMARY_SECONDARY | LED_LINK_ERROR);
      }
      else
      {        /* if it's a A or B port */
         mask = led & LED_PRIMARY_SECONDARY;
         mask |= (led & LED_PEER_TREE) ? LED_LINK_ERROR : 0;
         mask |= (led & LED_LINK_ERROR) ? LED_PEER_TREE : 0;
      }

      MDisableCSPInterrupts(&pState);
      if (state == LED_TURN_OFF)
      {
         LedStatus[portPos] |= (mask << bitPos);
         mask >>= (8-bitPos);
         if (mask)
	 {
            LedStatus[portPos+1] |= mask;
	 }
      }
      else
      {
         LedStatus[portPos] &= ~(mask << bitPos);
         mask >>= (8-bitPos);
         if (mask)
	 {
            LedStatus[portPos+1] &= ~mask;
	 }
      }
      MRestoreCSPInterrupts(&pState);

      *LedPort[portPos] = (volatile uChar) LedStatus[portPos];
      if (mask)
      {
         *LedPort[portPos+1] = (volatile uChar) LedStatus[portPos+1];
      }
   }
#endif				/* GJS */
}


set_port_led(word port_number, word port_color)
{
#ifdef notdef		/* GJS */
   unsigned int led;

   if (port_color == LED_OFF)
   {
       SetPortLed(port_number+1, LED_ALL, LED_TURN_OFF);
       return;
   }

   if (port_color & LED_RED)
   {
      led = LED_LINK_ERROR;
   }
   else
   {
      led = 0;
   }

   if (port_color & LED_GREEN)
   {
      led |= (led_test_active)? (LED_PRIMARY_SECONDARY | LED_PEER_TREE | 
			         LED_ACTIVE_READY)
	                      : LED_ACTIVE_READY;
   }

   SetPortLed(port_number+1, led, LED_TURN_ON);
   return;
#endif				/* GJS */
}


static uChar SCCInitCmd[] = { 0,  9, 0x40, 3,  0xc0,  4, 0x44, 5, 0x60,
			         11, 0x56, 12, 0x18, 13, 0x0, 14, 0x03,
				 3, 0xc1, 5, 0xea };
void InitUART()
{
#ifdef notdef		/* GJS */
   volatile uChar *ioport, status, *uartCmd;
   uChar num, i;

/*
   ioport = (uChar*) 0x80000060;
   num = *ioport;

   if (oldnum == num)   
   {
      return;
   }

   oldnum = 0;

   if (num)
   {
      sccPort = SCC_PORTA;
   }
   else
   {
      sccPort = SCC_PORTB;
   }
*/

   uartCmd = (volatile uChar*) 0xc0000000;
   sccPort = (volatile struct SCCport*) SCC_PORTB;
/*
   for (i=1; i < 23; i+=2)
   {
      uartCmd[UartCmdData[i]] = UartCmdData[i+1];
   }

   SCCreset(sccPort);
   eat_time(80);

   sccPort->control = UartCmdData[0];
   wait_uart();

   for (i=1; i < 23; i+=2)
   {
      sccPort->control = UartCmdData[i];
      wait_uart();
      sccPort->control = UartCmdData[i+1];
      wait_uart();
   }
   
*/
   sccPort = (volatile struct SCCport*) SCC_PORTB;
   SCCinit(sccPort, 9600);

   SCCbaud(sccPort, 9600);
   SCCparity_stop_bits(sccPort, PARITY_NONE, 1);
   SCCdata_length(sccPort, CHAR_SIZE_8);
/*
         sccPort->control = 0x0c;
         wait_uart();
         sccPort->control = 0x18;
         wait_uart();
         sccPort->control = 0x0d;
         wait_uart();
         sccPort->control = 0;
         wait_uart();
*/
#endif				/* GJS */
}

void flicking_leds()
{
   static   unsigned int mask=17, i;
   volatile uChar *ioport, status;

      mask = (((mask+13)*11) % 0x000000ff) ^ 0x0ff;

      for (i=0; i < MAX_PORT_COUNT; i++)
      {
         if (1 || ((PhyReg[PortMap[i]]->crsr & PHY_CRSR_LS_MASK) 
	      == PHY_CRSR_MLS))
	 {
            SetPortLed((i+1), LED_ACTIVE_READY, 
		       (Power2[i % 8] & mask)? 
		                        LED_TURN_ON : LED_TURN_OFF);
	 }
         else
	 {
            SetPortLed((i+1), LED_ACTIVE_READY, LED_TURN_OFF);
         }
      }

      ioport = (uChar*) LEDIO;
      *ioport = (volatile uChar) (status ^ (mask & 0x0a));

}


void flicking()
{
#ifdef notdef		/* GJS */
   unsigned int mask, si;
   int i, delay;
   volatile uChar *ioport, status;
   uChar num, ch;

   RefreshLED();
   InitPhy();

   mask=17;
   fault_cnt = 1;
   ioport = (uChar*) SEVEN_SEGMENT;
   *ioport = (volatile uChar) seven_segment[0];
   oldnum = *ioport ^ 0xff;
   ioport = (uChar*) LEDIO;
   *ioport = (volatile uChar) 0x0a;
   status = 0x0a;
   InitUART();
   
   for (si=0, delay=LOOP_DELAY;;)
   {
      flicking_leds();
      sccPort->control = 0;
      wait_uart();
      num = sccPort->control;
      wait_uart();
      
      if (num & 0x01)
      {
         ch = sccPort->data;
         wait_uart();
         SCCput(sccPort, ch);
      }
/*
      else
      {
	 SCCput(sccPort, num / 100 + '0');
	 SCCput(sccPort, ( num % 100) / 10 + '0');
	 SCCput(sccPort, num % 10 + '0');
	 SCCput(sccPort, ' ');
	 SCCput(sccPort, ' ');
	 SCCput(sccPort, ' ');
      }
*/

      if (!--delay)
      {
         ioport = (volatile uChar*) SEVEN_SEGMENT;
         *ioport = (volatile uChar) seven_segment[++si & 0x0f];
         delay = LOOP_DELAY;

         ioport = (uChar*) 0x80000070;
/*
         sccPort->control = 0x0c;
         wait_uart();
         sccPort->control = *ioport;
         wait_uart();
         sccPort->control = 0x0d;
         wait_uart();
         sccPort->control = 0;
         wait_uart();
         WaitLoop(1000);

	 SCCput(sccPort, 0x55);

         for (i=0; testStr[i]; i++)
	 {
	    SCCput(sccPort, testStr[i]);
	 }
	 SCCput(sccPort, 0x0a);
	 SCCput(sccPort, 0x0d);
*/
      }
      WaitLoop(30000);
   }

#endif		/* GJS */
}


BlinkFDDILed()
{
#ifdef notdef		/* GJS */
   uInt32 i;

   for (i=PHY_A; i <= PHY_B; i++)
   {
      if (!PortWrap[i])
      {
         continue;
      }

      if (!BlinkCount[i]--)
      {
         BlinkCount[i] = WRAP_BLINK_COUNT;
	 SetPortLed(Port2LedMap[i], LED_PRIMARY_SECONDARY, LED_TURN_ON);
      }
      else if (BlinkCount[i] == (WRAP_BLINK_COUNT/2))
      {
	 SetPortLed(Port2LedMap[i], LED_PRIMARY_SECONDARY, LED_TURN_OFF);
      }
   }
#endif				/* GJS */
}
