#include "msgutil.h"
#include "smtmacro.h"
#include "fbmframe.h"

/* MACROS */
/*
 *   Disable interrupt when access mailbox
 */
#define CreateIntMsg(msg,mailboxptr) CreatMessage (msg);\
                                     SendMessage( msg, mailboxptr );

#define SendIntMsg(msg,mailboxptr) SendMessage( msg, mailboxptr );

#define ReceiveIntMsg(msg, mailboxptr)  msg = (GenericMsgType *) AcptMessage (mailboxptr); 

extern void *lmalloc();
extern void free();

MemFreeListDescriptor FDDIMsgHdrDescr = { sizeof(GenericMsgType), 
					  INIT_FREE_FDDI_MSGHDR_CT,
					  MORE_FREE_FDDI_MSGHDR_CT,
					  lmalloc, free };

MemFreeListDescriptor SMTIntMsgDescr  = { SMT_MSG_BUFFER_SIZE,
					  INIT_FREE_FDDI_MSGHDR_CT,
					  MORE_FREE_FDDI_MSGHDR_CT,
					  lmalloc, free };

MemFreeListDescriptor SRFIntMsgDescr  = { sizeof(struct ECListElement),
					  MAX_EC_ELEMENTS,
					  MORE_FREE_FDDI_MSGHDR_CT,
					  lmalloc, free };

/*
 *
 */
static uInt32 AllocateFreeMsgBuffer ( MemDescr, msgCount )
MemFreeListDescriptor *MemDescr;
uInt16 msgCount;
{
   uInt16 i;
   GenericMsgType *msg;


   for (i=0; i < msgCount; i++)
   {
      if (!(msg=(GenericMsgType *) MemDescr->MallocFunc( MemDescr->MsgSize)))
      {
         SMTDPT1("AllocateFreeMsgBuffer: LMALLOC Error(count =%d)\n", i);
	 return 1;        /* Error */
      }
      SMTDPT2("%d: Memory Allocation = %x\n", i, msg);
      CreateIntMsg( (MSGHDR*) msg, &MemDescr->freeMsgList );
   } 

   return 0;              /* Successful */
}

/*
 *
 */

uInt32 InitFDDIMsgMBox ( MemDescr )
MemFreeListDescriptor *MemDescr;
{
   CreatMailbox( &MemDescr->freeMsgList );
   return AllocateFreeMsgBuffer ( MemDescr, MemDescr->MsgCount );
}
   

/*
 *
 */
GenericMsgType *GetMBoxFreeBuffer( MemDescr )
MemFreeListDescriptor *MemDescr;
{
   GenericMsgType *msghdr;

   ReceiveIntMsg (msghdr, &MemDescr->freeMsgList);
   if (msghdr)
   {
      return ( msghdr );
   }
   else
   {
      if (AllocateFreeMsgBuffer (MemDescr, MemDescr->MsgAdding))
      {
	return NULL;                /* Fails to get a free buffer */
      }
      return GetFDDIMsgHdr();
   }
}


/*
 *
 */
void PutMBoxFreeBuffer ( MemDescr, msgBuffer )
MemFreeListDescriptor *MemDescr;
GenericMsgType *msgBuffer;
{
   SendIntMsg((MSGHDR*) msgBuffer, &MemDescr->freeMsgList );
}

/*
 *
 */
#define SIGNAL_STACK_SIZE    MAX_PORT_COUNT*2

static DriverSignalType DriverSignalStack[SIGNAL_STACK_SIZE];
static Int16 SignalStackPtr=-1;

void InitSignalStack()
{
   SignalStackPtr = -1;
}

void PushSignal(signal, entity)
uInt16 signal, entity;
{
   if (++SignalStackPtr == SIGNAL_STACK_SIZE)
   {
      --SignalStackPtr;
      return;
   }

   DriverSignalStack[SignalStackPtr].signalType = signal;
   DriverSignalStack[SignalStackPtr].entity = entity;
}

uInt32 PopSignal (signal, entity)
uInt16 *signal, *entity;
{
   if (SignalStackPtr < 0)
   {
      return FALSE;
   }

   *signal = DriverSignalStack[SignalStackPtr].signalType;
   *entity = DriverSignalStack[SignalStackPtr--].entity;
   return TRUE;
}

