
/***********************************************************
 *
 *	Program Name:	nim960 multiport token ring bridge
 *
 *	Filename:
 *
 *	$Log:   /usr/shasta/pvcs/fddicon/util/pkt.c_v  $
 * 
 *    Rev 1.7   24 Apr 1993 12:14:58   jlin
 * 
 *    Rev 1.6   30 Jan 1993 12:33:30   jang
 * no driver free buf function should be attached to the pkt during
 * reset_pkt(). The user of get_pkt() should do it.
 * 
 *    Rev 1.5   07 Jan 1993 09:52:14   jang
 * modified for testing collector
 * 
 *    Rev 1.2   04 Jan 1993 14:48:08   jang
 * modified to meed the change of struct pkt which was changed by the 
 * router group
 * 
 *    Rev 1.1   02 Nov 1992 19:09:30   jang
 * modified to fit FDDI BSI chip limitation
 *
 *	Creation Date:
 *
 *	Date:
 *
 *	Programmers:	Yan Ke
 *
 *	Modifications:
 *          11/2/92 - Jiawei Jang. Modified to fit into FDDI. Keep
 *                      the functions name are the same.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 *
 ************************************************************/


#include <fddi.h>
#include <pkt.h>
#include <krnl.h>
#include <dips.h>


/*
 *-----------------------------------------------------------------------
 *   Import Variables
 *-----------------------------------------------------------------------
 */



/*
 *-----------------------------------------------------------------------
 *     Local Variables
 *-----------------------------------------------------------------------
 */

MBOX FreePktMbox;



/*
 *      function prototype
 */
 
#ifdef DO_LINT
static void ResetPkt(PKT *);
#else
static void ResetPkt();
#endif


/**************************************************************************
 *  Function    init_pkt
 *
 *  Description
 *      This function init pkt structure without buffer hook up to the
 *      PKT structure. It is assumed that the memory region has been
 *      allocated be the calling function. No data buffer is linked to
 *      the PKT.
 *      NOTE ---------------------------------------------------------
 *      This code is based upon the PKT data structure used by bridge
 *      group. It is different from the code used by the router group.
 *      It needs to changed if the assumption is incorrect.
 *      --------------------------------------------------------------
 *
 *  Parameters:
 *      uint32  pkt_cnt - # of PKTs
 *
 *  Return: OK
 ***************************************************************************/
uint32 init_pkt (pkt_cnt)
uint32	pkt_cnt;	/* PKTs number */
{
    int	i;
    PKT	*pkt_ptr;

    CreatMailbox(&FreePktMbox);
    
    for (i=0; i < pkt_cnt; i++) {
      if ((pkt_ptr=(PKT*)lmalloc(sizeof(PKT))) == NULL) {
	if (get_debug() == DEBUG_ON)
	  printf("no memory for PKTs\n");
	return (FDDI_ERROR);
      }
      ResetPkt(pkt_ptr);
      SendMessage((MSGHDR *)pkt_ptr,&FreePktMbox);
    }
}


/*************************************************************************
 *  Function    get_pkt
 *
 *  Description
 *      This function returns a PKT. Note that there is no data buffer
 *      link to the PKT.
 *  
 *  Parameter:  none
 *
 *  Return: pointer to the PKT, NULL if no memory left
 ************************************************************************/
PKT *get_pkt ()
{
    PKT *pkt_ptr;
    int prevalue;

    prevalue = crit_on();
/*    Di(); */
    if ((pkt_ptr = (PKT *)AcptMessage(&FreePktMbox)) == NULL) {
        if ((pkt_ptr = (PKT *)lmalloc(sizeof(PKT))) == NULL) {
	      crit_off(prevalue);
/*            Ei(); */
            return (NULL);
	}
        else 
            ResetPkt(pkt_ptr);
    }

    pkt_ptr->pktUseCount = 1;

    crit_off(prevalue);
/*    Ei(); */
    return(pkt_ptr);
}


/****************************************************************************
 *  Function    free_pkt
 *
 *  Description
 *      This function frees a PKT. If nobody owns the PKT, it returns the
 *      data buffer to the free PSP pool in the driver.
 *
 *  Parameter:
 *      PKT *pkt_ptr
 *
 *  Return: void
 ****************************************************************************/
void free_pkt (pkt_ptr) 
register PKT	*pkt_ptr;
{
  if (pkt_ptr == NULL)
    return;
#if 0
  printf("in free_pkt(),pkt_ptr is %lx\n",pkt_ptr);
#endif

  pkt_ptr->pktUseCount--;

  if (pkt_ptr->pktUseCount == 0) {
    pkt_ptr->pktDriverFree((uint32)pkt_ptr->pktBufPtr);
    ResetPkt(pkt_ptr);
    SendMessage((MSGHDR *)pkt_ptr,&FreePktMbox);
  }
}


/*
 *-------------------------------------------------------------------------
 *          Local Functions
 *-------------------------------------------------------------------------
 */
/*************************************************************************
 *  Function    ResetPkt
 *
 *  Description
 *      This function resets fields in the PKT
 *
 *  Parameter:
 *      PKT *pkt_ptr
 *
 *  Return: void
 ************************************************************************/
static void ResetPkt (pkt_ptr)
PKT *pkt_ptr;
{ 
  int i;
  extern void free_pkt();

  pkt_ptr->pktMsgHdr.mh_marker = PKT_MARKER;
  pkt_ptr->pktTotalSize = 0;
  pkt_ptr->pktUseCount = 0;
  pkt_ptr->pktRcvPort = 0;
  pkt_ptr->pktXmtPort = 0;
  pkt_ptr->pktDriverLink = NULL;

  pkt_ptr->pktBufLink = NULL;
  pkt_ptr->pktBufPtr = NULL;
  pkt_ptr->pktBufLen = 0;
  pkt_ptr->pktDataSize = 0;
  pkt_ptr->pktDataPtr = NULL;

  pkt_ptr->pktFree = free_pkt;  /* function to free pkt */
  pkt_ptr->pktDriverFree = NULL;/* driver function to free data buf */
  pkt_ptr->pktDriverInfo = 0;

  for (i=0; i < 4; i++)
    pkt_ptr->pktBridgeArea[i] = 0;
}
 




