/****************************************************************************
 *     Copyright (c) 1986, 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/asn1.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:26:46   holeman
 * Initial revision.
 *
 ****************************************************************************/

#if (!defined(asn1_inc))
#define asn1_inc

/* ASN.1 FLAGS (form and class), adjusted for position within an octet */
#define A_IDCF_MASK         0xE0        /* Mask for ID CLASS and FORM bits */
#define A_IDC_MASK          0xC0        /* Mask for ID CLASS bits */
#define A_IDF_MASK          0x20        /* Mask for ID FORM bit */
#define A_FLAG_MASK         0xE0
#define A_UNIVERSAL         0x00
#define A_APPLICATION       0x40
#define A_CONTEXT           0x80
#define A_PRIVATE           0xC0
#define A_PRIMITIVE         0x00
#define A_CONSTRUCTOR       0x20

#define A_DEFAULT_SCOPE     A_CONTEXT

/* ASN.1 basic types, all in UNIVERSAL scope */
#define A_NO_ID             0x00
#define A_BOOLEAN           0x01
#define A_INTEGER           0x02
#define A_BITSTRING         0x03
#define A_OCTETSTRING       0x04
#define A_NULL              0x05
#define A_OBJECTID	    0x06
#define A_SEQUENCE          0x10
#define A_SET               0x11

/* ASN.1 defined types, all based on OCTETSTRING */
#define A_NUMERICSTRING     0x12
#define A_PRINTABLESTRING   0x13
#define A_T61STRING         0x14
#define A_TELETEXSTRING     A_T61STRING
#define A_VIDEOTEXSTRING    0x15
#define A_IA5STRING         0x16
#define A_GRAPHICSTRING     0x19
#define A_VISIBLESTRING     0x1A
#define A_GENERALSTRING     0x1B

/* Other ASN.1 defined universal types */
#define A_GENERALIZEDTIME   0x18
#define A_UTCTIME           0x17
#define A_OBJECTDESCRIPTOR  0x07

/* Distinguished values for ASN.1 booleans */
#define A_TRUE              0xFF
#define A_FALSE             0x00

/* Some useful values */
/* Define how long is required to hold various items in ASN.1 format */
#define A_MAX_UTCTIME_SIZE      17
#define A_MAX_INT_BUFF  	4   /* Longest integer */
#define A_MAX_BOOL_BUFF 	1   /* Longest boolean */
#define A_MAX_T_BUFF    	4   /* Longest type field */
#define A_MAX_L_BUFF    	5   /* Longest length field */

typedef long		INT_32_T;
typedef unsigned long	UINT_32_T;
typedef short		INT_16_T;
typedef unsigned short	UINT_16_T;
typedef unsigned char   UINT_8_T;
typedef unsigned char   OCTET_T ;
typedef OCTET_T         *OCTET_P;
typedef unsigned int    ATVALUE_T;	/* ASN.1 type values		*/
typedef unsigned int	ALENGTH_T;	/* ASN.1 contents field lengths	*/
typedef unsigned int	BITPOS_T;
typedef unsigned char   ABOOLEAN_T;

#define OCTETS_PER_INT32    (sizeof(INT_32_T)/sizeof(OCTET_T))
#define OCTETS_PER_UINT32    (sizeof(INT_32_T)/sizeof(OCTET_T))+1
#define OCTETS_PER_INT16    (sizeof(INT_16_T)/sizeof(OCTET_T))

/* Fast operations for positive values */
#define DIV_BY_8(x) ((x) >> 3)
#define MULT_BY_256(x)  ((x) << 8)

/****************************************************************************

NAME:  A_SizeOfLength

PURPOSE:  Compute the number of octets needed to hold an ASN.1 length field.

PARAMETERS:
	    ALENGTH_T	The proposed length

RETURNS:    ALENGTH_T	The number of octets needed

RESTRICTIONS:  

BUGS:  
****************************************************************************/
#define A_SizeOfLength(S) ((ALENGTH_T) ((S) <= 127 ? 1 : ((S) <= 255 ? 2 : \
		           ((S) <= 65535L ? 3 :((S) <= 16777215L ? 4 : 5)))))

/****************************************************************************

NAME:  A_SizeOfType

PURPOSE:  Compute the number of octets needed to hold an ASN.1 type field

PARAMETERS:
	    ATVALUE_T		The proposed type (without CLASS & FORM bits)

RETURNS:    unsigned int	The number of octets needed

RESTRICTIONS:  

BUGS:  
****************************************************************************/
#define A_SizeOfType(V) ((unsigned int) ((V) <= 30 ? 1 : \
			 ((V) <= 127 ? 2 : ((V) <= 16383 ? 3 : 4))))


/****************************************************************************
A_SizeOfBoolean -- Return total size that a boolean would occupy when
                   ASN.1 encoded  (tag and length fields are not included)

Parameters:
        None

Returns: ALENGTH_T  Number of octets the boolean would occupy if
		    in ASN.1 encoding
****************************************************************************/
#define A_SizeOfBoolean()	((ALENGTH_T)1)

/****************************************************************************
A_SizeOfOctetString --	Return total size that an octet string would
			occupy when ASN.1 encoded (tag and length fields
			are NOT included)

Parameters:
        ALENGTH_T	The size of the string

Returns: ALENGTH_T  Number of octets the octet string would occupy if
		    in ASN.1 encoding, NOT including the type/length fields
		    of the outermost wrapper.  Since these routines only
		    generate non-constructor encodings, the length is
		    exactly that given.
****************************************************************************/
#define A_SizeOfOctetString(L)	((ALENGTH_T)(L))


/****************************************************************************
OBJECT IDENTIFIER
****************************************************************************/

/* The following structure is used to internally hold an object identifier */
/* Each component is limited in range from 0 to 64K-1.			   */

typedef	struct	OBJ_ID_S
{
	int		num_components;	/* # of object id components	*/
	/* Note: this is the number of	*/
	/* components in the object id,	*/
	/* which is one more than the #	*/
	/* of subidentifiers in an	*/
	/* encoded object id.		*/
	unsigned int    *component_list;
} OBJ_ID_T;

#endif	/* asn1_inc */
