
/**
 *	Filename:	dbd.h	
 *
 *	$Log:   /usr/shasta/pvcs/i960/include/dbd.h_v  $
 * 
 *    Rev 1.15   06 Feb 1993 12:09:52   jang
 * modified the init_dbd() function prototype
 * 
 *    Rev 1.14   15 Jan 1993 14:46:48   holeman
 * get rid of fddi ifdefs
 * 
 *    Rev 1.13   04 Dec 1992 13:51:02   holeman
 * 
 *    Rev 1.12   20 Nov 1992 13:14:10   holeman
 * 
 *    Rev 1.11   10 Nov 1992 18:19:08   jlin
 * 
 *    Rev 1.10   09 Nov 1992 10:08:46   jang
 * added #define chnl_free_dbd(x)   free_dbd(x)
 * 
 *    Rev 1.9   03 Nov 1992 13:22:18   jang
 * added #ifdef __FDDI_CON to 'typedef dbd PKT'
 * 
 *    Rev 1.8   30 Oct 1992 16:54:32   jang
 * changed ifdef FDDI to indef __FDDI_CON_
 * 
 *    Rev 1.7   30 Oct 1992 12:27:20   jang
 * added ResetDbd() function prototype, but only ifdef FDDI
 * 
 *    Rev 1.6   08 Oct 1992 14:36:02   holeman
 * 
 *    Rev 1.5   08 Oct 1992 11:03:56   holeman
 * add functional and group flag bit definitions
 * 
 *    Rev 1.4   15 Sep 1992 09:03:32   holeman
 * 
 *    Rev 1.3   09 Sep 1992 14:27:12   holeman
 * 
 *    Rev 1.2   28 Aug 1992 16:11:20   holeman
 * remove media dependencies
 * 
 *    Rev 1.1   27 Aug 1992 10:00:52   holeman
 * 
 *    Rev 1.0   01 Jul 1992 14:26:54   holeman
 * Initial revision.
 *
 *	Comments:	The DBD data structure.
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#ifndef __DBD_H
#define __DBD_H 0x100a	/* V1.00a */

#ifndef __TYPES_H
#include "types.h"
#endif

struct dbd 
	{            /* data buffer descriptor */
	struct dbd *db_nxtpkt;	/* Used for chaining DBDs by application */
	word   db_idmark;		/* for marking this as a DBD */
	struct dbd *db_nxtdbd;	/* for chaining purposes (used by driver) */
	word   db_bufsiz;		/* buffer size */
	byte  *db_buffer;		/* pointer to buffer */
	word   db_actcnt;		/* number bytes in buffer */
	word   db_indent;		/* logical start of buffer */
	word   db_contrl;		/* buffer control and flags */
	word   db_snccnt;		/* used by the sonic driver */
	word   db_rcvportno;		/* received port number  */
	word   db_xmtportlist;          /* transmit port list */
	word   db_snctda; 		/* pointer to sonic TDA */
	word   nb_tstamp;		/* time stamp (all 32 bits) */
	word   nb_flags; 		/* packet flags */
	word   nb_len;			/* number bytes of data in pkt */
	byte  *nb_destination;		/* pointer to destination field */
	byte  *nb_source;		/* pointer to source field */
	byte  *nb_routing_info;		/* pointer to routing field */
	long   nb_routing_length;	/* length of routing field */
	word   nb_transmit_status;	/* status of transmit */
	byte  *nb_prot;			/* pointer to next protocol field */
	word   nb_con;  		/* pointer to connection */
	shrt   nb_uu1 : 4;		/* unused */
	shrt   nb_thl : 4;		/* tcp header length */
	shrt   nb_fin : 1;		/* fin bit */
	shrt   nb_syn : 1;		/* syn bit */
	shrt   nb_rst : 1;		/* reset bit */
	shrt   nb_psh : 1;		/* push bit */
	shrt   nb_fack: 1;		/* ack valid */
	shrt   nb_furg: 1;		/* urgent ptr. valid */
	shrt   nb_uu2 : 2;		/* unused */
	/* DO NOT declare anything between nb_uu2 and nb_urg */
	shrt   nb_urg;			/* transmission urgent seq. number */
	word   nb_seq;			/* transmission sequence number */
	word   db_index; 
	};

typedef	struct dbd DBD;
typedef	struct dbd *PACKET;

#define DBD_MARK 	0x00444244	/* mark that this is a DBD */

/* DBD db_contrl bit fields */
#define DBDINXMT	0x80	/* INDIC that dbd is in transmit queue */
#define DBDFREE 	0x40	/* CMD that pkt should be freed after xmt */


/* nb_flags */
#define	PKT_TX_BROADCAST	0x0001
#define	PKT_RCV_BROADCAST	0x0002
#define	PKT_IP_BROADCAST	0x0004	/* set on receive */
#define	PKT_IEEEHDR		0x0008	/* set on receive or transmit */
#define	PKT_SENTOUT		0x0010	/* packet has been sent */
#define	PKT_FUNCTIONAL		0x0020	/* functional address */
#define	PKT_GROUP		0x0040	/* group address */
#define	PKT_SLIP		0x0100	/* set on receive or transmit	*/
#define	PKT_ADMIN		0x0200	/* set on receive or transmit	*/
#define	PKT_MAC			0x0400


/* broadcast macros */
#define	set_broadcast(p, value)	\
	if((value))					\
		(p)->nb_flags |= PKT_TX_BROADCAST;	\
	else	(p)->nb_flags &= ~PKT_TX_BROADCAST;

#define	is_broadcast(p)		((p)->nb_flags & (PKT_RCV_BROADCAST | PKT_TX_BROADCAST))
#define	is_mac_frame(p)		((p)->nb_flags & PKT_MAC)
#define	is_group(p)		((p)->nb_flags & PKT_GROUP)
#define	is_functional(p)	((p)->nb_flags & PKT_FUNCTIONAL)

/*
* DBD functions
*/
int init_dbd(int, int, int);
DBD *get_dbd(void);
void free_dbd(DBD*);

typedef struct nid_struct
	{
	shrt nid[3];
	} NID;

#endif
