/**
 *	Program Name:	nim960 program
 *
 *	Filename:	error.c
 *
 *	$Log:   /usr/shasta/pvcs/i960/include/error.h_v  $
 * 
 *    Rev 1.1   17 Jun 1993 14:24:10   jang
 * added two more error code for fddi
 * 
 *    Rev 1.0   01 Jul 1992 14:27:00   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

#ifndef	__ERROR_H
#define	__ERROR_H

/* definitions of error codes */

#define CMD_SYNTAX_ERR	 	1	
#define	KW_UN_AMB           	2
#define OUT_OF_RANGE		3
#define	INV_PORT		OUT_OF_RANGE 	
#define	REQ_PRIV		4
#define NO_SUCH_ENTRY           5
#define USER_NOT_LOGIN          6
#define LOGIN_FAIL              7 
#define	INV_SPEC_CHAR	        8	
#define INVAL_PWD               9 
#define ERR_PASSWORD            INVAL_PWD
#define PWD_VER_FAIL            10 
#define NO_SESSION              11
#define ERR_NOTCONN             NO_SESSION
#define EX_ENTRY_LIMIT          12
#define ERR_TBL_FULL	        EX_ENTRY_LIMIT	
#define NO_PREFER               13
#define	KW_UNKNOWN  	        14		
#define EX_LIMIT                15
#define NO_RESOURCE             16
#define ERR_NORSRC              NO_RESOURCE 
#define UNKNOWN_DNAME           17 
#define	PFX_REQUIRE	        18	
#define INV_NAME	        19 
#define ERR_NET_ADDR	        20	
#define CAN_NOT_MODIFY         	21 
#define	ERR_REMOTEBUSY	 	22
#define	ERR_NOREMOTERESOURCE	ERR_REMOTEBUSY	
#define	ERR_UNKNOWN 		UNKNOWN_DNAME		/* no such host */
#define	ERR_NETFAIL		23		/* network failure */
#define	ERR_BADSERVICE		24	
#define	ERR_TIMEOUT    		25	
#define	ERR_NET_UNREACHABLE	26	
#define	ERR_REMOTEREJECT	27  /* LAT unknown error code */
#define CAN_NOT_SET             28 
#define	NO_SUCH_USER		29	
#define	NO_RMV_MASTER		30	
#define	MASTER_NOSET		NO_RMV_MASTER	
#define ERR_KEY			31	
#define	USER_LOGGED_IN		32	
#define CAN_NOT_DEFINE          33 
#define	DUP_ALIAS_CMD		34	
#define DUP_USER_NAME		DUP_ALIAS_CMD 
#define	LINE_TOO_LONG		35	
#define ERR_F_ABORT             36 
#define	ADM_INVALID_CMD		37	
#define CAN_NOT_SENT            38 
#define	ERR_NOTNEGOT	   	CAN_NOT_SENT	
#define CMD_PRIV_ERR		39	
#define	INV_MSG_SLOT		40
#define NON_PRINT_CHAR          41
#define	NO_PURGE_MASTER		42
#define	NO_HOST_NAME		43
#define	NO_HOST_ADDR		44
#define	CAN_NOT_REMOTE		45
#define	SNMP_MGR_SET		46 /* SNMP mgr already set */
#define	NO_MORE_MASTERS		47 /* No more master users */
#define ERR_DBD                 48 /* not dbd pointer */
#define RING_NOT_OP             49 /* ring is not operational */


/* definitions of error codes that were added for v2 support */
#define	ERR_NORMALCLOSE				0

#endif
