/*
* record which follows an image written to the flash eprom
* this record has the name of the last image written,
* the date and time of the write, and the number of times the flash has been
* written. The time is in two formats.  the number of seconds since 1/1/70
* and the regular ascii date and time
*/
struct flash_info
	{
	char marker[8];		/* "FLASH   " */
	u_int checksum;		/* for compressed data plus this record   */
	int info_size;		/* size of this record  */
	int comp_size;		/* compressed size of data after this record */
				/* comp_size does not include this record */
	int decomp_size;	/* decompressed size of code */
	int burn_cycles;	/* number of times the flash has been burned */
	u_long seconds;		/* time of creation (unix style) */
	int load_type;		/* how the file is stored in the flash */
	int options;		/* currently not used */
	int flags;		/* currently not used */
	char copyright[64];	/* Copyright Notice */
	char board_name[32];	/* board name */
	char file_name[64];	/* ascii filename */
	char version[8];	/* ascii version */
	char burn_date[8];	/* ascii date */
	char burn_time[8];	/* ascii time */
	};

/*
* load_type definitions
*/
#define UNCOMPRESSED		1
#define UNIX_COMPRESSION	2

/*
* return and error codes for the compression routines
*/
#define OK          0           /* Result codes from functions:         */
#define NOMEM       2           /*   Ran out of memory                  */
#define TOKTOOBIG   3           /*   Token longer than MAXTOKLEN chars  */
#define READERR     4           /*   I/O error on input                 */
#define WRITEERR    5           /*   I/O error on output                */
#define INFILEBAD   6           /*   Infile not in compressed format    */
#define CODEBAD     7           /*   Infile contained a bad token code  */
#define TABLEBAD    8           /*   The tables got corrupted (!)       */
#define NOSAVING    9           /*   no saving in file size             */
#define NOTOPENED  10           /*   output file couldn't be opened     */

/*
* flash functions
*/
int open_flash(void);
int close_flash(void);
int erase_flash(void *, int, int);
int write_flash(byte *, byte);
