/**
 *	Program Name:	nim960 program
 *
 *	Filename:	lme.h
 *
 *	$Log:   /shasta/home/pvcs/i960/include/lme.h_v  $
 * 
 *    Rev 1.1   14 Oct 1992 12:37:12   markv
 * Changed the ifname from array to pointer, as we already have the 
 * strings in memory somewhere, it sems pointless to copy them over.
 * Also, 32 chars seems rather limiting, doesn' it.
 * 
 *    Rev 1.0   01 Jul 1992 14:27:12   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#ifndef	__LME_H
#define	__LME_H

#define INT16    short       /* 16 bit integer */
#define INT32    unsigned long  /* 32 bits integer $DIFF*/



typedef  struct tod_struct{
                byte  second;    /* BCD value: 0 - 59 */
                byte  minute;    /* BCD value: 0 - 59 */
                byte  hour;      /* BCD value: 0 - 23 */
                byte  date;      /* BCD value: 1 - 31 */
                byte  month;     /* BCD value: 1 - 12 */
                byte  year;      /* BCD value: 0 - 99, the 
                                    last 2 digits of the year */
                }  TOD;

/*============================================================
**
**  IF_ENTRY_ID Object Specific data format 
**
**  Operation: Get only
**
**===========================================================*/


typedef struct if_entry_struct{

	char	*ifname; 	/* interface name */
	INT16	ifType;	/* 	eth-7, token bus-8, token ring-9
				 *	fddi-15 , point-to-point-20 
				 *	admin bus = 1, other
				 */
	INT32	ifMtu;		/* largest ip packet I can handle	*/
	INT32	ifSpeed;	/* in Mbit/s	*/
	byte	ifPhysAddress[6];	/* interface address */
	INT32	ifAdminStatus;	/*	1 = up, 2 = down, 3 = testing	*/
	INT32	ifOperStatus;	/*	1 = up, 2 = down, 3 = testing	*/
	INT32	ifLastChange;
	INT32	inbytecnt;	/* total received byte count */
	INT32	inucastpkts;	/* input uni-cast pkts */
	INT32	inbmcastpkts;	/*input broadcast and multicast pkts*/
	INT32	inDiscards;	/* packet discarded	*/
	INT32	inerrpkts;	/* input error pkts */
	INT32	inunknwnpkts;	/* unknown protocol packets */
	INT32	outbytecnt;	/* total transmitted byte count */
	INT32	outucastpkts;	/* out uni-cast pkts */ 
	INT32	outbmcastpkts;	/*out broadcast and multicast pkts*/
	INT32	outerrpkts;	/* output error pkts */
	INT32	outdiscardpkts;	/* output discard pkts */
	} 
	IF_ENTRY;





/*===========================================================
**
**   
** IP_STAT_ID     Object Specific data format 
**
** Operation : Get only
**===========================================================*/

typedef struct ip_stat_info{

		   INT32    inrcv;       /* Input received pkts */

		   INT32    inhdrerr;   /* input pkts with header error */

		   INT32    inaddrerr;  /* input pkts with address error */

		   INT32    inforward;   /* input pkts being forwarded, no for TS*/

		   INT32    inunknownproto; /* input pkts with unknown protocol*/

		   INT32    indiscard;    /* input good pkts being discarded */

		   INT32    indeliver;    /* input good pkts being delivered to 
		                          ** upper protocol*/

		   INT32    outreq;       /* output request pkts*/

		   INT32    outdiscard;   /* output req pkts being discarded */

		   INT32    outnoroute;   /* out pkts no route */

		   } IP_STAT;






/*===========================================================
**
**  IP_THROLD_ID  Object Specific data format 
**
**  Operation: Get / Set
**
**=========================================================*/

typedef struct ip_threshold_info{

	    INT16  status_map;             /* care mask for set operation */

		INT32  hdrerrthold_val;     /* in pkt header error 
		                           ** threshold value */

		INT32  hdrerrthold_rstval;  /* reset value of threshold above*/

		INT32  addrerrthold_val;   /* in pkts address error threshold value */

		INT32  addrerrthold_rstval; /* reset value of threshold above */


		INT32  protoerrthold_val;  /* in pkts proto error threshold value */

		INT32  protoerrthold_rstval; /* reset value of threshold above */

		INT32  discardthold_val;    /* output pkts discard threshold value*/

		INT32  discardthold_rstval; /* reset value of the threshold */

		INT32  noroutthold_val;   /* out no route threshold value */

		INT32  noroutthold_rstval; /* reset value of threshold above */

		} IP_THRESHOLD;



/*========================================================
**
**  IP_ENTRY_ID    Object specific data format 
**
**  Operation: Get Only
**
**========================================================*/

typedef struct ip_entry{

		INT32     ipaddr;

		INT32     ipnetmask;

		INT32     ipbroadcast;

		INT16     ipifindex;

		}  IP_ENTRY;




/************************************************************
**
**        TCP LME 
**
************************************************************/



/*=========================================================
**
**  TCP_STAT_ID    Object Specific data format 
**
**  Operation: Get Only
**
**=============================================================*/

typedef struct tcp_stat_struct{

		INT16    maxcon;         /*tcp max connection */

		INT32    active_con;     /* active connection, SYN-Sent state */

		INT32    pass_con;       /* passive connection, SYN-RCV state */

		INT32    con_fail;      /* passive or active connections fail */

		INT32    close_con;     /* close connection */

		INT16    current_con;   /* established or close-wait connection */

		INT32    outseg;       /* out segments, excluding retransmission */

		INT32    retran_seg;   /* retransmission tcp segments*/

		INT32    inseg;        /* input segments, including retransmission */

		} TCP_STAT;






/*=================================================================
**
**
**   TCP_THROLD_ID    Object Specific data format 
**
**    Operation: Get / Set
**===============================================================*/

typedef struct tcp_throld_struct{

			  INT16    status_map;       /* care masks for set operation */
			  INT32    cur_opened_thold_value;  /* upper threshold value
			                                    ** of current opened con */

			  INT32    cur_opened_del_val;     /* delta value of previous
			                                   ** treshold    */

			  INT32    retran_seg_thold_val; /* retran segs threshold value */

			  INT32    retran_seg_thold_rst_val; /* reset value of previous
			                                     ** threshold */

			  byte    event_enable;           /* event enable */
              byte    reserved;

			  } TCP_THRESHOLD;





/************************************************************
**  the following constants are used in the event_enable field 
*************************************************************/
#define    ESTAB_EVENT_ENABLE    0x1

#define    CLOSED_EVENT_ENABLE  0x2

#define    ESTAB_RESET_EVENT_ENABLE  0x4



/*==========================================================
**
**  TCP_CON_ENTRY_ID  Object specific data format 
**
**  Operation: Get Only
**
**=========================================================*/

typedef struct tcp_con_id{

		INT32    local_ip_addr;  /* if == 0xFFFFFFFF, get TCP
		                         ** Connection table */

		INT32    rem_ip_addr;

		INT16    local_tcp_port;

		INT16    rem_tcp_port;
		} TCP_SOCKET;




typedef struct  tcp_con_entry{

		TCP_SOCKET   tcp_id;

		INT16        tcp_state;     /* closed ( 1), listen ( 2)
		                            *  syn-sent (3),syn-rcv(4)
		                            *  opened (5), fin-wait1(6)
		                            *  fin-wait2(7), closewait(8)
		                            *  last_ack(9), closing(10)
		                            *  timewait(11)  */
		INT16        snd_window;    /* send window */

		INT16        maxseg;        /* max tcp segment size */

		INT32        retran_segs;   /* retransmitted segments */

		INT32        outsegs;       /* out tcp no-retran segments */

		}  TCP_CON_ENTRY;





/*===========================================================
**
**  SYS_INFO_ID  Object Specific data format
**
**   Operation: Get Only       $DIFF
**=========================================================*/

typedef struct sys_info_struct{
        INT32     syslastinit;    /* timeticks since inited
		                          in hundredths of seconds */
        TOD       inittime;       /* network manager part init time */

		INT16     sys_type;      /* 1- bridge  2 - router
		                         ** 3-terminal server 4 - computer
								 ** net monitor
								 **/
		INT16     number_if;     /* number of interface on this system*/
        /*  followed by sysid field , sysid has first byte
		**  as length field which indicates how many bytes follow
		**  the length byte
		**/
		}SYS_INFO;


#endif
