/**
 *	Program Name:	nim960 program
 *
 *	Filename:	task.h
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/task.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:27:42   holeman
 * Initial revision.
 *
 *	Comments:	Simulations of the FTP Kernel on the V3 kernel
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#ifndef	__TASK_H
#define	__TASK_H

/* 
 * Tasks
 */

typedef	struct	tcp_task
	{		
/* No need for TCB structure. The krnl allocates it when the task */
/* is created */
/*	TCB     tcp_tcb;    */	/* V3 task control block */
	SEM     tcp_sem;	/* V3 semaphore */
	} task;

#define tk_cur ((task *)CurrentTask())
extern	task *tk_fork();	/* fork a new task */

#define	tk_yield()	{ReSchedule(IDLE_PRIORITY);}
#define tk_wake(t)  {SendSignal(&t->tcp_sem);}
#define tk_iwake(t) {ISendSignal(&t->tcp_sem);}
#define tk_block()  {RcvSignal(&tk_cur->tcp_sem);tk_cur->tcp_sem.sm_count=0;}


/*
 * Queues
 */

#define	queue  MBOX
#define	q_elt MSGHDR *
#define q_head mb_mflink
#define q_tail mb_mblink

extern q_elt q_create();

#define q_deq(q)          AcptMessage(q)
#define aq_deq(q)         AcptMessage(q)
#define q_del(q, elt)     RmvMessage (elt, q)
#define	q_addt(q, elt)    SendMessage(elt, q)
#define	aq_addt(q, elt)   SendMessage(elt, q)

#define	TPS	 100			/*  Clock  ticks per second.  */

TIMER *tm_alloc();

#define tm_set(n,a,b,c) {tm_tset((n)*TPS,a,b,c);}
#define tm_reset(n,a) {tm_retset((n)*TPS,a);}


#endif
