/**
 *	Program Name:	nim960 program
 *
 *	Filename:	tftpboot.h
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/tftpboot.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:27:48   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/


#define	TFTP_FILE_LENGTH	128	/* including the terminating null */

typedef struct tftptbl
	{
	UDPCONN	con;	/* the udp connection for this tftp session	*/
	in_name	fhost;		/* receiver's ip address	*/
	uint	sport;	/* my port number		*/
	uint	dport;	/* receiver's port number	*/
	uint	ackno;
	int	state;
	int	retry;
	int	done;		/* set when all packets are received	*/
	int	timeout;	/* set on time out		*/
	int	abort;		/* set when there is a critical error	*/
	unsigned long	length;		/* file length	*/
	}
	TFTPTBL;

typedef struct	boot_struct
	{
	in_name	MyIP;		/* my ip address	*/
	in_name	ServerIP;	/* boot from this host	*/
	in_name	NetMask;
	in_name	RouterIP;
	int	IsSlip;		/* 0 = ethernet; otherwise slip		*/
	int	baud;
	int	mode;
#define	TFTP_MODE_AUTO		1	
#define	TFTP_MODE_REMOTE	2 
#define	TFTP_MODE_MANUAL	3

	char	FileName[TFTP_FILE_LENGTH];
	byte	*LoadAddress;	/* where to load the file	*/
	ulong	size;		/* of LoadAddress		*/
	ulong	DramSize;	/* system Dram size		*/
	ulong	SramSize;	/* system Sram Size		*/
	}
	BOOT_BLOCK;


extern	TFTPTBL	tftp;

int	UseBootRecord(BOOT_BLOCK *boot);
void	EnterBootRecord(BOOT_BLOCK *boot);
int	AskForBaud(void);
int	AskYesNo(char *message);
void	AskIP(char *message, in_name *ip);
int	CheckImage(byte *LoadAddress, ulong FileLength);


