/* 
	This header file contains the error codes used by the exception system.
	
 * $log$
 *
 *****************************************************************************/

#ifndef ERRORS_H
#define ERRORS_H

#include "except.h"

/* Exception numbers

There are 4 bytes to each error code. The first byte is the module or
library number, the second the routine, and the last 2 depend on the 
routine.

Error code 0:0:0:0 is not permitted.

Library error assignments

*/
#define SNMP_Error      0x01000000
#define Support_Error	0x02000000
#define RMON_Error	0x03000000
#define RING_MAP_Error	0x04000000

#define module_error_mask (0xFFFF0000)

/* Individual Module Errors */
#define Queue_Error	(Support_Error | 0x010000)

#define q_pop_error 		(Queue_Error|	0x0100)
#define q_push_error 		(Queue_Error|	0x0200)
#define q_append_error 		(Queue_Error|	0x0300)
#define q_de_queue_error	(Queue_Error|	0x0400)
#define q_open_error 		(Queue_Error|	0x0500)
#define q_close_error 		(Queue_Error|	0x0600)
#define q_insert_error 		(Queue_Error|	0x0700)
#define q_inject_error 		(Queue_Error|	0x0800)
#define q_init_error 		(Queue_Error|	0x0900)
#define q_first_in_queue_error 	(Queue_Error|	0x0a00)
#define q_last_in_queue_error 	(Queue_Error|	0x0b00)
#define q_next_in_queue_error 	(Queue_Error|	0x0c00)
#define q_prev_in_queue_error 	(Queue_Error|	0x0d00)
#define q_is_empty_queue_error	(Queue_Error|	0x0e00)
#define q_size_of_queue_error 	(Queue_Error|	0x0f00)
#define q_get_next_error	(Queue_Error|	0x1100)
#define q_scan_error 		(Queue_Error|	0x1200)
#define q_search_error	 	(Queue_Error|	0x1300)
#define q_detach_error	 	(Queue_Error|	0x1500)
#define q_check_error	 	(Queue_Error|	0x1600)

/* Q-generic error codes */
#define q_bad_head		0x01
#define q_bad_node		0x03
#define q_head_inconsistent	0x05
#define q_head_front_bad	0x07
#define q_head_back_bad		0x09
#define q_head_size_bad		0x0b
#define q_empty			0x0d
#define q_corrupt		0x0f
#define q_null_head		0x11
#define q_null_node		0x13

#define SNMP_PDU_Error		(SNMP_Error|	0x020000)

#define SNMP_Indefinite_Len    (SNMP_PDU_Error|     0x0100)
#define SNMP_Unsupported_Tag   (SNMP_PDU_Error|     0x0200)
#define SNMP_Packet_Too_Short  (SNMP_PDU_Error|     0X0300)
#define SNMP_Packet_Unex_Tag   (SNMP_PDU_Error|     0X0400)
#define SNMP_Packet_Len_Bad    (SNMP_PDU_Error|     0X0500)
#define SNMP_BER_Viol          (SNMP_PDU_Error|     0X0600)
#define SNMP_Expected_Int      (SNMP_PDU_Error|     0X0700)
#define SNMP_Expected_Str      (SNMP_PDU_Error|     0X0800)
#define SNMP_Expected_OID      (SNMP_PDU_Error|     0X0900)
#define SNMP_Expected_SEQ      (SNMP_PDU_Error|     0X0A00)
#define SNMP_UnExpected_Tag    (SNMP_PDU_Error|     0X0B00)
#define SNMP_Unsupported_Ver   (SNMP_PDU_Error|     0X1000)
#define SNMP_Inv_Community     (SNMP_PDU_Error|     0X1100)
#define SNMP_Inv_PDU           (SNMP_PDU_Error|     0X1200)

#define RMON_Stats_Error	(RMON_Error|	0x010000)
#define RMON_Hist_Error		(RMON_Error|	0x020000)
#define RMON_Alarm_Error	(RMON_Error|	0x030000)
#define RMON_Hosts_Error	(RMON_Error|	0x040000)
#define RMON_HostTopN_Error	(RMON_Error|	0x050000)
#define RMON_Matrix_Error	(RMON_Error|	0x060000)
#define RMON_Filter_Error	(RMON_Error|	0x070000)
#define RMON_Capture_Error	(RMON_Error|	0x080000)
#define RMON_Event_Error	(RMON_Error|	0x090000)
#define RMON_Trap_Error		(RMON_Error|	0x0a0000)

/* RMON Generic Routines */
#define RMON_Init_Error		(0x0100)
#define RMON_Default_Error	(0x0200)
#define RMON_Define_Error	(0x0300)

/* RMON Generic errors */
#define RMON_malloc_error 	(0x01)
#define RMON_bad_OID	 	(0x02)
#define RMON_bad_event	 	(0x03)
#define RMON_get_vb_fail 	(0x04)
#define RMON_add_vb_fail 	(0x05)
#define RMON_build_oid_fail 	(0x06)

/* RMON Trap Errors */

#define RMON_open_trap		(0x1000)
#define RMON_trap_index		(0x1100)
#define RMON_trap_var		(0x1200)
#define RMON_trap_sample	(0x1300)
#define RMON_trap_value		(0x1400)
#define RMON_trap_fall		(0x1500)
#define RMON_trap_rise		(0x1600)
#define RMON_trap_close		(0x1700)

#define Startup_Trap_Error		(Support_Error | 0x020000 )

#define Startup_get_vb_fail 	(0x04)
#define Startup_add_vb_fail 	(0x05)
#define Startup_build_oid_fail 	(0x06)
#define Startup_trap_close 	(0x07)

#define RM_loop_TTP_list				(RING_MAP_Error | 0x01 )
#define RM_non_empty_RSE_queue			(RING_MAP_Error | 0x02 )
#define RM_NULL_NPStats					(RING_MAP_Error | 0x03 )
#define RM_NULL_NPStats_NADN			(RING_MAP_Error | 0x04 )

#endif
