#ifndef get_svc
/*
	This header file defines some macros used in providing access
	to the SNMP SVC routines. The geter needs to specify the mib variable
	name needed, and the address where the value is to be deposited.
	For indexed MIB objects, one or more indexes need to be provided.
 * $Log:   /user/pvcs/trc/include/call_svc.h_v  $
 * 
 *    Rev 1.28   10 Feb 1993 18:25:52   nayan
 * added macro to be used only for FDDI Con.
 * 
 *    Rev 1.27   17 Dec 1992 11:53:26   nayan
 * added macros to be used only for fddi con.
 * 
 *    Rev 1.26   30 Oct 1992 17:34:00   nayan
 * deleted unused header files.
 * 
 *    Rev 1.25   30 Oct 1992 09:22:12   nayan
 * addition of macro set_indexIfIp_svc() used for IP 
 * Address Translation Table (IPCache Table).
 * 
 *    Rev 1.24   21 Oct 1992 10:40:42   markv
 * New macro to handle the proper host table, which encodes the length
 * of the address into the instance identifiers. The length here is
 * alsways assumed to be 6, so it is hard coded. This might change, of
 * course...
 * 
 *    Rev 1.23   25 Sep 1992 09:19:24   nayan
 * Two errors in the complex next defines - actually used the get function...
 * MarkV
 * 
 *    Rev 1.22   18 Sep 1992 15:47:16   markv
 * Some of the get_next macros were lacking pointer indirections.
 * 
 *    Rev 1.21   17 Sep 1992 18:18:24   nayan
 * Corrected a few errors, and added set_indexIfMac.
 * So had to extend the number of param indexes to a possible 7.
 * 
 *    Rev 1.20   14 Sep 1992 16:26:56   markv
 * added $LOG directive
 *
*/
#ifndef WITH_HANDELING
#include <except.h>
#endif
#ifndef SNMP_GET
#include <syteksnm.h>
#endif

#include <mib.h>
#include <hls.h>
#include <rfc1213.h>

#define get_svc(mib_obj, val_add, blen) \
{\
	extern MIBLEAF_T mib_obj##_leaf;\
	if ( svc_##mib_obj ( SNMP_GET , (byte FAR *)&svc_compcount , (unsigned int FAR *)&svc_complist, (int FAR *)blen, (UINT_32_T FAR *)val_add ))\
		error( __LINE__,__FILE__ "Unexpected SVC Error" ); /* Never returns */ \
	if(mib_obj##_leaf.expected_tag == VT_STRING) \
		((char FAR *)val_add)[*blen] = '\0';}

#ifdef __FDDI_CON

#define get_smt(mib_obj, val_add, blen) \
{\
	if ( svc_##mib_obj ( SNMP_GET , (byte FAR *)&svc_compcount , (unsigned int FAR *)&svc_complist, (int FAR *)blen, (UINT_32_T FAR *)val_add ))\
		error( __LINE__,__FILE__ "Unexpected SVC Error" ); /* Never returns */ \
}

#endif

#define get_simple_svc(mib_obj,val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[1]; \
	svc_compcount = 1;	svc_complist[0] = 0;\
	get_svc(mib_obj,val_add, blen)\
}

#define get_index1_svc( mib_obj,index, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[2]; \
	svc_compcount = 1;\
	svc_complist[0] = *index;\
	get_svc(mib_obj,val_add, blen)\
}

#define get_index2_svc( mib_obj,index1,index2, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[3]; \
	svc_compcount = 2;\
	svc_complist[0] = *index1;\
	svc_complist[1] = *index2;\
	get_svc(mib_obj,val_add, blen)\
}

#ifdef __FDDI_CON
#define get_index2_smt( mib_obj,index1,index2, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[3]; \
	svc_compcount = 2;\
	svc_complist[0] = *index1;\
	svc_complist[1] = *index2;\
	get_smt(mib_obj,val_add, blen)\
}

#define get_index1_smt( mib_obj,index, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[2]; \
	svc_compcount = 1;\
	svc_complist[0] = *index;\
	get_smt(mib_obj,val_add, blen)\
}
#endif

#define get_index3_svc( mib_obj,index1,index2, index3, val_add,blen)\
{\
	byte svc_compcount; \
	unsigned int svc_complist[4]; \
	svc_compcount = 3;\
	svc_complist[0] = *index1;\
	svc_complist[1] = *index2;\
	svc_complist[2] = *index3;\
	get_svc(mib_obj,val_add, blen)\
}

#define get_indexip_svc( mib_obj,ipaddr,val_add,blen)\
{\
	byte svc_compcount; \
	unsigned int svc_complist[4]; \
	svc_compcount = 4;\
	svc_complist[0] = ((char *)ipaddr)[0];\
	svc_complist[1] = ((char *)ipaddr)[1];\
	svc_complist[2] = ((char *)ipaddr)[2];\
	svc_complist[3] = ((char *)ipaddr)[3];\
	get_svc(mib_obj,val_add, blen)\
}

#define get_indexHostMac_svc( mib_obj,index,macad, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[8]; \
	svc_compcount = 8;\
	svc_complist[0] = *index;\
	svc_complist[1] = 6;\
	svc_complist[2] = ((char *)macad)[0];\
	svc_complist[3] = ((char *)macad)[1];\
	svc_complist[4] = ((char *)macad)[2];\
	svc_complist[5] = ((char *)macad)[3];\
	svc_complist[6] = ((char *)macad)[4];\
	svc_complist[7] = ((char *)macad)[5];\
	get_svc(mib_obj,val_add, blen)\
}

#define get_indexIfIp_svc( mib_obj,ifindex,ipadd, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[7]; \
	svc_compcount = 5;\
	svc_complist[0] = *ifindex;\
	svc_complist[1] = ((char *)ipadd)[0];\
	svc_complist[2] = ((char *)ipadd)[1];\
	svc_complist[3] = ((char *)ipadd)[2];\
	svc_complist[4] = ((char *)ipadd)[3];\
	get_svc(mib_obj,val_add, blen)\
}

#define get_indexIfMac_svc( mib_obj,ifindex,macad, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[7]; \
	svc_compcount = 7;\
	svc_complist[0] = *ifindex;\
	svc_complist[1] = ((char *)macad)[0];\
	svc_complist[2] = ((char *)macad)[1];\
	svc_complist[3] = ((char *)macad)[2];\
	svc_complist[4] = ((char *)macad)[3];\
	svc_complist[5] = ((char *)macad)[4];\
	svc_complist[6] = ((char *)macad)[5];\
	get_svc(mib_obj,val_add, blen)\
}

#define next_svc(mib_obj, val_add, blen) \
{	 extern MIBLEAF_T mib_obj##_leaf;\
	*(blen)=1;\
	if ( svc_##mib_obj ( SNMP_GETNXT , (byte FAR *)&svc_compcount , \
		(unsigned int FAR *)&svc_complist, \
		(int FAR *)blen, (UINT_32_T FAR *)val_add ))\
	    *(blen) = 0 ;\
	if(mib_obj##_leaf.expected_tag == VT_STRING) \
		((char FAR *)val_add)[*blen] = '\0';}

#define next_simple_svc(mib_obj,val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[1]; \
	svc_compcount = 1;	svc_complist[0] = 0;\
	next_svc(mib_obj,val_add, blen)\
}

#define next_index1_svc( mib_obj,index, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[1]; \
	svc_compcount = 1;\
	svc_complist[0] = *index;\
	next_svc(mib_obj,val_add, blen)\
	*index = svc_complist[0];\
}

#define next_index2_svc( mib_obj,index1,index2, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[2]; \
	svc_compcount = 2;\
	svc_complist[0] = *index1;\
	svc_complist[1] = *index2;\
	next_svc(mib_obj,val_add, blen)\
	*index1 = svc_complist[0];\
	*index2 = svc_complist[1];\
}

#define next_index3_svc( mib_obj,index1,index2, index3, val_add,blen)\
{\
	byte svc_compcount; \
	unsigned int svc_complist[3]; \
	svc_compcount = 3;\
	svc_complist[0] = *index1;\
	svc_complist[1] = *index2;\
	svc_complist[2] = *index3;\
	next_svc(mib_obj,val_add, blen)\
	*index1 = svc_complist[0];\
	*index2 = svc_complist[1];\
	*index3 = svc_complist[2];\
}

#define next_indexip_svc( mib_obj,ipaddr,val_add,blen)\
{\
	byte svc_compcount; \
	unsigned int svc_complist[4]; \
	svc_compcount = 4;\
	svc_complist[0] = ((char *)ipaddr)[0];\
	svc_complist[1] = ((char *)ipaddr)[1];\
	svc_complist[2] = ((char *)ipaddr)[2];\
	svc_complist[3] = ((char *)ipaddr)[3];\
	next_svc(mib_obj,val_add, blen)\
	((char *)ipaddr)[0] = svc_complist[0];\
	((char *)ipaddr)[1] = svc_complist[1];\
	((char *)ipaddr)[2] = svc_complist[2];\
	((char *)ipaddr)[3] = svc_complist[3];\
}

#define next_indexIfMac_svc( mib_obj,ifindex,macad, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[7]; \
	svc_compcount = 7;\
	svc_complist[0] = *ifindex;\
	svc_complist[1] = ((char *)macad)[0];\
	svc_complist[2] = ((char *)macad)[1];\
	svc_complist[3] = ((char *)macad)[2];\
	svc_complist[4] = ((char *)macad)[3];\
	svc_complist[5] = ((char *)macad)[4];\
	svc_complist[6] = ((char *)macad)[5];\
	next_svc(mib_obj,val_add, blen)\
	*ifindex = svc_complist[0];\
	((char *)macad)[0] = svc_complist[1] ;\
	((char *)macad)[1] = svc_complist[2] ;\
	((char *)macad)[2] = svc_complist[3] ;\
	((char *)macad)[3] = svc_complist[4] ;\
	((char *)macad)[4] = svc_complist[5] ;\
	((char *)macad)[5] = svc_complist[6] ;\
}

#define next_indexIfIp_svc( mib_obj,ifindex,ipad, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[5]; \
	svc_compcount = 5;\
	svc_complist[0] = *ifindex;\
	svc_complist[1] = ((char *)ipad)[0];\
	svc_complist[2] = ((char *)ipad)[1];\
	svc_complist[3] = ((char *)ipad)[2];\
	svc_complist[4] = ((char *)ipad)[3];\
	next_svc(mib_obj,val_add, blen)\
	*ifindex = svc_complist[0] ; \
	((char *)ipad)[0] = svc_complist[1] ;\
	((char *)ipad)[1] = svc_complist[2] ;\
	((char *)ipad)[2] = svc_complist[3] ;\
	((char *)ipad)[3] = svc_complist[4] ;\
}


#define next_indexHostMac_svc( mib_obj,index,macad, val_add,blen)\
{	byte svc_compcount; \
	unsigned int svc_complist[8]; \
	svc_compcount = 8;\
	svc_complist[0] = *index;\
	svc_complist[1] = 6;\
	svc_complist[2] = ((char *)macad)[0];\
	svc_complist[3] = ((char *)macad)[1];\
	svc_complist[4] = ((char *)macad)[2];\
	svc_complist[5] = ((char *)macad)[3];\
	svc_complist[6] = ((char *)macad)[4];\
	svc_complist[7] = ((char *)macad)[5];\
	next_svc(mib_obj,val_add, blen)\
	*index = svc_complist[0];\
	((char *)macad)[0] = svc_complist[2] ;\
	((char *)macad)[1] = svc_complist[3] ;\
	((char *)macad)[2] = svc_complist[4] ;\
	((char *)macad)[3] = svc_complist[5] ;\
	((char *)macad)[4] = svc_complist[6] ;\
	((char *)macad)[5] = svc_complist[7] ;\
}

int set_svc(int(*svc_routine)(),
		int FAR *blen,UINT_32_T FAR *val_add,int index_count,
		int index1, int index2,int index3, int index4,
		int index5, int index6, int index7 );

#define set_simple_svc(mib_obj,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		0,0,0,0,0,0,0,0))
	
#define set_index1_svc(mib_obj,index,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		1,index,0,0,0,0,0,0))

#define set_index2_svc(mib_obj,index1,index2,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		2,index1,index2,0,0,0,0,0))

#define set_index3_svc(mib_obj,index1,index2,index3,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		3,index1,index2,index3,0,0,0,0))

#define set_indexip_svc(mib_obj,ipaddr,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		4,((char *)ipaddr)[0],((char *)ipaddr)[1],((char *)ipaddr)[2],\
		((char *)ipaddr)[3],0,0,0 ))

#define set_indexIfMac_svc(mib_obj,ifindex,macaddr,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		7,ifindex,((char *)macaddr)[0],((char *)macaddr)[1],\
		((char *)macaddr)[2],((char *)macaddr)[3],\
		((char *)macaddr)[4],((char *)macaddr)[5]) )

#define set_indexIfIp_svc(mib_obj,ifindex,ipaddr,val_add,blen) \
	(set_svc(svc_##mib_obj, (int FAR *)blen, (UINT_32_T FAR *)val_add ,\
		5,ifindex,((char *)ipaddr)[0],((char *)ipaddr)[1],\
		((char *)ipaddr)[2],((char *)ipaddr)[3], 0, 0)  )
		
#endif
