
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	nvrecs.h
*
*	$Log:   /h/pvcs/bridge/include/nvrecs.h_v  $
 * 
 *    Rev 1.0   31 Mar 1992 18:08:36   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


#ifndef __NVRECS_H
#define __NVRECS_H v100


#ifndef __NVRAM_H
#include <nvram.h>
#endif

#ifndef __MEMORY_H
#include <memory.h>
#endif

#include <filter.h>
#include <prcadr.h>
#include <bitmask.h>
#include <log.h>
#define NVRAM_HDR_ADDR	NVRAM
/*
#define NVRAM_HDR_SIZE  ALIGN(sizeof(NVRAM_HDR),2)
**/

#define	TRAP_MANAGER_NO		2 /* we support this many trap managers */

#ifdef __FDDI_CON
typedef struct nvr_boot
	{
	int	nvr_boot_marker;
	in_name	nvr_IP;
	in_name nvr_ServerIP;
	in_name	nvr_NetMask;
	in_name nvr_RouterIP[2];
	ushort	nvr_hubid;
	ushort	nvr_slotid;
	ushort	nvr_oldhubid;
	ushort	nvr_oldslotid;
	char	nvr_request_file[64];
	char	nvr_image_file[64];
	char	nvr_config_file[64];
	int	nvr_OffsetGMT;			/* offset(seconds) of local  */
						/* time to GMT */
	in_name	nvr_TimeServer;
	in_name	nvr_BootpServer;
	char	nvr_BurnDate[8];		/* the date and time of last */
	char	nvr_BurnTime[8];		/* software was updated and */
						/* burned into the flash */
	ushort	nvr_BurnCycles;			/* how many times the flash */
						/* has been programmed */

	/*
	* the following values override the DIP switch if they are set
	* a -1 == value has not been set, use the DIP switch setting
	*/
	short	nvr_tty_baud;			/* tty baud rate */
	short	nvr_ring_number;		/* hub ring number */
#define MAX_RING_NUMBER	0xf
	short	nvr_ring_rate;			/* hub ring speed */
						/* 0 = 16 megabit */
						/* 1 = 4 megabit */
	short	nvr_save_mode_type;		/* previous value of mode type*/
	short	nvr_mode_type;			/* automatic startup type */
						/* 0 = load and exec flash */
						/* 1 = load and exec network */
						/* 3 = load from network */
						/*     burn flash */
						/*     load and exec flash */
	short	nvr_bootp_request;		/* 0 = send bootp at startup */
	short	nvr_bootp_error;
	short	nvr_debug;

	word	nvr_reset_cause;		/* reset type, 0-pwrup, */
						/* 1 - single, 2 - extended */
						/* ff - software */
	short	nvr_max_reset_level;		/* 1 .. 4 as demanded by init
						/* command */
	short	nvr_reset_level;		/* count times reset pushed */

	ushort	SNMPAuthentication;		/* none (1) community (4) */
	short	sysAdmAccess;
	in_name	SnmpMgr[TRAP_MANAGER_NO];
	uint	GenericTrap[TRAP_MANAGER_NO];
	uint	SpecificTrap[TRAP_MANAGER_NO];
	char	sysDescription[64];
	char	sysLocation[64];
	char	sysName[64];
	char	sysContact[64];
	char	systemPassword[16];

	char	nvr_flash_file[64];
	short	nvr_tty_parity;			/* tty parity	 */
	short	nvr_tty_data_length;		/* tty char size */
	short	nvr_tty_stop_bits;		/* tty stop bits */
	short	nvr_last_reset_cause;
	short	nvr_last_reset_level;
	short	nvr_reset_processed;
	short	nvr_bootp_media;
	short	nvr_spare_1;

	char	nvr_tty_prompt[32];		/* console prompt*/
	short	nvr_spare[240];			/* Need to keep this *accurate* or
						   the NVR_PORT stuff breaks... */
	/*
	* the last 16 bits is the checksum of the whole structure
	*/
	ushort	nvr_checksum;			/* nvram record ends here */
	} NVR_BOOT;

extern	NVR_BOOT	nvr_boot_rec;
#define BOOT_MARKER	0x544F4F42

#define MAX_TOTAL_PORT 	(32)

typedef struct nvr_Port {
	int	nvr_port_marker;
#ifdef notdef		/* GJS */
	NVR_PORT_REC	port_rec[MAX_TOTAL_PORT+1];
	ushort	ringBeaconRate;
	ushort	ringBeaconInterval;
	ushort	ringBeaconRisingEvent;
	ushort	ringBeaconFallingEvent;
	ushort	fillerl[28];			/* Space for TRC Global stuff */ 
#endif			/* GJS */
	ushort	nvr_port_checksum;			/* nvram record ends here */
} NVR_PORT ;

extern	NVR_PORT	nvr_port;

#define PORT_MARKER	~BOOT_MARKER

#define NVR_PORT_ADDR	(NVRAM_HDR_ADDR + NVRAM_HDR_SIZE)
#define NVR_PORT_SIZE	ALIGN(sizeof(NVR_PORT), 2) 

#define NVR_BOOT_ADDR	(NVR_PORT_ADDR + NVR_PORT_SIZE)
#define NVR_BOOT_SIZE	ALIGN(sizeof(NVR_BOOT), 2)


#   include "nvrfddi.h"   /* FDDI NVR Records */
#endif   /* __FDDI_CON */

/* The other fddi records are allocated after the 'NVR_BOOT' record 
	and before the 'NVR_SYS' record (in nvrfddi.h) */
/* this is the first record after the fddi records. We leave room
	for the fddi area to grow w/o having to change these definitions
	(so this code doesn't have to know about the fddi structures) */

typedef struct nvram_sys
{
	word nvr_reset;		/* reset type, 0-pwrup, 1 - single, 2 - extended */
	short nvr_notused;  /* ff - software */
	uint pad[16];
	short nvr_checksum;
}NVR_SYS;

#define FDDI_NVAREA_SIZE	equ	0x1000		/* 4k allocated for fddi area */
#define NVR_SYS_ADDR	FDDI_NVAREA_SIZE
#define NVR_SYS_SIZE	ALIGN(sizeof(NVR_SYS),2)




typedef struct nvram_bstatus
{
	/*	NVRAM Bridge Status definition  */

		/* UNDER FILTERING GROUP */
   unsigned int	UnkMCast;         /* Unknown multi-cast for each port */
   unsigned int	UnkUCast;         /* Unknown uni-cast for each port   */
   unsigned int	RestrictInMCast;  /* Restrict inbound for each prt multi-cast*/
   unsigned int	RestrictInUCast;  /* Restrict inbound for each port uni-cast */
   unsigned int RestrictOutbound; /* Restrict outbound */
   unsigned int FilterMode;       /* Protocol filter mode, block or permit */
   unsigned int ProtFilter;		  /* Protocol filtering enabled or disabled */
   unsigned int PFilterList[PROTNUM];	/* Prot filtering list for each port */
   unsigned int BFilterMode;      /* Bitmask filter mode, block or permit */

		/* UNDER CONTROL GROUP */
   unsigned int StpMode;			/* Stp mode, enabled or disabled */
   unsigned int	PortState;			/* Port state of each port ena or dis */
   unsigned int	Learning;			/* Learning state of bridge for each port */
   unsigned int	PacketSize;			/* Packet size of bridge for each port  */
   unsigned int	TxThreshhold[5];	/* Skip index 0, tx threshhold start */
									/* from 1 to 5 for five ports	*/
   unsigned int	RxThreshhold;	    /* Skip index 0, rx threshhold start */
									/* from 1 to 5 for five ports	*/
		/* UNDER STP GROUP */

	uint	priority[4];
	uint	HelloTime;					/* hello time for bridge */
	uint	MaxAge;						/* max age for bridge 	*/
	uint	ForwardDelay;				/* forward delay for bridge */
	uint	BridgePriority;				/* bridge's priority	*/
	uint	PathCost[4];

        /* UNDER SNMP GROUP */
   char	 Name[60];					/* Name description of this bridge */
   char	 Location[60];				/* Location description of this bridge */
   char	 Contact[60];				/* Contact description for this bridge */
   uint	 SNMPAuthentication;  
   char	 ConsolePassword[12];	   /* Console passwd is stored 1's complement */
   char  SNMPPassword[12];			/* SNMP passwd is stored 1's complement */
   unsigned long SnmpMgr[4]; 		/* Alarm managers */
   unsigned long GenericTrap[4];	/* Generic traps assoc with alrm manager */
   unsigned long SpecificTrap[4];	/* Enterprise traps */
   unsigned long Routers[4];

   BMDEFINE     BMElement[10];		/* Store bit mask elements from 'a' - 'j' */
   BMEXPRESSION	BMExpression[5];	/* Bit mask expression for each port	*/
	
   unsigned int TimeOut;            /* Console Timeout value */
   unsigned int TermType;			/* Terminal Type: 0->none dec, 1->vt100 */
   unsigned int	Miscellaneous;		/* Misc. bit flg under MISCELLANEOUS grp */
   unsigned int Padding[100];		/* Place saver for later use. */
   ushort	nvr_checksum;			/* Place holder for the checksum */
}NVR_BSTATUS;

#define NVR_BSTATUS_ADDR	(NVR_SYS_ADDR + NVR_SYS_SIZE)
#define NVR_BSTATUS_SIZE	ALIGN(sizeof(NVR_BSTATUS), 2)



typedef struct nvram_nid_recs
{
	ADR     nvr_nids[800];
	ADR	    nvr_pad[200];
	ushort	nvr_checksum;
} NVR_NID_RECS;

#define NVR_NID_RECS_ADDR	(NVR_BSTATUS_ADDR + NVR_BSTATUS_SIZE)
#define NVR_NID_RECS_SIZE	ALIGN(sizeof(NVR_NID_RECS), 2)



typedef struct nvram_protocols
{
		UDPDIR	nvr_udpdir[10];
		UDPDIR  nvr_pad[10];
		ushort	nvr_checksum;
} NVR_PROTOCOLS;


#define NVR_PROTOCOLS_ADDR	(NVR_NID_RECS_ADDR + NVR_NID_RECS_SIZE)
#define NVR_PROTOCOLS_SIZE	ALIGN(sizeof(NVR_PROTOCOLS), 2)

typedef struct nvram_rstlog {

		RESETLOG nvr_resetlog;
		RESETLOG nvr_pad[8];
		ushort   nvr_checksum;
} NVR_RESETLOG;

#define NVR_RESETLOG_ADDR	(NVR_PROTOCOLS_ADDR + NVR_PROTOCOLS_SIZE)
#define NVR_RESETLOG_SIZE	ALIGN(sizeof(NVR_RESETLOG), 2)


extern	NVR_BSTATUS	*BridgeStatus;
extern	NVR_NID_RECS	*NvramNids;
extern	NVR_RESETLOG	*RstLog;
extern	NVR_SYS	nvr_sys;	

#endif
