
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	sys.h
*
*	$Log:   /shasta/pvcs/trc/include/sys.h_v  $
 * 
 *    Rev 1.5   09 Dec 1992 09:35:58   holeman
 * 
 *    Rev 1.4   23 Nov 1992 09:52:48   holeman
 * 
 *    Rev 1.3   26 Oct 1992 12:15:30   holeman
 * 
 *    Rev 1.2   04 Sep 1992 13:57:16   holeman
 * 
 *    Rev 1.1   15 Jul 1992 10:22:48   holeman
 * 
 *    Rev 1.0   01 Jul 1992 11:10:12   holeman
 * initial release
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __SYS_H
#define __SYS_H

#include <target.h>
#include <dbd.h>

typedef struct sys_area
{
	char *sys_sram_alc_lo;
	char *sys_sram_alc_hi;
	char *sys_dram_alc_lo;
	char *sys_dram_alc_hi;
	word sys_switch;
	word sys_ledb;
	word sys_flk_ledb;
	word sys_flk_cnt;
	word sys_seven_segment_display;
	word sys_ctrl;
	word sys_ctrl1;
	word sys_ctrl2;
	int sys_baud;
	int sys_wdt_enable;
	word sys_remote_console;
	NID  sys_nid[MAX_PORTS];
	word sys_lreset;
	word sys_extend;
} SYS;

/* control 1 port bit definitions */
#define LR_MSK		0x0f

#define CTRL1_LR0	0x01
#define ENABLE_LR0		CTRL1_LR0
#define DISABLE_LR0		0

#define CTRL1_LR1	0x02
#define ENABLE_LR1	CTRL1_LR1
#define DISABLE_LR1	0

#define CTRL1_LR2	0x04
#define ENABLE_LR2	CTRL1_LR2
#define DISABLE_LR2	0

#define CTRL1_LR3	0x08
#define ENABLE_LR3	CTRL1_LR3
#define DISABLE_LR3	0

#define CTRL1_ETHER	0x10
#define ENABLE_THINET	CTRL1_ETHER
#define DISABLE_THINET	0

#define CTRL1_NVR 	0x20
#define DISABLE_NVR	CTRL1_NVR
#define ENABLE_NVR	0

#define CTRL1_SYS_WDT 	0x40
#define ENABLE_SYS_WDT	CTRL1_SYS_WDT
#define DISABLE_SYS_WDT	0

#define CTRL1_BUS_WDT 	0x80
#define DISABLE_BUS_WDT	CTRL1_BUS_WDT
#define ENABLE_BUS_WDT	0

#define CTRL1_EEPROM 	0x100
#define DISABLE_EEPROM	CTRL1_EEPROM
#define ENABLE_EEPROM	0

/* control 2 port bit definitions */
#define CTRL2_FLASH_VOLTAGE	0x01
#define FLASH_PROG_VOLTAGE	CTRL2_FLASH_VOLTAGE
#define FLASH_NORMAL_VOLTAGE	0

#define CTRL2_DRAM_SIZE		0x02
#define DRAM_SIZE_4M		CTRL2_DRAM_SIZE
#define DRAM_SIZE_1M		0

extern SYS sys;


#endif
