
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	target.h
*
*	$Log:   /user/pvcs/trc/include/target.h_v  $
 * 
 *    Rev 1.3   14 Apr 1993 19:10:00   nayan
 * added #define MAX_PORTS  for FDDI Con.
 * 
 *    Rev 1.2   02 Mar 1993 14:10:10   holeman
 * change MAX_PORTS from 8 to 1
 * 
 *    Rev 1.1   29 Aug 1992 15:31:54   shaun
 * lsh Aug/29/92 Move #endif of STANLEY above #define APPL_KRNL.
 * 
 *    Rev 1.0   01 Jul 1992 11:10:14   holeman
 * initial release
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __TARGET_H
#define	__TARGET_H

#ifdef __TRC
#define	MAX_PORTS	1	/* we can support up to this # of ports	*/
#endif

/*
 * specifies number of buffers required to store NIDs.
 * For FDDI Con we have Mac Addr 1, Mac Addr 2 
 * and SMT Station Mac Addr. 
 */
#ifdef __FDDI_CON 
#define	MAX_PORTS	2
#endif

extern	int	NumberOfSonicPort; /* will be stored in here	*/

#ifdef	STANLEY

#define	SV_NMBR_PORT	4	/* number of sonic ports	*/
/* the last port (in port list)	*/
 
#define	STP_PORT_NUMBER	SV_NMBR_PORT	/* number of stp ports	*/

#define	PORT1		0x0001
#define	PORT2		0x0002
#define	PORT3		0x0004
#define	PORT4		0x0008
#define	PORT5		0x0010

#define NumberOfStpPorts	SV_NMBR_PORT
#define	STP_MODE_ENABLE		1
#define	STP_MODE_DISABLE	0

#endif	/* STANLEY	*/
/*
 *	Program to be executed by the KERNEL
 */
#define APPL_KRNL	0
#define	APPL_BRIDGE	1
#define	APPL_CONFIG	2
#define	APPL_PACKET	3
#define	APPL_TFTP	4
#define	APPL_RESET	5

typedef struct appl
	{
	int	run_appl;
	int	inited[6];
	}APPL;

#define	ADR_REC_CNT	4006	/* how many addresses in the database	*/
#define NVRADR_REC_CNT   800


#endif
