
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	tmr.h
*
*	$Log:   /usr/shasta/hub/trx/include/tmr.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 11:10:18   holeman
 * initial release
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __TMR_H
#define __TMR_H

#ifndef __MEMORY_H
#include "memory.h"
#endif /* __MEMORY_H */

#define STC_DATA_IO	(TIMERIO+0)
#define STC_CONTROL_IO	(TIMERIO+4)

/*
 * COMMAND REGISTER BIT ASSIGNMENT
 */

#define STC_C0			0x01
#define STC_C1			0x02
#define STC_C2			0x04
#define STC_C3			0x08
#define STC_C4			0x10
#define STC_C5			0x20
#define STC_C6			0x40
#define STC_C7			0x80

/*
 * Counter selection in command register - In linear select
 */

#define STC_S1			STC_C0
#define STC_S2			STC_C1
#define STC_S3			STC_C2
#define STC_S4			STC_C3
#define STC_S5			STC_C4

/*
 * Counter selection in command register - In 3-bit binary code
 */

#define STC_N1			STC_C0
#define STC_N2			STC_C1
#define STC_N4			STC_C2

#define STC_CNT1		STC_N1
#define STC_CNT2		STC_N2
#define STC_CNT3		(STC_N2 | STC_N1)
#define STC_CNT4		STC_N4
#define STC_CNT5		(STC_N4 | STC_N1)

/*
 * STC (System Timing Controller) commands
 */

#define STC_ARM_CNT		STC_C5
#define STC_LOD_CNT		STC_C6
#define STC_LOD_ARM_CNT		(STC_C6 | STC_C5)
#define STC_DISARM_CNT		(STC_C7 | STC_C6)
#define STC_SAV_CNT		(STC_C7 | STC_C5)
#define STC_DISARM_SAV_CNT	STC_C7
#define STC_SET_TC		(STC_C7 | STC_C6 | STC_C5 | STC_C3)
#define STC_CLR_TC		(STC_C7 | STC_C6 | STC_C5)
#define STC_STEP_CNT		(STC_C7 | STC_C6 | STC_C5 | STC_C4)
#define STC_LOD_DAT_PTR		0x00
#define STC_DIS_DAT_PTR		(STC_C7 | STC_C6 | STC_C5 | STC_C3)
#define STC_ENA_DAT_PTR		(STC_C7 | STC_C6 | STC_C5)
#define STC_ENA_16BIT_BUS	(STC_C7 | STC_C6 | STC_C5 | STC_C3 | STC_C2 | STC_C1 | STC_C0)
#define STC_ENA_8BIT_BUS	(STC_C7 | STC_C6 | STC_C5 | STC_C2 | STC_C1 | STC_C0)
#define STC_GATE_OFF_FOUT	(STC_C7 | STC_C6 | STC_C5 | STC_C3 | STC_C2 | STC_C1)
#define STC_GATE_ON_FOUT	(STC_C7 | STC_C6 | STC_C5 | STC_C2 | STC_C1)
#define STC_DIS_PREFCH_WRT	(STC_C7 | STC_C6 | STC_C5 | STC_C4 | STC_C3 | STC_C0)
#define STC_ENA_PREFCH_WRT	(STC_C7 | STC_C6 | STC_C5 | STC_C4 | STC_C3)
#define STC_MASTER_RESET	(STC_C7 | STC_C6 | STC_C5 | STC_C4 | STC_C3 | STC_C2 | STC_C1 | STC_C0 )


/*
 * MASTER MODE REGISTER BIT ASSIGNMENT
 */

#define STC_MM0			0x0001
#define STC_MM1			0x0002
#define STC_MM2			0x0004
#define STC_MM3			0x0008
#define STC_MM4			0x0010
#define STC_MM5			0x0020
#define STC_MM6			0x0040
#define STC_MM7			0x0080
#define STC_MM8			0x0100
#define STC_MM9			0x0200
#define STC_MM10		0x0400
#define STC_MM11		0x0800
#define STC_MM12		0x1000
#define STC_MM13		0x2000
#define STC_MM14		0x4000
#define STC_MM15		0x8000

/*
 * FOUT Divider
 */

#define STC_DIV16		0x0000
#define STC_DIV1		STC_MM8
#define STC_DIV2		STC_MM9
#define STC_DIV3		(STC_MM9 | STC_MM8)
#define STC_DIV4		STC_MM10
#define STC_DIV5		(STC_MM10 | STC_MM8)
#define STC_DIV6		(STC_MM10 | STC_MM9)
#define STC_DIV7		(STC_MM10 | STC_MM9 | STC_MM8)
#define STC_DIV8		STC_MM11
#define STC_DIV9		(STC_MM11 | STC_MM8)
#define STC_DIV10		(STC_MM11 | STC_MM9 )
#define STC_DIV11		(STC_MM11 | STC_MM9 | STC_MM8)
#define STC_DIV12		(STC_MM11 | STC_MM10)
#define STC_DIV13		(STC_MM11 | STC_MM10 | STC_MM8)
#define STC_DIV14		(STC_MM11 | STC_MM10 | STC_MM9)
#define STC_DIV15		(STC_MM11 | STC_MM10 | STC_MM9 | STC_MM8)


/*
 * FOUT Source
 */

#define STC_MM_E1		0x0000
#define STC_MM_SRC1		STC_MM4
#define STC_MM_SRC2		STC_MM5
#define STC_MM_SRC3		(STC_MM5 | STC_MM4)
#define STC_MM_SRC4		STC_MM6
#define STC_MM_SRC5		(STC_MM6 | STC_MM4)
#define STC_MM_GATE1		(STC_MM6 | STC_MM5)
#define STC_MM_GATE2		(STC_MM6 | STC_MM5 | STC_MM4)
#define STC_MM_GATE3		STC_MM7
#define STC_MM_GATE4		(STC_MM7 | STC_MM4)
#define STC_MM_GATE5		(STC_MM7 | STC_MM5 )
#define STC_MM_F1		(STC_MM7 | STC_MM5 | STC_MM4)
#define STC_MM_F2		(STC_MM7 | STC_MM6)
#define STC_MM_F3		(STC_MM7 | STC_MM6 | STC_MM4)
#define STC_MM_F4		(STC_MM7 | STC_MM6 | STC_MM5)
#define STC_MM_F5		(STC_MM7 | STC_MM6 | STC_MM5 | STC_MM4)

/*
 * Misc
 */

#define STC_TOD_DSA		0x0000
#define STC_TOD_ENA_DIV5	STC_MM0
#define STC_TOD_ENA_DIV6	STC_MM1
#define STC_TOD_ENA_DIV10	(STC_MM1 | STC_MM0)

#define STC_CMP1_ENA		STC_MM2
#define STC_CMP2_ENA		STC_MM3

#define STC_FOUT_OFF		STC_MM12
#define STC_16BIT_BUS		STC_MM13
#define STC_DSA_INC 		STC_MM14
#define STC_BCD_DIV		STC_MM15

/*
 * COUNTER MODE REGISTER BIT ASSIGNMENT
 */

#define STC_CM0			0x0001
#define STC_CM1			0x0002
#define STC_CM2			0x0004
#define STC_CM3			0x0008
#define STC_CM4			0x0010
#define STC_CM5			0x0020
#define STC_CM6			0x0040
#define STC_CM7			0x0080
#define STC_CM8			0x0100
#define STC_CM9			0x0200
#define STC_CM10		0x0400
#define STC_CM11		0x0800
#define STC_CM12		0x1000
#define STC_CM13		0x2000
#define STC_CM14		0x4000
#define STC_CM15		0x8000


/*
 * COUNT source selection
 */

#define STC_CM_TCN_1		0x0000
#define STC_CM_SRC1		STC_CM8
#define STC_CM_SRC2		STC_CM9
#define STC_CM_SRC3		(STC_CM9 | STC_CM8)
#define STC_CM_SRC4		STC_CM10
#define STC_CM_SRC5		(STC_CM10 | STC_CM8)
#define STC_CM_GATE1		(STC_CM10 | STC_CM9)
#define STC_CM_GATE2		(STC_CM10 | STC_CM9 | STC_CM8)
#define STC_CM_GATE3		STC_CM11
#define STC_CM_GATE4		(STC_CM11 | STC_CM8)
#define STC_CM_GATE5		(STC_CM11 | STC_CM9 )
#define STC_CM_F1		(STC_CM11 | STC_CM9 | STC_CM8)
#define STC_CM_F2		(STC_CM11 | STC_CM10)
#define STC_CM_F3		(STC_CM11 | STC_CM10 | STC_CM8)
#define STC_CM_F4		(STC_CM11 | STC_CM10 | STC_CM9)
#define STC_CM_F5		(STC_CM11 | STC_CM10 | STC_CM9 | STC_CM8)

/*
 * GATING control
 */

#define STC_NO_GATING		0x0000
#define STC_ACT_HI_TCN_1	STC_CM13
#define STC_ACT_HI_LVL_N1	STC_CM14
#define STC_ACT_HI_LVL_N_1	(STC_CM14 | STC_CM13)
#define STC_ACT_HI_LVL_N	STC_CM15
#define STC_ACT_LO_LVL_N	(STC_CM15 | STC_CM13)
#define STC_ACT_HI_EDG_N	(STC_CM15 | STC_CM14)
#define STC_ACT_LO_EDG_N	(STC_CM15 | STC_CM14 | STC_CM13)

/*
 * OUTPUT control
 */

#define STC_INACT_OUT_LOW	0x0000
#define STC_ACT_HI_TC_PULSE	STC_CM0
#define STC_TC_TOGGLED		STC_CM1
#define STC_INACT_OUT_HIIMP	STC_CM2
#define STC_ACT_LO_TC_PULSE	(STC_CM2 | STC_CM0)

/*
 * SOURCE edge
 */

#define STC_CNT_FAL_EDGE	STC_CM12

/*
 * COUNT Control
 */

#define STC_ENA_SP_GATE		STC_CM7
#define STC_RELOD_LOD_HLD	STC_CM6
#define STC_COUNT_REPET		STC_CM5
#define STC_BCD_COUNT		STC_CM4
#define STC_COUNT_UP		STC_CM3

/*
 * DATA POINTER REGISTER BIT ASSIGNMENT
 */

#define STC_G1 			0x01
#define STC_G2 			0x02
#define STC_G4 			0x04
#define STC_E1 			0x08
#define STC_E2 			0x10

/*
 * Group pointer
 */

#define STC_CNT_GRP1		STC_G1
#define STC_CNT_GRP2 		STC_G2
#define STC_CNT_GRP3 		(STC_G2 | STC_G1)
#define STC_CNT_GRP4 		STC_G4
#define STC_CNT_GRP5 		(STC_G4 | STC_G1)
#define STC_CTL_GRP  		(STC_G4 | STC_G2 | STC_G1)

/*
 * Element pointer
 */

#define STC_MOD_REG 		0x00
#define STC_LOD_REG 		STC_E1
#define STC_HLD_REG 		STC_E2

#define STC_HLD_REG_INC 	(STC_E2 | STC_E1)

#define STC_ALM_REG1 		0
#define STC_ALM_REG2 		STC_E1
#define STC_MST_MOD_REG 	STC_E2
#define STC_STA_REG 		(STC_E2 | STC_E1)

/*
 * STATUS REGISTER BIT ASSIGNMENT
 */

#define STC_SR0			0x01
#define STC_SR1			0x02
#define STC_SR2			0x04
#define STC_SR3			0x08
#define STC_SR4			0x10
#define STC_SR5			0x20
#define STC_SR6			0x40
#define STC_SR7			0x80

#define STC_BYTE_POINTER	STC_SR0
#define STC_OUT1		STC_SR1
#define STC_OUT2		STC_SR2
#define STC_OUT3		STC_SR3
#define STC_OUT4		STC_SR4
#define STC_OUT5		STC_SR5


#define US5_COUNT 32  /* 5 usec TC output and 10 usec TC toggled output */
#define US200_COUNT 1280  /* 200 usec TC output and 400 usec TC toggled output */
#define MS1_COUNT 6250  /* 1 msec TC output and 2 msec TC toggled output */
#define MS5_COUNT 31250 /* 5 msec TC output and 10 msec Tc toggled output */
#define HALF_KRNL_TIME_SLICE 6250
#define STC_MODE_D (STC_CNT_FAL_EDGE | STC_CM_F1 | STC_COUNT_REPET | STC_TC_TOGGLED)
#define STC_MODE_G (STC_CNT_FAL_EDGE | STC_CM_F1 | STC_RELOD_LOD_HLD | STC_TC_TOGGLED)

#endif
