/*****************************************************************
 *	Copyright (c) 1992 by Hughes LAN Systems
 *
 *	Program Name:	Token Ring Concentrator application
 *
 *	Filename:	cpb.h
 *
 *	Description: This file contains the 
 *				Token Ring Concentrator application.
 *
 *	Revision:
 *	1-000			Jul-10-92				Szewei Ju
 *		- Original, adapted from the 'stanley' bridge code.
 *
 *******************************************************************
 */

#if (!defined(cpb_inc))
#define cpb_inc

/* kw,suffix,priv_idx,svcr,branches,flag1,flag2 */
/**************************************************************************
 Definition for a Command Node
***************************************************************************/
typedef struct CMDNODE_S
{
	char 	*kw;	      /* command keyword string */
	char 	*suffix;      /* optional keyword string */
	int	priv_idx;     /* privilege table index */
	int 	(*kw_proc)(); /* command keyword service routine */
	char 	*help;	      /* command keyword help string */
	char 	*asc_node;    /* pointer to the ascendent node */
	char 	*branches;    /* pointer to descendents array */
	unsigned int flag1;   /* condition flag 1 */
	u_char flag2;	      /* condition flag 2 */
   	u_char minlen;        /* minimal length of key word */
   	u_char def_priv;      /* default manufacture priv */
	u_char dummy;         /* reserver for future use */
} CMDNODE_T;

typedef CMDNODE_T *CMDNODE_P;

/* Definition for flag1 in CMDNODE_T */
#define SKIP			0x01	
#define NOREMOTE		0x02
#define MORE        	0x04   /* can be more characteristic */
#define SKIP_ALL		0x08
#define CASE_SENSITIVE	0x10
#define MKW				0x20
#define NEED_NO_PARM	0x40
#define PARM_OPT		0x80
#define ADM_REQ_PARM	0x100
#define NON_CHAR        0x200
#define NO_SET          0x400
#define NO_DEFINE       0x800
#define NO_ADM			0x1000
#define PREFIX          0x2000   /* the suffix kw is used as prefix */
#define PROC_HELP       0x4000   /* jump into process routine even for HELP */
#define MORE_TO_COME	0x8000	 /* more keywords should follow */

/* Definition for flag2 in CMDNODE_T */
#define MINLEN_2NDKW	0x0F
#define TFTP_NEED       0x10      /* this node only shown for TFTP prom */
/**************************************************************************
 Definition for a Command Process Block 
***************************************************************************/
#define PARAMAX		128	

typedef	struct CPB_S
{
	u_char	operation;	/* 1-help, 2-set priv */
	byte    access;         /* priv level of requetor */
	byte    cmdlen;           /* length of cmd line */
	byte 	cl_idx;		/* remaining cmd line pointer */
	byte    gen_use;	/* for general use */
	byte    flags;	        /* cmd processing flags */
	byte    inputlen;       /* max input len */
	char 	*cmd;             /* pointer to cmd line */
	CMDNODE_P node;		/* current node pointer */
	char  	parmptr[PARAMAX]; /* parameter pointer */
} CPB_T;

typedef CPB_T *CPB_P;

/* Definition for operation in CPB_T */
#define FSET         1     /* set but not update in NVRAM */
#define FDEFINE      2     /* define, set and update NVRAM */
#define FSHOW        3     /* show something */
#define FREMOVE      4     /* remove but not from NVRAM */
#define FPURGE       5     /* purge from NVRAM */ 
#define FCLEAR		 6	   /* Clear from dynamic RAM only */
#define FHELP        7     /* help operation */

/* Definition for flags in CPB_T */
#define	NO_KW               0x01	/* bit 0 */
#define MULTI_CHAR			0x02    /* bit 1 */
#define REMOTE_CMD	 	    0x04	/* bit 2 indication of remote cmd */

/*   define help template in the parmptr */
struct help_struct {
      byte   count;
      CMDNODE_P node[15];
};

typedef struct help_struct *HELP_P;

/* Define the parameter template */
/*
struct DIR_S	 75 bytes 
{
	char 	user[NAMEMAX+1];
	DIR 	dir1;
} DIR_T;
*/

#define CASE_INSENSITIVE	0x1
#define EOTXT				0x40		/* @ */

#define MIN_PAR_SZ	2	/* Minimum no of chars in parameter */
#endif

