/**			       
*
*	Program Name:	Admin Bus driver - FUNCARD
*
*	Filename:	funcinit.c
*
*	$Log:   /b/gregs/i960/adminbus/funcinit.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:36:12   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:19:44   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 10:13:26   gregs
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:32:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:27:30   gregs
 * Initial revision.
 * 
 *    Rev 1.3   08 Apr 1993 16:16:16   vinay
 * made changes to eliminate compilation warnings
 * for 2.2
 * 
 *    Rev 1.2   13 May 1992 10:05:30   kwok
 * Check if the IP packet comes from the admin bus is for me or not. If it
 * is for me, send it to my receive mail box.
 * 
 *    Rev 1.1   13 Apr 1992 18:34:00   kwok
 * Call the polling function adm_poll() rather than adm_isr().
 * 
 *    Rev 1.0   30 Mar 1992 16:48:52   pvcs
 * Initial revision.
*
*	Creation Date:	11.8.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	K Kong	11.8.91
*			This module contains interface functions to
*			the "user" of the admin. bus driver.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <types.h>
#if !defined(KLHR) && !defined(STTG)
#include <krnl.h>
#endif
#include <netbuf.h>
#include <ether.h>
#include <ip.h>
#include <tcpip.h>
#include <error.h>
#include <task.h>
#include <admdrv.h>

#ifdef BASE10T
#include <cmd_tbl.h>
#endif

extern	int FAR	ImmCommandHandler();

#ifdef BASE10T
extern	MBOX	ReceiveMbox;
#elif defined(KLHR) || defined(STTG)
extern MBOX	C0rcvMbox;
#else
extern	MBOX	IpReceiveMbox;
#endif


#ifdef i960
static unsigned int	adm_stack[1024];
#endif

static	int	FAR AdmIPReceiver(int slot, uint offset, uint length);
static void	adm_polling();

/*
 * name		AdmBusInit
 *
 * synopsis	AdmBusInit(AdmAdd)
 *		char	FAR *AdmAdd;	<< 	starting address of 
 *
 * description	It initialises the Admin. bus driver in a ready state.
 *		The user of the admin. bus driver have to call this
 *		function once at boot up time. 
 *		It creates the polling task to poll for any incoming
 *		command/data from the SYSCARD.
 *		It installs the handlers to handle incoming commands 
 *		and buffers.
 *
 * returns	0		OK
 *		non-zero	error code
 */

AdmBusInit(char FAR *AdmAdd)

	{
	int	status;
#ifdef BASE10T
	/*
	 *	K Kong	12.16.91
	 *	This is a quick fix to enable the external ready signal.
	 *	This should have been fixed in the BOOT prom. !!!!
	 */
	outputw(0xffa6, 0xd1f9);
#endif
	status = adm_init(AdmAdd, MAXPROT, ICMDMAX);
	if (status != 0)
		return status;
	/*
	 *	install handlers for commands
	 */
	adm_add_ImmCmdRsp(ICMD_CONS_OPEN, (int (FAR *)())ImmCommandHandler);
	adm_add_ImmCmdRsp(ICMD_CONS_CLOSE, (int (FAR *)())ImmCommandHandler);
	adm_add_ImmCmdRsp(ICMDRELAYON, (int (FAR *)())ImmCommandHandler);
	adm_add_ImmCmdRsp(ICMDRELAYOFF, (int (FAR *)())ImmCommandHandler);
	adm_add_ImmCmdRsp(ICMDCHANGEIP, (int (FAR *)())ImmCommandHandler);
	/*
	 *	install handler for IP packets
	 */
	adm_add_protocol(BUFFIP, (int (FAR *)())AdmIPReceiver);
	/*
	 *	The polling task. (for stanley only)
	 */
#if defined(KLHR) || defined(STTG)
	if (!tk_fork(tk_cur, adm_polling, 256*sizeof(int), "adm_polling", 0))
		return 99;
#elif defined(i960)
	CreatTask(adm_polling, adm_stack, 1024 * sizeof(int), 0);
#endif
	return 0;
	}

/*
 * name		adm_polling
 *
 * synopsis	adm_polling(void)
 *
 * description	This is the admin. bus driver polling task.  It polls 
 *		for any incoming commands/packets from the SYSCARD.
 *
 * returns	it never returns
 */

static void adm_polling()
	{
	int	i = 0;

	for (;;)
		{
		if (i++ > 10)
			{
			AdmUpdateAliveCounter();
			i = 0;
			}
		adm_poll(0); 
#ifdef i960
		ReSchedule();
#else
		ReSchedule(IDLE_PRIORITY);
#endif
		}
	}
/*
 * name		AdmIPReceiver
 *
 * synopsis	AdmIPReceiver(slot, offset, length)
 *		int	slot; <<	not used, must be 0
 *		int	offset; <<	from the beginning of the admin.
 *					bus shared ram where the packet is.
 *		int	length; <<	of the packet, including the 
 *					control data.
 *
 * description	This is the handler for IP packet. the polling task
 *		calls this function whenever an IP packet arrives from
 *		the SYSCARD.
 *
 * returns	0	OK
 *		non-zero	error code
 */

static FAR AdmIPReceiver(int slot, uint offset, uint length)
	{
	ADMB	AdmBuf;
	PACKET	dp;
	struct	ip FAR	*pip;		/*	the ip packet	*/
	in_name	ip_dest;
	in_name	ip_src;
	in_name	firsthop;
	in_name	*hp = NULL;
	NID	*np = NULL;

#ifdef ADM_DEBUG
	AdmDebugMessage("receive adm ip buffer %d bytes\n", length);
#endif
	if ((dp = (PACKET)snc_get_dbd()) == NULL)
		{
		/*
		 *	run out of dbd buffer,
		 *	we have to throw away the packet.
		 */
		return 1;
		}
	/*
	 *	get the buffer control data.
	 */
	adm_read(0, offset, sizeof(AdmBuf), (char FAR*)&AdmBuf);
	dp->nb_flags = 0;	/* we send ethernet packet	*/
	dp->db_actcnt = length - ((char*)&AdmBuf.bufData[0] - (char*)&AdmBuf);
	dp->nb_len = dp->db_actcnt;
#if defined(KLHR) || defined(STTG)
	dp->nb_prot = dp->nb_buff + MAXLNH;
#else
	dp->nb_prot = dp->db_buffer + MAXLNH;
#endif
/***
	dp->db_rcvportno = 0;
****/
	adm_read(0, offset + (length - dp->db_actcnt), 
		dp->db_actcnt, (char FAR *)dp->nb_prot);
	pip = (struct ip FAR *)dp->nb_prot;
#ifdef i960
	ipcopy(&ip_dest, &pip->ip_dest);
	ipcopy(&ip_src, &pip->ip_src);
#else
	ip_dest = pip->ip_dest;
	ip_src = pip->ip_src;
#endif
	if (ip_dest == -1 || (ip_dest | _initp->net_mask) == -1 || 
		_initp->in_me == ip_dest)
		{
		/*
		 *	This is a broadcast ip packet.
		 *	5.12.92	K Kong
		 *	or it is for me.
		 */
		if (ip_src == 0 || _initp->in_me == ip_dest)
			{
			/*	
			 *	If the source ip is 0, then this is
			 *	the BOOTP request from the SYSCARD.
			 *	We send it to our stack to handle it.
			 */
			dp->nb_flags |= PKT_ADMIN;
#ifdef BASE10T
		        dp->db_rcvprt = ADMIN_BUS_PORT;
			ISendMessage((MSGHDR FAR *)dp, &ReceiveMbox);
#elif defined(i960)
			SendMessage((MSGHDR *)dp, &IpReceiveMbox);
#else	/* KLHR or STTG	*/
			ISendMessage((MSGHDR*)dp, &C0rcvMbox);
#endif
			return 0;
			}
		else
			{
			/*
			 *	otherwise send it to the network.
			 */
			hp = &ip_dest;
			np = (NID *)ETBROADCAST;
			}
		}
	if (hp != NULL)
		firsthop = *hp;
#ifndef i960
	else if (inroute(ip_dest, &firsthop)) 
#else
	else if (inroute(ip_dest, _initp->in_me, &firsthop))
#endif
		{
		snc_put_dbd(dp);
#ifdef ADM_DEBUG
		AdmDebugMessage("sending ip packet for the SYSCARD - FAILED\n");
#endif
		return ERR_NET_UNREACHABLE;
		}
#ifdef ADM_DEBUG
	AdmDebugMessage("sending ip packet for the SYSCARD\n");
#endif
	et_ip_send(dp, dp->nb_len, firsthop, np, ip_src);
	snc_put_dbd(dp);
	return 0;
	}
/*
 *	For debugging on the 10baseT card
 */
AdmDebugMessage(char *format, int a, int b, int c)

	{
#ifdef BASE10T
	if (adm.tag->tn != NULL)
		oprintf((word)adm.tag->tn, format, a, b, c);
#else
	printf(format, a, b, c);
#endif
	}


