/**			       
*
*	Program Name:	IP Relayer for the Admin. bus
*
*	Filename:	relayer.c
*
*	$Log:   /b/gregs/i960/adminbus/relayer.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:36:14   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:19:46   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 10:13:30   gregs
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:32:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:27:32   gregs
 * Initial revision.
 * 
 *    Rev 1.2   15 May 1992 13:56:14   kwok
 * remove a debugging message.
 * 
 *    Rev 1.1   13 May 1992 10:06:38   kwok
 * 
 *    Rev 1.0   30 Mar 1992 16:48:52   pvcs
 * Initial revision.
*
*	Creation Date:	11.12.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	K Kong	11.12.91
*			This contains the relayer support functions for the 
*			SYSCARD. 
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <types.h>
#if !defined(KLHR) && !defined(STTG)
#include <krnl.h>
#endif
#include <netbuf.h>
#include <tcpip.h>
#include <admdrv.h>

/*
 * name		IsSyscardIP
 *
 * synopsis	IsSyscardIP(ip)
 *		in_name	ip;	<<	Is this the ip of the SYSCARD
 *
 * description	It checks if "ip" is the SYSCARD's ip. This function is
 *		to be used when an ARP request has been received and
 *		the ip is not my ip. We want to send an ARP reply if the
 *		ip is the SYSCARD's ip and I am the relayer.
 *
 * returns	0	-	ip is NOT the SYSCARD's ip
 *		otherwise	ip is the SYSCARD's ip
 */

IsSyscardIP(in_name ip)

	{
	/*
	 *	return 1 if I am the relayer for the syscard and
	 *	the ip is the syscard ip.
	 */
	return (_initp->relayer != 0 && ip == _initp->syscard);
	}

/*
 * name		IsAdminPort
 *
 * synopsis	IsAdminPort(p, ip_dest)
 *		PACKET	p; <<	the packet received.
 *		in_name	ip_dest; << the destination ip of the packet "p".
 *
 * description	An IP packet has been received and it is not me.
 *		The packet will be passed to this function to see if
 *		the packet is for the SYSCARD.
 *		If it is for the SYSCARD, the packet will be sent to
 *		the SYSCARD via the admin. bus.
 *
 * returns	0	packet "p" is not for the SYSCARD.
 *		otherwise, the packet has been routed to the SYSCARD via
 *		the admin bus.
 */

IsAdminPort(PACKET p, in_name ip_dest)

	{
	int	ret = 0;
	int	status;
	ADMB	FAR * AdmBuf = NULL;

	/*
	 *	return 0 if I am NOT the relayer.
	 */
	if (_initp->relayer == 0)
		return ret;
	if (ip_dest == _initp->syscard || _initp->syscard == 0)
		{
		/*
		 *	The packet is for the syscard.
		 *	We have to relay it to the admin. bus.
		 */
		/*
		 *	Adjust AdmBuf such that there are enough 
		 *	space in front of the ip packet for use to
		 *	put the "ADMB" control data - bufFormat, bufLength.
		 */
		AdmBuf = (ADMB FAR *)((char FAR *)p->nb_prot - 
			((char *)&AdmBuf->bufData[0] - (char *)AdmBuf));
		/*
		 *	This is an IP packet.
		 */
		AdmBuf->bufFormat = BUFFIP;
		AdmBuf->bufLength = p->nb_len + 
			((char *)&AdmBuf->bufData[0] - (char *)AdmBuf);

		status = adm_send(0, (char FAR *)AdmBuf, AdmBuf->bufLength);
#ifdef ADM_DEBUG
		AdmDebugMessage("Sending buffer to the admin bus %d bytes(len = %d)", 
			AdmBuf->bufLength, p->nb_len);
		if (status == 0)
			AdmDebugMessage(" OK \n");
		else
			AdmDebugMessage(" FAILED \n");
#endif
		ret = !status;
#ifdef BASE10T
		snc_put_dbd(p);
#endif
		}
	return ret;
	}
