/*--------------------------------------------------------------------------
 * Definitions for SCC 85Z30 write registers.
 *--------------------------------------------------------------------------
 */
#define	WR0	0x00	/* Write Reg 0 */
#define	WR1	0x01	/* Write Reg 1 */
#define	WR2	0x02	/* Write Reg 2 */
#define	WR3	0x03	/* Write Reg 3 */
#define	WR4	0x04	/* Write Reg 4 */
#define	WR5	0x05	/* Write Reg 5 */
#define	WR6	0x06	/* Write Reg 6 */
#define	WR7	0x07	/* Write Reg 7 */
#define	WR8	0x08	/* Write Reg 8 */
#define	WR9	0x09	/* Write Reg 9 */
#define	WR10	0x0a	/* Write Reg 10*/
#define	WR11	0x0b	/* Write Reg 11*/
#define	WR12	0x0c	/* Write Reg 12*/
#define	WR13	0x0d	/* Write Reg 13*/
#define	WR14	0x0e	/* Write Reg 14*/
#define	WR15	0x0f	/* Write Reg 15*/

/*--------------------------------------------------------------------------
 * Definitions for SCC 85Z30 read registers.
 *--------------------------------------------------------------------------
 */
#define	RR0	0x00	/* Read Reg 0 */
#define	RR1	0x01	/* Read Reg 1 */
#define	RR2	0x02	/* Read Reg 2 */
#define	RR3	0x03	/* Read Reg 3 */
#define	RR4	0x04	/* Read Reg 4 */
#define	RR5	0x05	/* Read Reg 5 */
#define	RR6	0x06	/* Read Reg 6 */
#define	RR7	0x07	/* Read Reg 7 */
#define	RR8	0x08	/* Read Reg 8 */
#define	RR9	0x09	/* Read Reg 9 */
#define	RR10	0x0a	/* Read Reg 10*/
#define	RR11	0x0b	/* Read Reg 11*/
#define	RR12	0x0c	/* Read Reg 12*/
#define	RR13	0x0d	/* Read Reg 13*/
#define	RR14	0x0e	/* Read Reg 14*/
#define	RR15	0x0f	/* Read Reg 15*/

/*--------------------------------------------------------------------------
 * Bit definitions for Read register 0.
 *--------------------------------------------------------------------------
 */
#define	TX_EOM		0x40	/* RR0 Tx UR/EOM		*/
#define	DCD		0x08	/* RR0 DCD bit			*/
#define	TX_BE		0x04	/* RR0 Tx buffer empty bit	*/
#define	ZERO_COUNT	0x02	/* RR0 Zero count		*/

/*--------------------------------------------------------------------------
 * Bit definitions for Read register 1.
 *--------------------------------------------------------------------------
 */
#define	CRC_ERR		0x40	/* RR1 Receive CRC error	*/
#define	RX_OVR		0x20	/* RR1 Receive overrun error	*/
#define	RESIDUE		0x0e	/* RR1 Correct residue value	*/

/*--------------------------------------------------------------------------
 * Bit definitions for Read register 3.
 *--------------------------------------------------------------------------
 */
#define	CHA_EXT_IP	0x08	/* RR3 Ch A ext int pending	*/
#define	CHA_TX_IP	0x10	/* RR3 Ch A xmt int pending	*/
#define	CHA_RX_IP	0x20	/* RR3 Ch A cvt int pending	*/

/*--------------------------------------------------------------------------
 * Bit definitions for Read register 7.
 *--------------------------------------------------------------------------
 */
#define FIFO_OVRUN      0x80    /* RR7 Status FIFO overrun bit  */
#define FRAME_AVAIL     0x40    /* RR7 Frame available bit      */

/*--------------------------------------------------------------------------
 * Bit definitions for Write register 0.
 *--------------------------------------------------------------------------
 */
#define	RST_TXEOM	0xc0	/* WR0 Reset tx underrun/EOM	*/
#define	RST_TXCRC	0x80	/* WR0 Reset tx CRC gen.	*/

/*--------------------------------------------------------------------------
 * Bit definitions for Write register 1.
 *--------------------------------------------------------------------------
 */
#define	DMA_REQ_ENB	0x80	/* WR1 DMA Request enable	*/
#define	DMA_REQ_FUNC	0x40	/* WR1 DMA Request function	*/
#define	DMA_REQ_RCV	0x20	/* WR1 DMA Request on receive	*/
#define	TX_INT_ENB	0x02	/* WR1 Xmt interrupt enable	*/
#define	EXT_INT_ENB	0x01	/* WR1 Ext interrupt enable	*/

/*--------------------------------------------------------------------------
 * Bit definitions for Write register 3.
 *--------------------------------------------------------------------------
 */
#define	RX_8BIT		0xc0	/* WR3 Rx 8 bits per char	*/
#define	HUNT_MODE	0x10	/* WR3 Enter Hunt Mode		*/
#define	RX_CRC		0x08	/* WR3 Rx CRC enable		*/
#define	SRCH_MODE	0x04	/* WR3 Address Search Mode	*/
#define	RX_ENABLE	0x01	/* WR3 Rx Enable		*/

/*--------------------------------------------------------------------------
 * Bit definitions for Write register 5.
 *--------------------------------------------------------------------------
 */
#define	DTR		0x80	/* WR5 DTR 			*/
#define	TX_8BIT		0x60	/* WR5 Tx 8 bits per char	*/
#define	TX_ENABLE	0x08	/* WR5 Tx enable		*/
#define	RTS		0x02	/* WR5 RTS			*/
#define	TX_CRC		0x01	/* WR5 Tx CRC enable		*/

/*--------------------------------------------------------------------------
 * Bit definitions for Write register 15.
 *--------------------------------------------------------------------------
 */
#define	TX_EOM_IE	0x40	/* WR15 Tx UR/EOM Int enable	*/
#define	ZC_IE		0x02	/* WR15 zero count Int enable	*/

#define	REQ_FUNC	0x04	/* WR14 Request on TxBE	*/

typedef struct
{
	word	xmt_byte_count;			/* total bytes xmted	*/
	word	xmt_collisions;			/* xmt collision count	*/
	word	xmt_no_bd_error;		/* no buffer descriptor */
	word	rcv_byte_count;			/* total bytes rcved	*/
	word	rcv_crc_error;			/* rcv crc error count	*/
	word	rcv_residue_error;		/* rcv residue error	*/
	word	rcv_overrun_error;		/* rcv overrun error	*/
	word	rcv_status_fifo_overrun;	/* status fifo overrun	*/
	word	rcv_no_bd_error;		/* no buffer descriptor */
}	SCC_INFO;
