/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#if (!defined(buffer_inc))
#define buffer_inc

#if (!defined(asn1_inc))
#include "asn1.h"
#endif

/* The EBUFFER_T structure is used to control encoding into a buffer	*/
typedef struct EBUFFER_S
{
	unsigned short bflag;
	/* 0 - buffer is not allocated from the pool*/
	/* 1 - buffer is allocated from the pool */
	OCTET_P     start_bp;	/* Start of the buffer.			    */
	OCTET_P     next_bp;   /* Next location in buffer to be filled     */
	ALENGTH_T    remaining; /* Number of empty spots remaining in buffer*/
} EBUFFER_T;

typedef EBUFFER_T  *EBUFFER_P;
#define    NOT_POOL_BFL  0
#define    POOL_BFL      1

extern  void EBufferSetup(EBUFFER_P,OCTET_P,ALENGTH_T);

extern  void EBufferPreLoad(EBUFFER_P,OCTET_P,ALENGTH_T,ALENGTH_T);

extern  ALENGTH_T EBufferUsed(EBUFFER_P);


#endif	/* buffer_inc */
