
/**
 *	Filename:	dbd.h	
 *
 *	$Log:   /b/gregs/i960/include/dbd.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:43:26   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:22:00   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:22:06   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:40:44   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:37:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:28:14   gregs
 * Initial revision.
 * 
 *    Rev 1.1   15 Apr 1992 21:02:28   kwok
 * Adding a new field in the DBD structure.
 *
 *	Comments:	The DBD data structure.
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#ifndef __DBD_H
#define __DBD_H 0x100a	/* V1.00a */

#ifndef __TYPES_H
#include "types.h"
#endif

struct dbd 
	{            /* data buffer descriptor */
	struct dbd *db_nxtpkt;	/* Used for chaining DBDs by application */
	word   db_idmark;		/* for marking this as a DBD */
	struct dbd *db_nxtdbd;	/* for chaining purposes (used by driver) */
	word   db_bufsiz;		/* buffer size */
	byte  *db_buffer;		/* pointer to buffer */
	word   db_actcnt;		/* number bytes in buffer */
	word   db_indent;		/* logical start of buffer */
	word   db_contrl;		/* buffer control and flags */
	word   db_snccnt;		/* used by the sonic driver */
	word   db_rcvportno;		/* received port number  */
	word   db_xmtportlist;          /* transmit port list */
	word   db_snctda; 		/* pointer to sonic TDA */
	word   nb_tstamp;		/* time stamp (all 32 bits) */
	word   nb_flags; 		/* packet flags */
	word   nb_len;			/* number bytes of data in pkt */
	byte  *nb_prot;			/* pointer to next protocol field */
	word   nb_con;  		/* pointer to connection */
	shrt   nb_uu1 : 4;		/* unused */
	shrt   nb_thl : 4;		/* tcp header length */
	shrt   nb_fin : 1;		/* fin bit */
	shrt   nb_syn : 1;		/* syn bit */
	shrt   nb_rst : 1;		/* reset bit */
	shrt   nb_psh : 1;		/* push bit */
	shrt   nb_fack: 1;		/* ack valid */
	shrt   nb_furg: 1;		/* urgent ptr. valid */
	shrt   nb_uu2 : 2;		/* unused */
	/* DO NOT declare anything between nb_uu2 and nb_urg */
	shrt   nb_urg;			/* transmission urgent seq. number */
	word   nb_seq;			/* transmission sequence number */
	word   db_index; 
	};

typedef	struct dbd	DBD;

#define DBD_MARK 	0x7777	/* mark that this is a DBD */

/* DBD db_contrl bit fields */
#define DBDINXMT	0x80	/* INDIC that dbd is in transmit queue */
#define DBDFREE 	0x40	/* CMD that pkt should be freed after xmt */


/* nb_flags */
#define	PKT_TX_BROADCAST	0x0001
#define	PKT_RCV_BROADCAST	0x0002
#define	PKT_IP_BROADCAST	0x0004	/* set on receive */
#define	PKT_IEEEHDR	0x0008	/* set on receive or transmit */
#define	PKT_SENTOUT	0x0010	/* packet has been sent */
#define	PKT_SLIP	0x0100	/* set on receive or transmit	*/
#define	PKT_ADMIN	0x0200	/* set on receive or transmit	*/

#define getfree()  snc_get_dbd()
#define putfree(p) snc_put_dbd(p)

/* NID is defined in pkt.h also */
#ifndef __NID_DEF
#define	__NID_DEF
typedef struct nid_struct
	{
	shrt nid[3];
	} NID;
#endif	__NID_DEF
#endif
