/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

/*  Copyright 1983 by the Massachusetts Institute of Technology  */

#ifndef	__ICMP_H
#define	__ICMP_H

/* Define some ICMP messages */
#define	PGNOSND		0	/* Couldn't send pkt */
#define	PGTMO		1	/* timedout */
#define	PGBADDATA	2	/* rcved bad data back */
#define	PGWAITING	3	/* waiting for rcpt of packet */
#define	PGSUCCESS	4	/* success */

#define	DSTNET		0
#define	DSTHOST		1
#define	DSTPROT		2
#define	DSTPORT		3
#define	DSTFRAG		4
#define	DSTSRC		5


/*  SNMP statistical counters for ICMP */
struct	icmp_stat
	{
	ulong	inmsg;		/*	icmp 1	*/
	ulong	inerr;		/*	icmp 2	*/
	ulong	indstunrch;	/*	icmp 3	*/
	ulong	intimexcd;	/*	icmp 4	*/
	ulong	inparmprob;	/*	icmp 5	*/
	ulong	insourcq;	/*	icmp 6	*/
	ulong	inredir;	/*	icmp 7	*/
	ulong	inecho;		/*	icmp 8	*/
	ulong	inechorep;	/*	icmp 9	*/
	ulong	intmstmp;	/*	icmp 10	*/
	ulong	intmstmprep;	/*	icmp 11	*/
	ulong	inaddrmasks;	/*	icmp 12	*/
	ulong	inaddrmasksrep;	/*	icmp 13	*/
	ulong	outmsg;		/*	icmp 14	*/
	ulong	outerr;		/*	icmp 15	*/
	ulong	outdstunrch;	/*	icmp 16	*/
	ulong	outtimexcd;	/*	icmp 17	*/
	ulong	outparmprob;	/*	icmp 18	*/
	ulong	outsourcq;	/*	icmp 19	*/
	ulong	outredir;	/*	icmp 20	*/
	ulong	outecho;	/*	icmp 21	*/
	ulong	outechorep;	/*	icmp 22	*/
	ulong	outtmstmp;	/*	icmp 23	*/
	ulong	outtmstmprep;	/*	icmp 24	*/
	ulong	outaddrmasks;	/*	icmp 25	*/
	ulong	outaddrmasksrep;	/*	icmp 25	*/
	};

typedef	struct icmp_stat	ICMP_STAT;

extern	ICMP_STAT	IcmpStat;

#define icmp_inmsg	IcmpStat.inmsg
#define icmp_inerr	IcmpStat.inerr
#define icmp_indstunrch	IcmpStat.indstunrch
#define icmp_intimexcd	IcmpStat.intimexcd
#define icmp_inparmprob	IcmpStat.inparmprob
#define icmp_insourcq	IcmpStat.insourcq
#define icmp_inredir	IcmpStat.inredir
#define icmp_inecho	IcmpStat.inecho
#define icmp_inechorep	IcmpStat.inechorep
#define icmp_intmstmp	IcmpStat.intmstmp
#define icmp_outmsg	IcmpStat.outmsg
#define icmp_outerr	IcmpStat.outerr
#define icmp_outdstunrch	IcmpStat.outdstunrch
#define icmp_outecho	IcmpStat.outecho
#define icmp_outechorep	IcmpStat.outechorep
#define icmp_outtmstmprep	IcmpStat.outtmstmprep
#endif
