/*****************************************************************************
 *     Copyright (c) 1986,1988	Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#if (!defined(localio_inc))
#define localio_inc

typedef unsigned char uchar;

typedef unsigned char  *POINTER;

typedef struct LCL_FILE_S
{
	uchar	lcl_flags;
	POINTER	lbuf_start;
	POINTER	lbuf_next;
	POINTER	lbuf_end;	/* Address AFTER last byte */
} LCL_FILE;
#define LCL_MALLOC  0x01    /* LCL_FILE was malloc-ed at open */
#define LCL_EOF	    0x80    /* EOF encountered */

#define Lcl_Eof(L) ((((LCL_FILE *)(L))->lcl_flags&LCL_EOF)?-1:0)

#define Lcl_Tell(L) (int)(((LCL_FILE *)(L))->lbuf_next- \
		     ((LCL_FILE *)(L))->lbuf_start)

#if defined(__STDC__)
extern	void     Lcl_Open(LCL_FILE *, uchar *, int);
extern	void	 Lcl_Close(LCL_FILE *);
extern	int	     Lcl_Getc(LCL_FILE *);
extern	int	     Lcl_Peekc(LCL_FILE *);
extern	int	     Lcl_Read(LCL_FILE *, uchar *, int);
extern	int	     Lcl_Seek(LCL_FILE *, int, int);
extern	int	     Lcl_Resize(LCL_FILE *, int, int);
#endif	/* __STDC__ */

#endif
