/**
 *	Program Name:	nim960 program
 *
 *	Filename:	mtcpblk.h
 *
 *	$Log:   /b/gregs/i960/include/mtcpblk.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:43:58   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:22:30   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:22:38   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:42:20   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:38:18   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:28:38   gregs
 * Initial revision.
 * 
 *    Rev 1.2   19 May 1993 14:42:00   vinay
 * changed the default size of segment size to 960 
 * 
 *    Rev 1.1   08 May 1992 13:27:08   ramki
 * Changed the value of DFLT_MSS
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
/*
mtcpblk.h - header file for data structures associated with the PC/TCP
multiple-connection TCP.

Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.

Edit History
26-Aug-86	jbvb	Added output buffer queue storage
03-Sep-86	jbvb	Use general-purpose queue routines.
10-Sep-86	jbvb	Cleaned up for inclusion in 2.0
02-Dec-86	jbvb	Added out_q_lock (in_write() can block)
26-Dec-86	jbvb	Added ptr & size for ahead-of-seq packet holding,
			 per-connection storage for max seg data size.
05-Jan-86	jbvb	Eliminated cur_win as redundant, added probe_tm.
17-Apr-87	jbvb	Declare tcp_set_mss(), DFLT_MSS
??-Aug-87	romkey	Add some 2.0 conditionals.
20-Aug-87	jbvb	Add macro for TCP error checks (TCERR)
20-Sep-87	jbvb	Correct above macro.
*/

/* Copyright 1984 by the Massachusetts Institute of Technology  */

#ifndef	__MTCPBLK_H
#define	__MTCPBLK_H

#define MAXBUF	    1518		/* maximum output buffer size, - 1? */
#define DFLT_MSS    960		/* Default value for outgoing MSS option */

typedef struct tcpcon
	{	/* State information for a TCP connection */
	int	conn_state;	/* connection state */

/* CLOSED,LISTEN,SYNSENT,ESTAB,TIMEWAIT same as in tcp spec */
/* The numbering here is important, since this test:  conn_state >= SIMUL
 * is used to determine if a FIN has been seen 
 */
#define CLOSED		1	/* nothing has happenned             */
#define	LISTEN		2	/* passive open listen state */
#define SYNSENT		3	/* connection requested              */
#define SYNRCVD		4
#define ESTAB		5	/* connection established            */
#define FINSENT		6	/* local user wishes to close        */
				/* same as FIN-WAIT-1 in tcp spec    */
#define FINACKED	7	/* local user's close request acked  */
				/* same as FIN-WAIT-2 in tcp spec    */
#define SIMUL		8	/* local user and foreign host wish to close*/
				/* same as CLOSING in tcp spec       */
#define FINRCVD		9 	/* foreign host wishes to close      */
				/* same as CLOSE-WAIT in tcp spec    */
#define R_AND_S		10 	/* frgn close req rcvd, local close req sent*/
				/* same as LAST-ACK in tcp spec      */
#define TIMEWAIT	11	/* last ack is being sent            */

	in_name fhost;		/* foreign host */
	uint	dstport;	/* destination ports */
	uint	srcport;	/* source port */

	seq_t	out_q_seqn;	/* next sequence number to use */
	MBOX	out_q;		/* pointer to queue of output buffers */

	PACKET	saved_pkt;	/* pointer to saved ahead-of-eequence pkt */
	int 	saved_len;	/*  & its length */

	int 	max_data;	/* MSS - sizeof(struct tcp) for this conn. */

	uint	frn_win;	/* size of foreign window */
	uint	loc_win;	/* local window sizes */
	uint	loc_lowwater;
	seq_t	cur_ack;	/* byte to ack in any packets sent */
	TIMER	tcptm;		/* The tcp timer */
	uint 	retry_time;	/* retransmission timeout (tcptm ticks)*/
	uint	tw_to_live;	/* See below: Max # pkts to send in timewait*/
	uint 	tc_alive;	/* keep alive countdown timer */

	uint	SendReason;	/* set when packet to send, or in timewait */
	uint 	tc_mustrun;	/* flag that this connection xmtr wants to run */
#define	TC_RUN_SEND_DATA	0x01	/*	to send a data packet	*/
#define	TC_RUN_SEND_ACK		0x02	/*	to send an ack packet	*/
#define	TC_RUN_SEND_ALIVE	0x04	/*	keep alive pacekt	*/

	struct	tcpph ophp;	/* tcp psuedo header for checksum calc. */

	int	(*tc_open)();	/* called to signal open channel */
	int	(*tc_dispose)();/* called to send user the data */
	int	(*tc_fclose)();	/* called when foreign host wants to close */
/*	int	(*tc_close)();	/* called when both sides have closed */
	in_name	lhost;		/* Local host address */

	void 	*ufield;	/* user defined data field */
	uint	osrcport;	/* original source port */
	struct tcpcon *tc_flink;
	struct tcpcon *tc_blink;
	in_name	tc_fhop;	/* first hop in_name */
	NID	tc_nid;  	/* first hop ethernet address */
	uint 	tc_flags;	/* packet flags */
	byte	*tc_stats;	/* pointer to stats structure */
	byte counters[20];	/* Extra space needed for LAT counters...Ramki */
	}  tcp_con, *TcpCon;

/* Timer Timeouts.  These can vastly affect the performance of TCP
   INITRT: long so that no extra SYN destroys the opening
   TW_TIME: long so we can respond to a foreign rexmit before closing
   CONNRT: default retransmit timeout for opening connection
   RTT_LOW: low limit for retransmit time on a connection
   RTT_HI: high limit for retransmit time on a connection
   ACKDALLY: short for TELNET, zero for PC-PC telnet sending bulk data
   RTT_RETRY: If packet was resent more than this many times, double the
		retry time anyway, because it is probably far too short.
*/

#define	INITRT		4 * TPS	/* retry time(secs)--initial request */
#define TW_TIME		1 * TPS	/* timewait close time(secs) */
#define CONNRT		2 * TPS /* Default to 2 seconds for starts */
#define RTT_LOW		TPS / 2 /* Use 1/2 of a second for low limit */
#define RTT_HI		60 * TPS /* Use one minute for high limit */

#define ACKDALLY	5	/* delay from rcv->pkt to send->ack */
#define RTT_RETRY	3	/* X retries means retry_time too short */
#define RTT_MAX    32   /* max retry count */

#define	TCP_PROBE	60 * TPS /* Probe 0-length windows after this time */

/* A bug in TCP is that two TCP's can simultaneously close, both reach
 * TIMEWAIT, and a single leftover packet can then cause a deadlock of acks
 * to go flying from both sides.  TW_MAX limits the number of ACKS that
 * can be sent out.
 */
#define	TW_PKTS		3	/* max # of addt'l timewait pkts to send */

#define	TCPWINDOW	1536	/* normal advertised window */
#define	TCPLOWIND	512	/* low water mark on window */


#ifndef	TRUE			/* makes lint happy */
#define	TRUE		1
#define	FALSE		0
#endif


#define	TCDBG	(TPTRACE & NDEBUG)
#define	TCERR	(NDEBUG & (TPTRACE | PROTERR))

extern	IPCONN	tcpfd;			/* con ID for calling internet */
extern  uint	tcp_next_socket;
extern	struct	tcpph	iphp;		/* incoming pseudohdr for cksum calc */

#define	OutOfBounds(x,y,z)	(x < y | x > z)

/* type safe user functions.  They may be inefficient, but finding */
/* this kind of bug is a bitch + 2 (I had to once) */

#define tcp_setu(xx,yy)	(xx->usafe = TRUE,xx->ufield= (int *) yy)
#define tcp_getu(xx)	(xx->usafe ? xx->ufield : (int *)tc_errmsg())
#define tcp_is_open(xx) (((xx)->conn_state == ESTAB) || \
			 ((xx)->conn_state == FINRCVD))

#endif
