
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	memory.h
*
*	$Log:   /b/gregs/i960/include/memory.fsv  $
   
      Rev 1.0   30 Jul 1993 13:38:46   franks
   Initial revision.
 * 
 *    Rev 1.2   05 Mar 1993 15:07:12   kwok
 * FOIRL card type can be either 0x8000 or 0xA000
 * 
 *    Rev 1.1   10 Apr 1992 13:03:22   kwok
 * Adding defines for the transceiver type.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:34   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************
 * This file contains the memory map definitions for the hub bridge cards.
 ******************************************************************/
#ifndef __MEMORY_H
#define __MEMORY_H	0x100a	/* V1.00a */

/*
 * This section defines the basic memory locations.
 */
#define BEPROM64  	0xffff0000	/* 08b EPROM for the preboot code (64 K)*/
#define BEPROM128  	0xfffe0000	/* 08b EPROM for the preboot code (128 K)*/
#define EEPROM  	0xc0010000	/* 16b EEPROM for nvram data */
#define FEPROM  	0xe0000000	/* 32b Flash EPROM for boot&application */
#define PERIPHIO 	0x80000000	/* 08b UART, TIMER, etc */
#define SONICIO  	0x70000000	/* 16b SONIC regs: 0x100 per chip */
#define DRAM    	0x30000000	/* 32b DRAM for code and data */
#define SRAM    	0x2ffe0000	/* 32b SRAM for code and data */
#define SHRAM   	0x50000000	/* 32b Shared SRAM for CPU & SONIC */
#define NVRAM		0xc0000000	/* 8b NVRAM */
#define ADMRAM		0xa0000000	/* 8b NVRAM */
#define	ADMRAM_SIZE	(32 * 1024)	/* 32 k 	*/
/*
 *	Data size reserved for important data in the beginning of 
 *	SRAM.
 */
#define	SYS_DATA_SIZE	0x00010000		/* 64 K 	*/

/* divisions of SONICIO */
#define SONIC_IO_SPC	0x80	/* 100 between each sonic */

/* divisions of PERIPHIO */
#define UARTIO	(PERIPHIO+0x0000)	/* Location of the UART regs */
#define TIMERIO	(PERIPHIO+0x0020)	/* Location of the TIMER regs */
#define LEDIO	(PERIPHIO+0x0040) /* Location of LED's */
#define LEDBIO	(PERIPHIO+0x0040) /* Location of LED's */
#define LEDMIO	(PERIPHIO+0x0060) /* Location of LED's */
#define	HUBIDIO	(PERIPHIO+0x0040)	/* hub id 	*/
#define DIPIO	(PERIPHIO+0x0060) /* Location of DIP_SWITCHES */
#define WDOGIO	(PERIPHIO+0x0080) /* Location of Watch Dog strobe */
#define	CARRIERIO	(PERIPHIO+0x00a0)	/* location of lan carrier 
						 * sense, back plane type 
						 * and slot id */
#define SNCENA	(PERIPHIO+0x00c0)	/* reset control lines for the Sonics */
#define	CONTROL_IO	(PERIPHIO+0x00e0)/* control port io	*/


#define	SLOTID_MASK	0x0f		/* slot id bits are d0 - d3	*/
#define	BACK_PLANE_TYPE_MASK	0x60	/* it is d5 and d6		*/
#define	BACK_PLANE_STANDALONE	0x60	/* d5 and d6 are set for this	*/
#define	SYSCARD_INSTALLED	0x10	/* d4 is 0 if a system card is installed */

#define	TRANSCEIVER_TYPE_MASK	0xE000	/* d13 - d15 for transceiver type */
#define	TRANSCEIVER_AUI		0x0000	/* AUI 		*/
#define	TRANSCEIVER_THIN_NET	0x2000	/* THIN NET	*/
#define	TRANSCEIVER_10BASET	0x4000	/* 10 base T	*/
#define	TRANSCEIVER_FOIRL	0x8000
#define	TRANSCEIVER_FOIRL_ALT	0xA000	/* alternative FOIRL 	*/
#define	TRANSCEIVER_BLANK	0xE000	

#endif /* __MEMORY_H */
