#include <types.h>

/* BUFSIZ and MAX_OLDBUF values should always be power of 2 */
#define BUFSIZ	256		/* size of buffer */
#define MAX_OLDBUF	8	/* number of line history buffer */

typedef struct tty_space
	{
	int   t_col;		/* column positioning */
	char *t_nxt;	 	/* pointer for reading next char */
	char  t_buf[BUFSIZ];	/* place for 256 chars */
	char  t_oldbuf[MAX_OLDBUF][BUFSIZ];/* place for 256 chars */
	int   t_writeindex;
	int   t_readindex;
	int   t_echo;		/* enable echo */
	int   t_mode;		/* raw or cooked mode */
	int   t_lastchar;
	} TTY;

#define TTYPTR		1
#define TTYBAUD 	2
#define TTYDEBUG 	3
#define TTYMODE		4
#define TTYFLOW		5
#define TTYBREAK	6
#define TTYFLUSH	7

#define FLUSH_INPUT	1
#define FLUSH_OUTPUT	2
#define FLUSH_INPUT_OUTPUT	3

#define DEBUGOFF	0
#define DEBUGON		1

#define FLOWOFF		0
#define FLOWON		1

#define COOKED		0
#define RAW		1
#define NONBLOCKING	2


extern fputc(int c, int handle);
extern putc(int c, int handle);
extern fgetc(int handle);
extern ungetc(int c, int handle);
extern getc(int handle);
extern char *fgets(char *s, int n, int handle);
extern char *gets(char *s);
extern fputs(const char *s, int handle);
extern puts(char *s);
extern fflush(int handle);
extern flush();
extern fopen(int dev, char *name, char *mode);
extern fclose(int handle);
