
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	krnlasm.s
*
*	$Log:   /b/gregs/i960/kernel/krnlasm.s_v  $
   
      Rev 1.5   12 Oct 1993 09:54:12   franks
   No change.
   
      Rev 1.4   29 Sep 1993 10:23:14   franks
   No change.
   
      Rev 1.3   10 Sep 1993 15:23:28   franks
   No change.
   
      Rev 1.2   08 Sep 1993 11:21:06   gregs
   Change the way in which the FDDI routines are polled.
   Initial SIT Release
   
      Rev 1.1   30 Jul 1993 13:46:08   franks
   No change.
   
      Rev 1.0   07 Jul 1993 11:11:28   franks
   Initial revision.
   
      Rev 1.1   13 May 1992 11:51:46   suresh
   Aligned the routines to 16 byte boundary.
   
      Rev 1.0   30 Mar 1992 16:56:06   pvcs
   Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

gcc_compiled.:
.text

#
# -- Timer Ticks Interrupt.
#

	.globl	_TimeTicksInt
	.align	4
_TimeTicksInt:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	/***callx _Test_TimeTicksInt***/
	callx _TimeTicks

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret


	.globl	_TimeSliceInt
	.align	4
_TimeSliceInt:
	lda  _save_regs, r4
	stq  g0, (r4)
	stq  g4, 16(r4)
	stq  g8, 32(r4)
	stt  g12, 48(r4)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */


	mov	1,g0
	callj	_enable_imsk
	ld	_pkt_proc_upcall,g4
	callx	(g4)
	mov		0,g0				/* BSI no. */
	mov		g0,g1
	ldob	_drv_init_flag, g1
	cmpibe	g0,g1,doSonicTx		/* br if fddi driver not initialized */
	callj	_ProcessFddiFrames
	mov		0,g0				 /* MAC no. */
	callj	_BMAC_PollRingOp				
doSonicTx:
	callj	_snc_fpd_pkt
	callj	_poll_uart
	callj	_scc_receive
	callj	_get_ipnd
	bbc.f	0,g0,skip_timer
	callj	_TimeTicks
	mov	1,g0
	callj	_clear_ipnd
skip_timer:
	/***callx	_Test_TimeSliceInt***/
	callj	_RetriggerTimeSliceTimer

	lda  _save_regs, r4
	ldq  (r4), g0
	ldq  16(r4), g4
	ldq  32(r4), g8
	ldt  48(r4), g12
	mov  r3, sf1	
	ret

	.globl	_TimeTicksSliceInt
	.align	4
_TimeTicksSliceInt:
	lda  _save_regs, r4
	stq  g0, (r4)
	stq  g4, 16(r4)
	stq  g8, 32(r4)
	stt  g12, 48(r4)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

/*
	callj	_ClearPortLedStatus
*/
	ld	_pkt_proc_upcall,g4
	callx	(g4)
	callj	_snc_fpd_pkt
	callj	_poll_uart
/*
	callj	_FlkPortLeds
*/
	callj	_TimeTicks

	lda  _save_regs, r4
	ldq  (r4), g0
	ldq  16(r4), g4
	ldq  32(r4), g8
	ldt  48(r4), g12
	mov  r3, sf1	
	ret

